/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.jcajce.util.JcaJceHelper;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoUtils;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

class RSAUtil {
    RSAUtil() {
    }

    static String getDigestSigAlgName(String name) {
        int dIndex = name.indexOf(45);
        if (dIndex > 0 && !name.startsWith("SHA3")) {
            return String.valueOf(name.substring(0, dIndex)) + name.substring(dIndex + 1);
        }
        return name;
    }

    static AlgorithmParameterSpec getPSSParameterSpec(int cryptoHashAlgorithm, String digestName, JcaJceHelper helper) {
        int saltLength = TlsCryptoUtils.getHashOutputSize(cryptoHashAlgorithm);
        MGF1ParameterSpec mgf1Spec = new MGF1ParameterSpec(digestName);
        return new PSSParameterSpec(digestName, "MGF1", mgf1Spec, saltLength, 1);
    }
}

