/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.util;

import cn.win_trust_erpc.bouncycastle.util.StringList;
import cn.win_trust_erpc.bouncycastle.util.encoders.UTF8;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Vector;

public final class Strings {
    private static String LINE_SEPARATOR;

    static {
        try {
            LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        catch (Exception e) {
            try {
                LINE_SEPARATOR = String.format("%n", new Object[0]);
            }
            catch (Exception ef) {
                LINE_SEPARATOR = "\n";
            }
        }
    }

    public static String fromUTF8ByteArray(byte[] bytes) {
        char[] chars = new char[bytes.length];
        int len = UTF8.transcodeToUTF16(bytes, chars);
        if (len < 0) {
            throw new IllegalArgumentException("Invalid UTF-8 input");
        }
        return new String(chars, 0, len);
    }

    public static byte[] toUTF8ByteArray(String string) {
        return Strings.toUTF8ByteArray(string.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] string) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            Strings.toUTF8ByteArray(string, bOut);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
        return bOut.toByteArray();
    }

    public static void toUTF8ByteArray(char[] string, OutputStream sOut) throws IOException {
        char[] c = string;
        int i = 0;
        while (i < c.length) {
            char ch = c[i];
            if (ch < '\u0080') {
                sOut.write(ch);
            } else if (ch < '\u0800') {
                sOut.write(0xC0 | ch >> 6);
                sOut.write(0x80 | ch & 0x3F);
            } else if (ch >= '\ud800' && ch <= '\udfff') {
                if (i + 1 >= c.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char W1 = ch;
                char W2 = ch = c[++i];
                if (W1 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int codePoint = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                sOut.write(0xF0 | codePoint >> 18);
                sOut.write(0x80 | codePoint >> 12 & 0x3F);
                sOut.write(0x80 | codePoint >> 6 & 0x3F);
                sOut.write(0x80 | codePoint & 0x3F);
            } else {
                sOut.write(0xE0 | ch >> 12);
                sOut.write(0x80 | ch >> 6 & 0x3F);
                sOut.write(0x80 | ch & 0x3F);
            }
            ++i;
        }
    }

    public static String toUpperCase(String string) {
        boolean changed = false;
        char[] chars = string.toCharArray();
        int i = 0;
        while (i != chars.length) {
            char ch = chars[i];
            if ('a' <= ch && 'z' >= ch) {
                changed = true;
                chars[i] = (char)(ch - 97 + 65);
            }
            ++i;
        }
        if (changed) {
            return new String(chars);
        }
        return string;
    }

    public static String toLowerCase(String string) {
        boolean changed = false;
        char[] chars = string.toCharArray();
        int i = 0;
        while (i != chars.length) {
            char ch = chars[i];
            if ('A' <= ch && 'Z' >= ch) {
                changed = true;
                chars[i] = (char)(ch - 65 + 97);
            }
            ++i;
        }
        if (changed) {
            return new String(chars);
        }
        return string;
    }

    public static byte[] toByteArray(char[] chars) {
        byte[] bytes = new byte[chars.length];
        int i = 0;
        while (i != bytes.length) {
            bytes[i] = (byte)chars[i];
            ++i;
        }
        return bytes;
    }

    public static byte[] toByteArray(String string) {
        byte[] bytes = new byte[string.length()];
        int i = 0;
        while (i != bytes.length) {
            char ch = string.charAt(i);
            bytes[i] = (byte)ch;
            ++i;
        }
        return bytes;
    }

    public static int toByteArray(String s, byte[] buf, int off) {
        int count = s.length();
        int i = 0;
        while (i < count) {
            char c = s.charAt(i);
            buf[off + i] = (byte)c;
            ++i;
        }
        return count;
    }

    public static boolean constantTimeAreEqual(String a, String b) {
        boolean isEqual = a.length() == b.length();
        int len = a.length();
        int i = 0;
        while (i != len) {
            isEqual &= a.charAt(i) == b.charAt(i);
            ++i;
        }
        return isEqual;
    }

    public static String fromByteArray(byte[] bytes) {
        return new String(Strings.asCharArray(bytes));
    }

    public static char[] asCharArray(byte[] bytes) {
        char[] chars = new char[bytes.length];
        int i = 0;
        while (i != chars.length) {
            chars[i] = (char)(bytes[i] & 0xFF);
            ++i;
        }
        return chars;
    }

    public static String[] split(String input, char delimiter) {
        Vector<String> v = new Vector<String>();
        boolean moreTokens = true;
        while (moreTokens) {
            int tokenLocation = input.indexOf(delimiter);
            if (tokenLocation > 0) {
                String subString = input.substring(0, tokenLocation);
                v.addElement(subString);
                input = input.substring(tokenLocation + 1);
                continue;
            }
            moreTokens = false;
            v.addElement(input);
        }
        String[] res = new String[v.size()];
        int i = 0;
        while (i != res.length) {
            res[i] = (String)v.elementAt(i);
            ++i;
        }
        return res;
    }

    public static StringList newList() {
        return new StringListImpl();
    }

    public static String lineSeparator() {
        return LINE_SEPARATOR;
    }

    private static class StringListImpl
    extends ArrayList<String>
    implements StringList {
        private StringListImpl() {
        }

        @Override
        public boolean add(String s) {
            return super.add(s);
        }

        @Override
        public String set(int index, String element) {
            return super.set(index, element);
        }

        @Override
        public void add(int index, String element) {
            super.add(index, element);
        }

        @Override
        public String[] toStringArray() {
            String[] strs = new String[this.size()];
            int i = 0;
            while (i != strs.length) {
                strs[i] = (String)this.get(i);
                ++i;
            }
            return strs;
        }

        @Override
        public String[] toStringArray(int from, int to) {
            String[] strs = new String[to - from];
            int i = from;
            while (i != this.size() && i != to) {
                strs[i - from] = (String)this.get(i);
                ++i;
            }
            return strs;
        }
    }
}

