/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.gson.internal.sql;

import cn.win_trust_erpc.gson.Gson;
import cn.win_trust_erpc.gson.JsonSyntaxException;
import cn.win_trust_erpc.gson.TypeAdapter;
import cn.win_trust_erpc.gson.TypeAdapterFactory;
import cn.win_trust_erpc.gson.reflect.TypeToken;
import cn.win_trust_erpc.gson.stream.JsonReader;
import cn.win_trust_erpc.gson.stream.JsonToken;
import cn.win_trust_erpc.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class SqlTimeTypeAdapter
extends TypeAdapter<Time> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new SqlTimeTypeAdapter(null) : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    private SqlTimeTypeAdapter() {
    }

    @Override
    public synchronized Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            Date date = this.format.parse(in.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Time value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }

    /* synthetic */ SqlTimeTypeAdapter(SqlTimeTypeAdapter sqlTimeTypeAdapter) {
        this();
    }
}

