/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.CRLParameters;
import cn.com.infosec.netsign.der.util.DERObjectGenerater;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.der.util.RevokedCertificate;
import java.io.IOException;
import java.util.ArrayList;

public class CRLGenerater
extends DERObjectGenerater {
    private byte[] version;
    private byte[] signatureAlg;
    private byte[] issuer;
    private byte[] thisUpdate;
    private byte[] nextUpdate;
    private byte[] revokedCertificates;
    private byte[] crlExtensions;
    private CRLParameters para;
    private byte[] tbs;
    private byte[] signature;

    public CRLGenerater(CRLParameters para) {
        this.para = para;
    }

    public byte[] generateCRL() {
        byte[] cert = this.tbs;
        cert = DERUtil.connect(cert, this.signatureAlg);
        cert = DERUtil.connect(cert, this.signature);
        return DERUtil.generateDERCode(48, cert);
    }

    public byte[] generateTBSCRL() throws IOException {
        this.tbs = new byte[0];
        this.version = DERUtil.generateDERCode(2, new byte[]{1});
        this.tbs = DERUtil.connect(this.tbs, this.version);
        this.signatureAlg = this.generateAlgorithmIdentifier(this.para.getSignatureAlgOid());
        this.tbs = DERUtil.connect(this.tbs, this.signatureAlg);
        this.issuer = this.generateDN(this.para.getIssuer());
        this.tbs = DERUtil.connect(this.tbs, this.issuer);
        this.thisUpdate = DERUtil.date2ASN1(this.para.getThisUpdate());
        this.tbs = DERUtil.connect(this.tbs, this.thisUpdate);
        this.nextUpdate = DERUtil.date2ASN1(this.para.getNextUpdate());
        this.tbs = DERUtil.connect(this.tbs, this.nextUpdate);
        this.revokedCertificates = this.generateRevokedCertificates();
        this.tbs = DERUtil.connect(this.tbs, this.revokedCertificates);
        if (this.para.getCrlExtensions() != null && this.para.getCrlExtensions().size() > 0) {
            this.crlExtensions = this.generateExtensions(this.para.getCrlExtensions());
            this.tbs = DERUtil.connect(this.tbs, this.crlExtensions);
        }
        this.tbs = DERUtil.generateDERCode(48, this.tbs);
        return this.tbs;
    }

    private byte[] generateRevokedCertificates() {
        byte[] bs = new byte[]{};
        ArrayList certs = this.para.getRevokedCertificates();
        if (certs != null && certs.size() > 0) {
            int i = 0;
            int size = certs.size();
            while (i < size) {
                byte[] rcbs = new byte[]{};
                RevokedCertificate rc = (RevokedCertificate)certs.get(i);
                byte[] sn = DERUtil.generateDERCode(2, rc.getRevokedSerialNumber().toByteArray());
                rcbs = DERUtil.connect(rcbs, sn);
                byte[] gentime = DERUtil.date2ASN1(rc.getRevokedTime());
                rcbs = DERUtil.connect(rcbs, gentime);
                if (rc.getExtensions() != null && rc.getExtensions().size() > 0) {
                    byte[] exts = this.generateExtensions(rc.getExtensions());
                    rcbs = DERUtil.connect(rcbs, exts);
                }
                rcbs = DERUtil.generateDERCode(48, rcbs);
                bs = DERUtil.connect(bs, rcbs);
                ++i;
            }
        }
        return DERUtil.generateDERCode(48, bs);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        byte[] tmp = new byte[signature.length + 1];
        System.arraycopy(signature, 0, tmp, 1, signature.length);
        signature = tmp;
        this.signature = DERUtil.generateDERCode(3, signature);
    }

    public byte[] getVersion() {
        return this.version;
    }

    public void setVersion(byte[] version) {
        this.version = version;
    }

    public byte[] getSignatureAlg() {
        return this.signatureAlg;
    }

    public void setSignatureAlg(byte[] signatureAlg) {
        this.signatureAlg = signatureAlg;
    }

    public byte[] getIssuer() {
        return this.issuer;
    }

    public void setIssuer(byte[] issuer) {
        this.issuer = issuer;
    }

    public byte[] getThisUpdate() {
        return this.thisUpdate;
    }

    public void setThisUpdate(byte[] thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public byte[] getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(byte[] nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public byte[] getRevokedCertificates() {
        return this.revokedCertificates;
    }

    public void setRevokedCertificates(byte[] revokedCertificates) {
        this.revokedCertificates = revokedCertificates;
    }

    public byte[] getCrlExtensions() {
        return this.crlExtensions;
    }

    public void setCrlExtensions(byte[] crlExtensions) {
        this.crlExtensions = crlExtensions;
    }

    public CRLParameters getPara() {
        return this.para;
    }

    public void setPara(CRLParameters para) {
        this.para = para;
    }

    public byte[] getTbs() {
        return this.tbs;
    }

    public void setTbs(byte[] tbs) {
        this.tbs = tbs;
    }
}

