/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.Certificate;
import cn.com.infosec.netsign.der.util.DERObjectGenerater;
import cn.com.infosec.netsign.der.util.DERUtil;
import java.io.IOException;

public class CertificateGenerater
extends DERObjectGenerater {
    private Certificate para;
    private byte[] version;
    private byte[] serialNumber;
    private byte[] signatureAlg;
    private byte[] issuer;
    private byte[] validity;
    private byte[] subject;
    private byte[] publicKeyInfo;
    private byte[] extensions;
    private byte[] tbs;
    private byte[] signature;

    public CertificateGenerater(Certificate para) {
        this.para = para;
    }

    public byte[] generateTBSCertificate() throws IOException {
        this.tbs = new byte[0];
        this.version = DERUtil.generateDERCode(2, new byte[]{2});
        this.version = DERUtil.generateDERCode(160, this.version);
        this.tbs = DERUtil.connect(this.tbs, this.version);
        this.serialNumber = this.para.getSerailNumber().toByteArray();
        this.serialNumber = DERUtil.generateDERCode(2, this.serialNumber);
        this.tbs = DERUtil.connect(this.tbs, this.serialNumber);
        this.signatureAlg = this.generateAlgorithmIdentifier(this.para.getSignatureAlgOid());
        this.tbs = DERUtil.connect(this.tbs, this.signatureAlg);
        this.issuer = this.generateDN(this.para.getIssuer());
        this.tbs = DERUtil.connect(this.tbs, this.issuer);
        this.validity = this.generateValidity();
        this.tbs = DERUtil.connect(this.tbs, this.validity);
        this.subject = this.generateDN(this.para.getSubject());
        this.tbs = DERUtil.connect(this.tbs, this.subject);
        this.publicKeyInfo = this.generatePublickeyInfo();
        this.tbs = DERUtil.connect(this.tbs, this.publicKeyInfo);
        if (this.para.getExtensions() != null && this.para.getExtensions().size() > 0) {
            this.extensions = this.generateExtensions(this.para.getExtensions());
            this.tbs = DERUtil.connect(this.tbs, this.extensions);
        }
        this.tbs = DERUtil.generateDERCode(48, this.tbs);
        return this.tbs;
    }

    public byte[] generateCertificate() {
        byte[] cert = this.tbs;
        cert = DERUtil.connect(cert, this.signatureAlg);
        cert = DERUtil.connect(cert, this.signature);
        return DERUtil.generateDERCode(48, cert);
    }

    public Certificate getPara() {
        return this.para;
    }

    public void setPara(Certificate para) {
        this.para = para;
    }

    public byte[] getVersion() {
        return this.version;
    }

    public void setVersion(byte[] version) {
        this.version = version;
    }

    public byte[] getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(byte[] serialNumber) {
        this.serialNumber = serialNumber;
    }

    public byte[] getSignatureAlg() {
        return this.signatureAlg;
    }

    public void setSignatureAlg(byte[] signatureAlg) {
        this.signatureAlg = signatureAlg;
    }

    public byte[] getIssuer() {
        return this.issuer;
    }

    public void setIssuer(byte[] issuer) {
        this.issuer = issuer;
    }

    public byte[] getValidity() {
        return this.validity;
    }

    public void setValidity(byte[] validity) {
        this.validity = validity;
    }

    public byte[] getSubject() {
        return this.subject;
    }

    public void setSubject(byte[] subject) {
        this.subject = subject;
    }

    public byte[] getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public void setPublicKeyInfo(byte[] publicKeyInfo) {
        this.publicKeyInfo = publicKeyInfo;
    }

    public byte[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(byte[] extensions) {
        this.extensions = extensions;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        byte[] tmp = new byte[signature.length + 1];
        System.arraycopy(signature, 0, tmp, 1, signature.length);
        signature = tmp;
        this.signature = DERUtil.generateDERCode(3, signature);
    }

    public byte[] getTBSCert() {
        return this.tbs;
    }

    public void setTBSCert(byte[] tbs) {
        this.tbs = tbs;
    }

    private byte[] generateValidity() {
        byte[] notBeforebs = DERUtil.date2ASN1(this.para.getNotBefore());
        byte[] notAfterbs = DERUtil.date2ASN1(this.para.getNotAfter());
        byte[] all = DERUtil.connect(notBeforebs, notAfterbs);
        return DERUtil.generateDERCode(48, all);
    }

    private byte[] generatePublickeyInfo() {
        byte[] oid = DERUtil.oid2ASN1(this.para.getSubjectKeyInfo().getKeyAlgOid());
        oid = DERUtil.generateDERCode(6, oid);
        byte[] keyLength = DERUtil.DERNULL;
        if (this.para.getSubjectKeyInfo().getKeyLength() > 0) {
            keyLength = DERUtil.generateDERCode(2, new byte[]{(byte)this.para.getSubjectKeyInfo().getKeyLength()});
        }
        byte[] keyh = DERUtil.connect(oid, keyLength);
        keyh = DERUtil.generateDERCode(48, keyh);
        byte[] key = DERUtil.generateDERCode(3, this.para.getSubjectKeyInfo().getKey());
        key = DERUtil.connect(keyh, key);
        return DERUtil.generateDERCode(48, key);
    }
}

