/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.DERHead;
import cn.com.infosec.netsign.der.util.DERObject;
import cn.com.infosec.netsign.der.util.DERUtil;

public class DERSegment
implements DERObject {
    private byte[] der;
    private int indexNow = 0;
    private DERHead head;

    public void setIndex(int index) {
        this.indexNow = index;
    }

    public byte[] getEncoded() {
        return this.der;
    }

    public DERSegment(byte[] der) {
        this.der = der;
    }

    public byte getType() {
        return this.der[0];
    }

    public DERHead getDERHead() {
        if (this.head != null) {
            return this.head;
        }
        this.head = DERUtil.parseDERHead(this.der, 0);
        return this.head;
    }

    public void setDERHead(DERHead head) {
        this.head = head;
    }

    public byte[] getInnerData() {
        if (this.head == null) {
            this.head = DERUtil.parseDERHead(this.der, 0);
        }
        byte[] bs = new byte[this.head.getLengthInt()];
        System.arraycopy(this.der, this.head.getLengthOfHead(), bs, 0, bs.length);
        return bs;
    }

    public DERSegment getInnerDERSegment() {
        return new DERSegment(this.getInnerData());
    }

    public boolean hasMoreDERSegment() {
        return this.indexNow < this.der.length;
    }

    public DERSegment nextDERSegment() {
        DERHead head = DERUtil.parseDERHead(this.der, this.indexNow);
        byte[] bs = new byte[head.getLengthInt() + head.getLengthOfHead()];
        System.arraycopy(this.der, this.indexNow, bs, 0, bs.length);
        this.indexNow += bs.length;
        DERSegment dseg = new DERSegment(bs);
        dseg.setDERHead(head);
        return dseg;
    }

    public DERSegment subDERSegment(int index) {
        int i = 0;
        int j = 0;
        while (j < index) {
            DERHead head = DERUtil.parseDERHead(this.der, i);
            i += head.getLengthInt() + head.getLengthOfHead();
            ++j;
        }
        byte[] bs = new byte[this.der.length - i];
        System.arraycopy(this.der, i, bs, 0, bs.length);
        return new DERSegment(bs);
    }

    public DERSegment getDERSegment(int index) {
        DERHead head;
        int i = 0;
        int j = 0;
        while (j < index) {
            head = DERUtil.parseDERHead(this.der, i);
            i += head.getLengthInt() + head.getLengthOfHead();
            ++j;
        }
        head = DERUtil.parseDERHead(this.der, i);
        byte[] bs = new byte[head.getLengthInt() + head.getLengthOfHead()];
        System.arraycopy(this.der, i, bs, 0, bs.length);
        DERSegment dseg = new DERSegment(bs);
        dseg.setDERHead(head);
        return dseg;
    }
}

