/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.DERHead;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DERUtil {
    private static final long DATE_2050 = 2524579200000L;
    public static final byte[] DERNULL;
    public static final byte[] DERTRUE;
    public static final int DER_TYPE_SEQUENCE = 48;
    public static final int DER_TYPE_CONTEXT = 160;
    public static final int DER_TYPE_SET = 49;
    public static final int DER_TYPE_BOOLEAN = 1;
    public static final int DER_TYPE_INTEGER = 2;
    public static final int DER_TYPE_BIT_STRING = 3;
    public static final int DER_TYPE_OCTET_STRING = 4;
    public static final int DER_TYPE_OID = 6;
    public static final int DER_TYPE_UTCTIME = 17;
    public static final int DER_TYPE_UT8STRING = 12;
    public static final int DER_TYPE_PRINTABLESTRING = 19;
    public static final int MAX_SEGMENT_SIZE = 0xC800000;
    private static SimpleDateFormat formatShort8;
    private static SimpleDateFormat formatLong8;
    private static SimpleDateFormat formatShort;
    private static SimpleDateFormat formatLong;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 5;
        DERNULL = byArray;
        DERTRUE = new byte[]{1, 1, -1};
        TimeZone tz = TimeZone.getDefault();
        tz.setRawOffset(8);
        formatShort8 = new SimpleDateFormat("yyMMddHHmmss");
        formatShort8.setTimeZone(tz);
        formatLong8 = new SimpleDateFormat("yyyyMMddHHmmss");
        formatLong8.setTimeZone(tz);
        formatShort = new SimpleDateFormat("yyMMddHHmmss");
        formatLong = new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public static DERHead parseDERHead(byte[] der, int pos) {
        DERHead head = new DERHead();
        head.setType(der[pos]);
        int length = 0;
        int headLength = 2;
        byte[] lengthBytes = null;
        int ab = der[pos + 1] & 0xFF;
        if (ab >= 128) {
            int lengthOfLength = ab - 128;
            headLength = 2 + lengthOfLength;
            lengthBytes = new byte[lengthOfLength];
            System.arraycopy(der, pos + 2, lengthBytes, 0, lengthOfLength);
            length = DERUtil.generateInt(lengthBytes);
            head.setLengthDetail((byte)ab);
        } else {
            lengthBytes = new byte[]{(byte)ab};
            length = ab;
        }
        if (length > 0xC800000) {
            throw new RuntimeException("Der segment too large:" + length);
        }
        head.setLength(lengthBytes);
        head.setLengthInt(length);
        head.setLengthOfHead(headLength);
        return head;
    }

    public static byte[] cutFirstItem(byte[] der) {
        return DERUtil.cutHeadItems(der, 1);
    }

    public static byte[] cutHeadItems(byte[] der, int index) {
        int derStart = 0;
        int length = 0;
        int headLength = 2;
        int i = 0;
        while (i < index) {
            int ab = der[derStart + 1] & 0xFF;
            if (ab >= 128) {
                int lengthOfLength = ab - 128;
                headLength = 2 + lengthOfLength;
                byte[] lengthBytes = new byte[lengthOfLength];
                System.arraycopy(der, derStart + 2, lengthBytes, 0, lengthOfLength);
                length = DERUtil.generateInt(lengthBytes);
            } else {
                length = ab;
            }
            if (i != index - 1) {
                derStart = derStart + length + headLength;
            }
            ++i;
        }
        byte[] bs = new byte[der.length - (derStart + length + headLength)];
        System.arraycopy(der, derStart + length + headLength, bs, 0, der.length - (derStart + length + headLength));
        return bs;
    }

    public static byte[] connect(byte[][] bs) {
        int lengthTotal = 0;
        int i = 0;
        while (i < bs.length) {
            lengthTotal += bs[i].length;
            ++i;
        }
        byte[] total = new byte[lengthTotal];
        int start = 0;
        int i2 = 0;
        while (i2 < bs.length) {
            System.arraycopy(bs[i2], 0, total, start, bs[i2].length);
            start += bs[i2].length;
            ++i2;
        }
        return total;
    }

    public static String getCRLDPURI(byte[] CRLDistributionPoints) {
        byte[] data = DERUtil.getDERInnerData(CRLDistributionPoints);
        data = DERUtil.getDERInnerData(data);
        data = DERUtil.getDERInnerData(data);
        data = DERUtil.getDERInnerData(data);
        data = DERUtil.getDERInnerData(data);
        data = DERUtil.getDERInnerData(data);
        return new String(data);
    }

    public static byte[] getDERInnerData(byte[] der) {
        return DERUtil.getDERInnerData(der, 1);
    }

    public static byte[] getDERInnerData(byte[] der, int index) {
        int derStart = 0;
        int length = 0;
        int headLength = 2;
        int i = 0;
        while (i < index) {
            int ab = der[derStart + 1] & 0xFF;
            if (ab >= 128) {
                int lengthOfLength = ab - 128;
                headLength = 2 + lengthOfLength;
                byte[] lengthBytes = new byte[lengthOfLength];
                System.arraycopy(der, derStart + 2, lengthBytes, 0, lengthOfLength);
                length = DERUtil.generateInt(lengthBytes);
            } else {
                length = ab;
            }
            if (i != index - 1) {
                derStart = derStart + length + headLength;
            }
            ++i;
        }
        byte[] bs = new byte[length];
        System.arraycopy(der, derStart + headLength, bs, 0, length);
        return bs;
    }

    public static byte[] getFirstDERItem(byte[] der) {
        return DERUtil.getDERItem(der, 1);
    }

    public static byte[] getDERItem(byte[] der, int index) {
        int derStart = 0;
        int length = 0;
        int headLength = 2;
        int i = 0;
        while (i < index) {
            int ab = der[derStart + 1] & 0xFF;
            if (ab >= 128) {
                int lengthOfLength = ab - 128;
                headLength = 2 + lengthOfLength;
                byte[] lengthBytes = new byte[lengthOfLength];
                System.arraycopy(der, derStart + 2, lengthBytes, 0, lengthOfLength);
                length = DERUtil.generateInt(lengthBytes);
            } else {
                length = ab;
            }
            if (i != index - 1) {
                derStart = derStart + length + headLength;
            }
            ++i;
        }
        byte[] bs = new byte[length + headLength];
        System.arraycopy(der, derStart, bs, 0, length + headLength);
        return bs;
    }

    public static byte[] generateDERCode(int type, byte[] content) {
        int length = content.length;
        byte[] lengthBs = null;
        if (length >= 128) {
            byte[] intBs = DERUtil.int2Bytes(length);
            lengthBs = new byte[1 + intBs.length];
            lengthBs[0] = (byte)(128 + intBs.length);
            System.arraycopy(intBs, 0, lengthBs, 1, intBs.length);
        } else {
            lengthBs = new byte[]{(byte)length};
        }
        byte[] all = new byte[1 + lengthBs.length + content.length];
        all[0] = (byte)type;
        System.arraycopy(lengthBs, 0, all, 1, lengthBs.length);
        System.arraycopy(content, 0, all, 1 + lengthBs.length, content.length);
        return all;
    }

    public static byte[] int2Bytes(int i) {
        int l = 0;
        l = i <= 255 ? 1 : (i <= 65535 ? 2 : (i <= 0xFFFFFF ? 3 : 4));
        byte[] bs = new byte[l];
        int x = 0;
        while (x < l) {
            bs[x] = (byte)(i >> (l - 1 - x) * 8);
            ++x;
        }
        return bs;
    }

    public static int generateInt(byte[] bytes) {
        int tr = 0;
        int i = bytes.length - 1;
        while (i > -1) {
            int x = (bytes[bytes.length - 1 - i] & 0xFF) << i * 8;
            tr += x;
            --i;
        }
        return tr;
    }

    public static byte[] oid2ASN1(String oid) {
        String[] pieces = oid.split("\\.");
        byte[] oidbs = null;
        byte b = (byte)(Integer.parseInt(pieces[0]) * 40 + Integer.parseInt(pieces[1]));
        oidbs = new byte[]{b};
        int i = 2;
        while (i < pieces.length) {
            long num = Long.parseLong(pieces[i]);
            int pow = DERUtil.maxPow128(num);
            byte[] id = new byte[pow + 1];
            DERUtil.genid(pow, num, id);
            byte[] tmp = new byte[oidbs.length + id.length];
            System.arraycopy(oidbs, 0, tmp, 0, oidbs.length);
            System.arraycopy(id, 0, tmp, oidbs.length, id.length);
            oidbs = tmp;
            ++i;
        }
        return oidbs;
    }

    public static String ASN12OID(byte[] oid) {
        String oidStr = "";
        int asegment = 0;
        int index = 0;
        int i = oid.length - 1;
        while (i >= 0) {
            if (i == 0) break;
            int x = oid[i] & 0xFF;
            if (x < 128) {
                if (asegment != 0) {
                    oidStr = "." + asegment + oidStr;
                    asegment = 0;
                    index = 0;
                }
            } else {
                x -= 128;
            }
            asegment = index == 0 ? x : (int)((double)asegment + Math.pow(128.0, index) * (double)x);
            ++index;
            --i;
        }
        int s1 = (oid[0] & 0xFF) / 40;
        int s2 = (oid[0] & 0xFF) % 40;
        return String.valueOf(s1) + "." + s2 + "." + asegment + oidStr;
    }

    private static int maxPow128(long num) {
        int i = 0;
        while (num >= 1L << (i + 1) * 7) {
            ++i;
        }
        return i;
    }

    private static void genid(int pow, long num, byte[] id) {
        if (pow == 0) {
            id[id.length - 1] = (byte)num;
        } else {
            id[id.length - 1 - pow] = (byte)(128.0 + (double)num / Math.pow(128.0, pow));
        }
        if (pow - 1 >= 0) {
            DERUtil.genid(pow - 1, (int)((double)num % Math.pow(128.0, pow)), id);
        }
    }

    public static byte[] connect(byte[] a, byte[] b) {
        if (a == null) {
            a = new byte[]{};
        }
        byte[] tmp = new byte[a.length + b.length];
        System.arraycopy(a, 0, tmp, 0, a.length);
        System.arraycopy(b, 0, tmp, a.length, b.length);
        return tmp;
    }

    public static byte[] date2ASN1(Date date) {
        if (date.getTime() < 2524579200000L) {
            String time = String.valueOf(formatShort8.format(date)) + "Z";
            return DERUtil.generateDERCode(23, time.getBytes());
        }
        String time = String.valueOf(formatLong8.format(date)) + "Z";
        return DERUtil.generateDERCode(24, time.getBytes());
    }

    public static Date ASN12Date(byte[] date) throws ParseException {
        String dateStr = new String(date);
        if ((dateStr = dateStr.substring(0, dateStr.length() - 1)).length() == 12) {
            return formatShort8.parse(dateStr);
        }
        return formatLong8.parse(dateStr);
    }
}

