/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.crypt;

import com.icbc.api.crypt.AES;
import com.icbc.api.internal.util.codec.Base64;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;

public class RSA {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final int LINE_SIZE = 65;
    private static final String NEW_LINE_STR = System.getProperty("line.separator");
    private static final byte[] NEW_LINE_BYTES = NEW_LINE_STR.getBytes();
    private static final byte[] START_PUBLIC_KEY_BYTES = "##############start public key##############".getBytes();
    private static final byte[] END_PUBLIC_KEY_BYTES = "##############end public key##############".getBytes();
    private static final byte[] START_PRIVATE_KEY_BYTES = "##############start private key##############".getBytes();
    private static final byte[] END_PRIVATE_KEY_BYTES = "##############end private key##############".getBytes();
    private static final String GENERATR_ALG = "key generate algorithm: ";

    public static KeyPair generateKeyPair() throws Exception {
        return RSA.generateKeyPair(1024);
    }

    public static KeyPair generateKeyPair(int n2) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n2, new SecureRandom(UUID.randomUUID().toString().getBytes()));
        return keyPairGenerator.generateKeyPair();
    }

    public static String sign(byte[] byArray, byte[] byArray2, String string, String string2) throws Exception {
        return RSA.sign(byArray, AES.aesDecrypt(byArray2, string), string2);
    }

    public static String sign(byte[] byArray, byte[] byArray2, String string) throws Exception {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        Signature signature = Signature.getInstance(string);
        signature.initSign(privateKey);
        signature.update(byArray);
        return Base64.encodeBase64String(signature.sign());
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, String string, String string2) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Signature signature = Signature.getInstance(string2);
        signature.initVerify(publicKey);
        signature.update(byArray);
        return signature.verify(Base64.decodeBase64(string));
    }

    public static void generateRsa(OutputStream outputStream, OutputStream outputStream2) throws Exception {
        RSA.generateRsa(outputStream, outputStream2, null);
    }

    public static void generateRsa(OutputStream outputStream, OutputStream outputStream2, String string) throws Exception {
        RSA.saveKeys(outputStream, outputStream2, RSA.generateKeyPair(), string);
    }

    public static void genRsaWithoutNewline(int n2, OutputStream outputStream, OutputStream outputStream2) throws Exception {
        RSA.genRsaWithoutNewline(n2, outputStream, outputStream2, null);
    }

    public static void genRsaWithoutNewline(int n2, OutputStream outputStream, OutputStream outputStream2, String string) throws Exception {
        KeyPair keyPair = RSA.generateKeyPair(n2);
        RSA.savePrivateKeyWithoutNewline(outputStream, keyPair.getPrivate().getEncoded(), string);
        RSA.savePublicKeyWithoutNewline(outputStream2, keyPair.getPublic().getEncoded());
    }

    public static String loadPublicKeyFromStream(String string) throws Exception {
        return RSA.loadApiKeyFromStream(new FileInputStream(string), KeyType.PUBLIC_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String loadApiKeyFromStream(InputStream inputStream, KeyType keyType) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    if (string.startsWith(GENERATR_ALG)) {
                        bl2 = true;
                    }
                    bl = false;
                }
                if (bl2 && !bl3) {
                    if (keyType.equals((Object)KeyType.PRIVATE_KEY) && string.equals(new String(START_PRIVATE_KEY_BYTES))) {
                        bl3 = true;
                        continue;
                    }
                    if (!keyType.equals((Object)KeyType.PUBLIC_KEY) || !string.equals(new String(START_PUBLIC_KEY_BYTES))) continue;
                    bl3 = true;
                    continue;
                }
                if (bl3) {
                    if (keyType.equals((Object)KeyType.PRIVATE_KEY) && string.equals(new String(END_PRIVATE_KEY_BYTES))) {
                        break;
                    }
                    if (keyType.equals((Object)KeyType.PUBLIC_KEY) && string.equals(new String(END_PUBLIC_KEY_BYTES))) {
                        break;
                    }
                }
                stringBuffer.append(string);
            }
        }
        finally {
            inputStreamReader.close();
            bufferedReader.close();
        }
        return stringBuffer.toString().trim();
    }

    public static byte[] loadPublicKeyFromStream(InputStream inputStream) throws Exception {
        return RSA.loadKeyFromStream(inputStream, KeyType.PUBLIC_KEY);
    }

    public static byte[] loadPrivateKeyFromStream(InputStream inputStream, String string) throws Exception {
        return AES.aesDecrypt(RSA.loadKeyFromStream(inputStream, KeyType.PRIVATE_KEY), string);
    }

    public static byte[] loadPrivateKeyFromStream(InputStream inputStream) throws Exception {
        return RSA.loadKeyFromStream(inputStream, KeyType.PRIVATE_KEY);
    }

    protected static void saveKeys(OutputStream outputStream, OutputStream outputStream2, KeyPair keyPair) throws Exception {
        RSA.saveKeys(outputStream, outputStream2, keyPair, null);
    }

    protected static void saveKeys(OutputStream outputStream, OutputStream outputStream2, KeyPair keyPair, String string) throws Exception {
        RSA.savePrivateKey(outputStream, keyPair.getPrivate().getEncoded(), string);
        RSA.savePublicKey(outputStream2, keyPair.getPublic().getEncoded());
    }

    protected static void savePublicKey(OutputStream outputStream, byte[] byArray) throws Exception {
        try {
            outputStream.write(RSA.getTitle().getBytes(CHARSET_UTF8));
            outputStream.write(NEW_LINE_BYTES);
            outputStream.write(START_PUBLIC_KEY_BYTES);
            outputStream.write(NEW_LINE_BYTES);
            RSA.saveBase64KeyToStream(Base64.encodeBase64(byArray), outputStream);
            outputStream.write(END_PUBLIC_KEY_BYTES);
        }
        finally {
            outputStream.flush();
            outputStream.close();
        }
    }

    protected static void savePrivateKey(OutputStream outputStream, byte[] byArray, String string) throws Exception {
        try {
            if (string != null) {
                byArray = AES.aesEncrypt(byArray, string);
            }
            outputStream.write(RSA.getTitle().getBytes(CHARSET_UTF8));
            outputStream.write(NEW_LINE_BYTES);
            outputStream.write(START_PRIVATE_KEY_BYTES);
            outputStream.write(NEW_LINE_BYTES);
            RSA.saveBase64KeyToStream(Base64.encodeBase64(byArray), outputStream);
            outputStream.write(END_PRIVATE_KEY_BYTES);
        }
        finally {
            outputStream.flush();
            outputStream.close();
        }
    }

    protected static void savePublicKeyWithoutNewline(OutputStream outputStream, byte[] byArray) throws Exception {
        try {
            outputStream.write(Base64.encodeBase64(byArray));
        }
        finally {
            outputStream.flush();
            outputStream.close();
        }
    }

    protected static void savePrivateKeyWithoutNewline(OutputStream outputStream, byte[] byArray, String string) throws Exception {
        try {
            if (string != null) {
                byArray = AES.aesEncrypt(byArray, string);
            }
            outputStream.write(Base64.encodeBase64(byArray));
        }
        finally {
            outputStream.flush();
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadKeyFromStream(InputStream inputStream, KeyType keyType) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    if (string.startsWith(GENERATR_ALG)) {
                        bl2 = true;
                    }
                    bl = false;
                }
                if (bl2 && !bl3) {
                    if (keyType.equals((Object)KeyType.PRIVATE_KEY) && string.equals(new String(START_PRIVATE_KEY_BYTES))) {
                        bl3 = true;
                        continue;
                    }
                    if (!keyType.equals((Object)KeyType.PUBLIC_KEY) || !string.equals(new String(START_PUBLIC_KEY_BYTES))) continue;
                    bl3 = true;
                    continue;
                }
                if (bl3) {
                    if (keyType.equals((Object)KeyType.PRIVATE_KEY) && string.equals(new String(END_PRIVATE_KEY_BYTES))) {
                        break;
                    }
                    if (keyType.equals((Object)KeyType.PUBLIC_KEY) && string.equals(new String(END_PUBLIC_KEY_BYTES))) {
                        break;
                    }
                }
                stringBuffer.append(string);
            }
        }
        finally {
            inputStreamReader.close();
            bufferedReader.close();
        }
        return Base64.decodeBase64(stringBuffer.toString());
    }

    protected static void saveBase64KeyToStream(byte[] byArray, OutputStream outputStream) throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += n2) {
            n2 = Math.min(65, byArray.length - i2);
            outputStream.write(byArray, i2, n2);
            outputStream.write(NEW_LINE_BYTES);
        }
    }

    protected static String getTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GENERATR_ALG);
        stringBuilder.append("RSA");
        stringBuilder.append(NEW_LINE_STR);
        stringBuilder.append("key size: ");
        stringBuilder.append(1024);
        return stringBuilder.toString();
    }

    public static enum KeyType {
        PUBLIC_KEY("public key"),
        PRIVATE_KEY("private key");

        String type;

        private KeyType(String string2) {
            this.type = string2;
        }
    }
}

