/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.conn.routing;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.conn.routing.RouteInfo;
import com.icbc.api.internal.apache.http.s;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.LangUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Immutable
public final class b
implements RouteInfo,
Cloneable {
    private final s ei;
    private final InetAddress bb;
    private final List<s> ej;
    private final RouteInfo.TunnelType ek;
    private final RouteInfo.LayerType el;
    private final boolean em;

    private b(s s2, InetAddress inetAddress, List<s> list, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        Args.notNull(s2, "Target host");
        this.ei = b.h(s2);
        this.bb = inetAddress;
        this.ej = list != null && !list.isEmpty() ? new ArrayList<s>(list) : null;
        if (tunnelType == RouteInfo.TunnelType.TUNNELLED) {
            Args.check(this.ej != null, "Proxy required if tunnelled");
        }
        this.em = bl;
        this.ek = tunnelType != null ? tunnelType : RouteInfo.TunnelType.PLAIN;
        this.el = layerType != null ? layerType : RouteInfo.LayerType.PLAIN;
    }

    private static int Q(String string) {
        if ("http".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        return -1;
    }

    private static s h(s s2) {
        if (s2.getPort() >= 0) {
            return s2;
        }
        InetAddress inetAddress = s2.getAddress();
        String string = s2.getSchemeName();
        if (inetAddress != null) {
            return new s(inetAddress, b.Q(string), string);
        }
        String string2 = s2.getHostName();
        return new s(string2, b.Q(string), string);
    }

    public b(s s2, InetAddress inetAddress, s[] sArray, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this(s2, inetAddress, sArray != null ? Arrays.asList(sArray) : null, bl, tunnelType, layerType);
    }

    public b(s s2, InetAddress inetAddress, s s3, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this(s2, inetAddress, s3 != null ? Collections.singletonList(s3) : null, bl, tunnelType, layerType);
    }

    public b(s s2, InetAddress inetAddress, boolean bl) {
        this(s2, inetAddress, Collections.emptyList(), bl, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
    }

    public b(s s2) {
        this(s2, null, Collections.emptyList(), false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
    }

    public b(s s2, InetAddress inetAddress, s s3, boolean bl) {
        this(s2, inetAddress, Collections.singletonList(Args.notNull(s3, "Proxy host")), bl, bl ? RouteInfo.TunnelType.TUNNELLED : RouteInfo.TunnelType.PLAIN, bl ? RouteInfo.LayerType.LAYERED : RouteInfo.LayerType.PLAIN);
    }

    public b(s s2, s s3) {
        this(s2, null, s3, false);
    }

    @Override
    public final s bV() {
        return this.ei;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.bb;
    }

    public final InetSocketAddress bY() {
        return this.bb != null ? new InetSocketAddress(this.bb, 0) : null;
    }

    @Override
    public final int bZ() {
        return this.ej != null ? this.ej.size() + 1 : 1;
    }

    @Override
    public final s x(int n2) {
        Args.notNegative(n2, "Hop index");
        int n3 = this.bZ();
        Args.check(n2 < n3, "Hop index exceeds tracked route length");
        if (n2 < n3 - 1) {
            return this.ej.get(n2);
        }
        return this.ei;
    }

    @Override
    public final s ca() {
        return this.ej != null && !this.ej.isEmpty() ? this.ej.get(0) : null;
    }

    @Override
    public final RouteInfo.TunnelType cb() {
        return this.ek;
    }

    @Override
    public final boolean cc() {
        return this.ek == RouteInfo.TunnelType.TUNNELLED;
    }

    @Override
    public final RouteInfo.LayerType cd() {
        return this.el;
    }

    @Override
    public final boolean ce() {
        return this.el == RouteInfo.LayerType.LAYERED;
    }

    @Override
    public final boolean isSecure() {
        return this.em;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof b) {
            b b2 = (b)object;
            return this.em == b2.em && this.ek == b2.ek && this.el == b2.el && LangUtils.equals(this.ei, b2.ei) && LangUtils.equals(this.bb, b2.bb) && LangUtils.equals(this.ej, b2.ej);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = 17;
        n2 = LangUtils.hashCode(n2, this.ei);
        n2 = LangUtils.hashCode(n2, this.bb);
        if (this.ej != null) {
            for (s s2 : this.ej) {
                n2 = LangUtils.hashCode(n2, s2);
            }
        }
        n2 = LangUtils.hashCode(n2, this.em);
        n2 = LangUtils.hashCode(n2, (Object)this.ek);
        n2 = LangUtils.hashCode(n2, (Object)this.el);
        return n2;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(50 + this.bZ() * 30);
        if (this.bb != null) {
            stringBuilder.append(this.bb);
            stringBuilder.append("->");
        }
        stringBuilder.append('{');
        if (this.ek == RouteInfo.TunnelType.TUNNELLED) {
            stringBuilder.append('t');
        }
        if (this.el == RouteInfo.LayerType.LAYERED) {
            stringBuilder.append('l');
        }
        if (this.em) {
            stringBuilder.append('s');
        }
        stringBuilder.append("}->");
        if (this.ej != null) {
            for (s s2 : this.ej) {
                stringBuilder.append(s2);
                stringBuilder.append("->");
            }
        }
        stringBuilder.append(this.ei);
        return stringBuilder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

