/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.conn.routing;

import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.conn.routing.RouteInfo;
import com.icbc.api.internal.apache.http.conn.routing.b;
import com.icbc.api.internal.apache.http.s;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import com.icbc.api.internal.apache.http.util.LangUtils;
import java.net.InetAddress;

@NotThreadSafe
public final class e
implements RouteInfo,
Cloneable {
    private final s ei;
    private final InetAddress bb;
    private boolean connected;
    private s[] eu;
    private RouteInfo.TunnelType ek;
    private RouteInfo.LayerType el;
    private boolean em;

    public e(s s2, InetAddress inetAddress) {
        Args.notNull(s2, "Target host");
        this.ei = s2;
        this.bb = inetAddress;
        this.ek = RouteInfo.TunnelType.PLAIN;
        this.el = RouteInfo.LayerType.PLAIN;
    }

    public void reset() {
        this.connected = false;
        this.eu = null;
        this.ek = RouteInfo.TunnelType.PLAIN;
        this.el = RouteInfo.LayerType.PLAIN;
        this.em = false;
    }

    public e(b b2) {
        this(b2.bV(), b2.getLocalAddress());
    }

    public final void p(boolean bl) {
        Asserts.check(!this.connected, "Already connected");
        this.connected = true;
        this.em = bl;
    }

    public final void a(s s2, boolean bl) {
        Args.notNull(s2, "Proxy host");
        Asserts.check(!this.connected, "Already connected");
        this.connected = true;
        this.eu = new s[]{s2};
        this.em = bl;
    }

    public final void q(boolean bl) {
        Asserts.check(this.connected, "No tunnel unless connected");
        Asserts.notNull(this.eu, "No tunnel without proxy");
        this.ek = RouteInfo.TunnelType.TUNNELLED;
        this.em = bl;
    }

    public final void b(s s2, boolean bl) {
        Args.notNull(s2, "Proxy host");
        Asserts.check(this.connected, "No tunnel unless connected");
        Asserts.notNull(this.eu, "No tunnel without proxy");
        s[] sArray = new s[this.eu.length + 1];
        System.arraycopy(this.eu, 0, sArray, 0, this.eu.length);
        sArray[sArray.length - 1] = s2;
        this.eu = sArray;
        this.em = bl;
    }

    public final void r(boolean bl) {
        Asserts.check(this.connected, "No layered protocol unless connected");
        this.el = RouteInfo.LayerType.LAYERED;
        this.em = bl;
    }

    @Override
    public final s bV() {
        return this.ei;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.bb;
    }

    @Override
    public final int bZ() {
        int n2 = 0;
        if (this.connected) {
            n2 = this.eu == null ? 1 : this.eu.length + 1;
        }
        return n2;
    }

    @Override
    public final s x(int n2) {
        Args.notNegative(n2, "Hop index");
        int n3 = this.bZ();
        Args.check(n2 < n3, "Hop index exceeds tracked route length");
        s s2 = null;
        s2 = n2 < n3 - 1 ? this.eu[n2] : this.ei;
        return s2;
    }

    @Override
    public final s ca() {
        return this.eu == null ? null : this.eu[0];
    }

    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    public final RouteInfo.TunnelType cb() {
        return this.ek;
    }

    @Override
    public final boolean cc() {
        return this.ek == RouteInfo.TunnelType.TUNNELLED;
    }

    @Override
    public final RouteInfo.LayerType cd() {
        return this.el;
    }

    @Override
    public final boolean ce() {
        return this.el == RouteInfo.LayerType.LAYERED;
    }

    @Override
    public final boolean isSecure() {
        return this.em;
    }

    public final b cf() {
        return !this.connected ? null : new b(this.ei, this.bb, this.eu, this.em, this.ek, this.el);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof e)) {
            return false;
        }
        e e2 = (e)object;
        return this.connected == e2.connected && this.em == e2.em && this.ek == e2.ek && this.el == e2.el && LangUtils.equals(this.ei, e2.ei) && LangUtils.equals(this.bb, e2.bb) && LangUtils.equals(this.eu, e2.eu);
    }

    public final int hashCode() {
        int n2 = 17;
        n2 = LangUtils.hashCode(n2, this.ei);
        n2 = LangUtils.hashCode(n2, this.bb);
        if (this.eu != null) {
            for (s s2 : this.eu) {
                n2 = LangUtils.hashCode(n2, s2);
            }
        }
        n2 = LangUtils.hashCode(n2, this.connected);
        n2 = LangUtils.hashCode(n2, this.em);
        n2 = LangUtils.hashCode(n2, (Object)this.ek);
        n2 = LangUtils.hashCode(n2, (Object)this.el);
        return n2;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(50 + this.bZ() * 30);
        stringBuilder.append("RouteTracker[");
        if (this.bb != null) {
            stringBuilder.append(this.bb);
            stringBuilder.append("->");
        }
        stringBuilder.append('{');
        if (this.connected) {
            stringBuilder.append('c');
        }
        if (this.ek == RouteInfo.TunnelType.TUNNELLED) {
            stringBuilder.append('t');
        }
        if (this.el == RouteInfo.LayerType.LAYERED) {
            stringBuilder.append('l');
        }
        if (this.em) {
            stringBuilder.append('s');
        }
        stringBuilder.append("}->");
        if (this.eu != null) {
            for (s s2 : this.eu) {
                stringBuilder.append(s2);
                stringBuilder.append("->");
            }
        }
        stringBuilder.append(this.ei);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

