/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.reactor.ssl;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.reactor.g;
import com.icbc.api.internal.apache.http.nio.reactor.j;
import com.icbc.api.internal.apache.http.nio.reactor.o;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLMode;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.c;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.d;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.f;
import com.icbc.api.internal.apache.http.s;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class e
implements g,
j,
o {
    public static final String xE = "http.session.ssl";
    private static final ByteBuffer xF = ByteBuffer.allocate(0);
    private final g qw;
    private final SSLEngine xG;
    private final c xH;
    private final c xI;
    private final c xJ;
    private final c xK;
    private final a xL;
    private final f xM;
    private int xN;
    private j xO;
    private boolean endOfStream;
    private volatile SSLMode xP;
    private volatile int status;
    private volatile boolean initialized;

    public e(g g2, SSLMode sSLMode, s s2, SSLContext sSLContext, f f2) {
        this(g2, sSLMode, s2, sSLContext, f2, new com.icbc.api.internal.apache.http.nio.reactor.ssl.a());
    }

    public e(g g2, SSLMode sSLMode, s s2, SSLContext sSLContext, f f2, d d2) {
        Args.notNull(g2, "IO session");
        Args.notNull(sSLContext, "SSL context");
        Args.notNull(d2, "Buffer management strategy");
        this.qw = g2;
        this.xP = sSLMode;
        this.xN = g2.iV();
        this.xL = new a();
        this.xM = f2;
        this.qw.a(this);
        this.xG = this.xP == SSLMode.CLIENT && s2 != null ? sSLContext.createSSLEngine(s2.getHostName(), s2.getPort()) : sSLContext.createSSLEngine();
        int n2 = this.xG.getSession().getPacketBufferSize();
        this.xH = d2.ay(n2);
        this.xI = d2.ay(n2);
        int n3 = this.xG.getSession().getApplicationBufferSize();
        this.xJ = d2.ay(n3);
        this.xK = d2.ay(n3);
    }

    public e(g g2, SSLMode sSLMode, SSLContext sSLContext, f f2) {
        this(g2, sSLMode, null, sSLContext, f2);
    }

    protected f kZ() {
        return this.xM;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Deprecated
    public synchronized void a(SSLMode sSLMode) throws SSLException {
        this.xP = sSLMode;
        this.initialize();
    }

    public synchronized void initialize() throws SSLException {
        Asserts.check(!this.initialized, "SSL I/O session already initialized");
        if (this.status >= 1) {
            return;
        }
        switch (this.xP) {
            case CLIENT: {
                this.xG.setUseClientMode(true);
                break;
            }
            case SERVER: {
                this.xG.setUseClientMode(false);
            }
        }
        if (this.xM != null) {
            this.xM.a(this.xG);
        }
        this.initialized = true;
        this.xG.beginHandshake();
        this.xH.release();
        this.xI.release();
        this.xJ.release();
        this.xK.release();
        this.lb();
    }

    public synchronized SSLSession getSSLSession() {
        return this.xG.getSession();
    }

    private SSLException c(RuntimeException runtimeException) {
        Throwable throwable = runtimeException.getCause();
        if (throwable == null) {
            throwable = runtimeException;
        }
        return new SSLException(throwable);
    }

    private SSLEngineResult a(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            return this.xG.wrap(byteBuffer, byteBuffer2);
        }
        catch (RuntimeException runtimeException) {
            throw this.c(runtimeException);
        }
    }

    private SSLEngineResult b(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            return this.xG.unwrap(byteBuffer, byteBuffer2);
        }
        catch (RuntimeException runtimeException) {
            throw this.c(runtimeException);
        }
    }

    private void la() throws SSLException {
        try {
            Runnable runnable = this.xG.getDelegatedTask();
            if (runnable != null) {
                runnable.run();
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.c(runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lb() throws SSLException {
        boolean bl = true;
        SSLEngineResult sSLEngineResult = null;
        while (bl) {
            switch (this.xG.getHandshakeStatus()) {
                case NEED_WRAP: {
                    ByteBuffer byteBuffer = this.xK.kX();
                    ByteBuffer byteBuffer2 = this.xI.kX();
                    byteBuffer.flip();
                    sSLEngineResult = this.a(byteBuffer, byteBuffer2);
                    byteBuffer.compact();
                    if (byteBuffer.position() == 0) {
                        this.xK.release();
                        byteBuffer = null;
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) break;
                    bl = false;
                    break;
                }
                case NEED_UNWRAP: {
                    ByteBuffer byteBuffer = this.xH.kX();
                    ByteBuffer byteBuffer3 = this.xJ.kX();
                    byteBuffer.flip();
                    sSLEngineResult = this.b(byteBuffer, byteBuffer3);
                    byteBuffer.compact();
                    try {
                        if (!byteBuffer.hasRemaining() && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            throw new SSLException("Input buffer is full");
                        }
                    }
                    finally {
                        if (byteBuffer.position() == 0) {
                            this.xH.release();
                            byteBuffer = null;
                        }
                    }
                    if (this.status >= 1) {
                        this.xJ.release();
                        byteBuffer3 = null;
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) break;
                    bl = false;
                    break;
                }
                case NEED_TASK: {
                    this.la();
                    break;
                }
                case NOT_HANDSHAKING: {
                    bl = false;
                    break;
                }
            }
        }
        if (sSLEngineResult != null && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.xM != null) {
            this.xM.a(this.qw, this.xG.getSession());
        }
    }

    private void lc() {
        int n2;
        if (this.status == 1 && this.xG.isOutboundDone() && (this.endOfStream || this.xG.isInboundDone())) {
            this.status = Integer.MAX_VALUE;
        }
        if (this.status == 0 && this.endOfStream && this.xG.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.status = Integer.MAX_VALUE;
        }
        if (this.status == Integer.MAX_VALUE) {
            this.qw.close();
            return;
        }
        int n3 = n2 = this.qw.iV();
        switch (this.xG.getHandshakeStatus()) {
            case NEED_WRAP: {
                n3 = 5;
                break;
            }
            case NEED_UNWRAP: {
                n3 = 1;
                break;
            }
            case NOT_HANDSHAKING: {
                n3 = this.xN;
                break;
            }
            case NEED_TASK: {
                break;
            }
        }
        if (this.xI.hasData()) {
            n3 |= 4;
        }
        if (n2 != n3) {
            this.qw.Z(n3);
        }
    }

    private int ld() throws IOException {
        if (!this.xI.hasData()) {
            return this.qw.iU().write(xF);
        }
        ByteBuffer byteBuffer = this.xI.kX();
        byteBuffer.flip();
        int n2 = this.qw.iU().write(byteBuffer);
        byteBuffer.compact();
        if (byteBuffer.position() == 0) {
            this.xI.release();
        }
        return n2;
    }

    private int le() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        ByteBuffer byteBuffer = this.xH.kX();
        int n2 = this.qw.iU().read(byteBuffer);
        if (byteBuffer.position() == 0) {
            this.xH.release();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lf() throws SSLException {
        boolean bl = false;
        while (this.xH.hasData()) {
            ByteBuffer byteBuffer = this.xH.kX();
            ByteBuffer byteBuffer2 = this.xJ.kX();
            byteBuffer.flip();
            SSLEngineResult sSLEngineResult = this.b(byteBuffer, byteBuffer2);
            byteBuffer.compact();
            try {
                if (!byteBuffer.hasRemaining() && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException("Input buffer is full");
                }
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) break;
                bl = true;
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && !this.endOfStream) continue;
                break;
            }
            finally {
                if (this.xH.kX().position() != 0) continue;
                this.xH.release();
            }
        }
        return bl;
    }

    public synchronized boolean lg() throws IOException {
        do {
            int n2;
            if ((n2 = this.le()) == -1) {
                this.endOfStream = true;
            }
            this.lb();
            SSLEngineResult.HandshakeStatus handshakeStatus = this.xG.getHandshakeStatus();
            if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) continue;
            this.lf();
        } while (this.xG.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK);
        return (this.xN & 1) > 0 && (this.xJ.hasData() || this.xO != null && this.xO.hu() || this.endOfStream && this.status == 0);
    }

    public synchronized boolean lh() throws IOException {
        return (this.xN & 4) > 0 && this.status == 0 && this.xG.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public synchronized void li() throws IOException {
        this.lc();
    }

    public synchronized void lj() throws IOException {
        this.ld();
        this.lb();
        this.lc();
    }

    public synchronized boolean isInboundDone() {
        return this.xG.isInboundDone();
    }

    public synchronized boolean isOutboundDone() {
        return this.xG.isOutboundDone();
    }

    private synchronized int f(ByteBuffer byteBuffer) throws IOException {
        Object object;
        ByteBuffer byteBuffer2;
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.status != 0) {
            throw new ClosedChannelException();
        }
        if (this.xK.hasData()) {
            byteBuffer2 = this.xK.kX();
            object = this.xI.kX();
            byteBuffer2.flip();
            this.a(byteBuffer2, (ByteBuffer)object);
            byteBuffer2.compact();
            if (byteBuffer2.position() == 0) {
                this.xK.release();
                byteBuffer2 = null;
            }
        }
        if (!this.xK.hasData()) {
            byteBuffer2 = this.xI.kX();
            object = this.a(byteBuffer, byteBuffer2);
            if (((SSLEngineResult)object).getStatus() == SSLEngineResult.Status.CLOSED) {
                this.status = Integer.MAX_VALUE;
            }
            return ((SSLEngineResult)object).bytesConsumed();
        }
        return 0;
    }

    private synchronized int g(ByteBuffer byteBuffer) {
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.xJ.hasData()) {
            ByteBuffer byteBuffer2 = this.xJ.kX();
            byteBuffer2.flip();
            int n2 = Math.min(byteBuffer2.remaining(), byteBuffer.remaining());
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.put(byteBuffer2.get());
            }
            byteBuffer2.compact();
            if (byteBuffer2.position() == 0) {
                this.xJ.release();
                byteBuffer2 = null;
            }
            return n2;
        }
        if (this.endOfStream) {
            return -1;
        }
        return 0;
    }

    @Override
    public synchronized void close() {
        if (this.status >= 1) {
            return;
        }
        this.status = 1;
        this.xG.closeOutbound();
        this.lc();
    }

    @Override
    public synchronized void shutdown() {
        if (this.status == Integer.MAX_VALUE) {
            return;
        }
        this.xH.release();
        this.xI.release();
        this.xJ.release();
        this.xK.release();
        this.status = Integer.MAX_VALUE;
        this.qw.shutdown();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isClosed() {
        return this.status >= 1 || this.qw.isClosed();
    }

    @Override
    public ByteChannel iU() {
        return this.xL;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.qw.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.qw.getRemoteAddress();
    }

    @Override
    public synchronized int iV() {
        return this.xN;
    }

    @Override
    public synchronized void Z(int n2) {
        this.xN = n2;
        this.lc();
    }

    @Override
    public synchronized void aa(int n2) {
        this.xN |= n2;
        this.lc();
    }

    @Override
    public synchronized void ab(int n2) {
        this.xN &= ~n2;
        this.lc();
    }

    @Override
    public int h() {
        return this.qw.h();
    }

    @Override
    public void c(int n2) {
        this.qw.c(n2);
    }

    @Override
    public synchronized boolean hu() {
        return this.xO != null && this.xO.hu() || this.xH.hasData() || this.xJ.hasData();
    }

    @Override
    public synchronized boolean hv() {
        return this.xO != null && this.xO.hv() || this.xI.hasData() || this.xK.hasData();
    }

    @Override
    public synchronized void a(j j2) {
        this.xO = j2;
    }

    @Override
    public Object getAttribute(String string) {
        return this.qw.getAttribute(string);
    }

    @Override
    public Object az(String string) {
        return this.qw.az(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.qw.setAttribute(string, object);
    }

    private static void a(StringBuilder stringBuilder, int n2) {
        if ((n2 & 1) > 0) {
            stringBuilder.append('r');
        }
        if ((n2 & 4) > 0) {
            stringBuilder.append('w');
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.qw);
        stringBuilder.append("[");
        switch (this.status) {
            case 0: {
                stringBuilder.append("ACTIVE");
                break;
            }
            case 1: {
                stringBuilder.append("CLOSING");
                break;
            }
            case 0x7FFFFFFF: {
                stringBuilder.append("CLOSED");
            }
        }
        stringBuilder.append("][");
        e.a(stringBuilder, this.xN);
        stringBuilder.append("][");
        stringBuilder.append((Object)this.xG.getHandshakeStatus());
        if (this.xG.isInboundDone()) {
            stringBuilder.append("][inbound done][");
        }
        if (this.xG.isOutboundDone()) {
            stringBuilder.append("][outbound done][");
        }
        if (this.endOfStream) {
            stringBuilder.append("][EOF][");
        }
        stringBuilder.append("][");
        stringBuilder.append(!this.xH.hasData() ? 0 : this.xH.kX().position());
        stringBuilder.append("][");
        stringBuilder.append(!this.xJ.hasData() ? 0 : this.xJ.kX().position());
        stringBuilder.append("][");
        stringBuilder.append(!this.xI.hasData() ? 0 : this.xI.kX().position());
        stringBuilder.append("][");
        stringBuilder.append(!this.xK.hasData() ? 0 : this.xK.kX().position());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public Socket getSocket() {
        if (this.qw instanceof o) {
            return ((o)((Object)this.qw)).getSocket();
        }
        return null;
    }

    private class a
    implements ByteChannel {
        private a() {
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            return e.this.f(byteBuffer);
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            return e.this.g(byteBuffer);
        }

        @Override
        public void close() throws IOException {
            e.this.close();
        }

        @Override
        public boolean isOpen() {
            return !e.this.isClosed();
        }
    }
}

