/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.a;
import com.icbc.api.internal.apache.http.nio.g;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SharedInputBuffer
extends ExpandableBuffer
implements ContentInputBuffer {
    private final ReentrantLock lock;
    private final Condition condition;
    private volatile g ioctrl;
    private volatile boolean shutdown = false;
    private volatile boolean endOfStream = false;

    @Deprecated
    public SharedInputBuffer(int n2, g g2, ByteBufferAllocator byteBufferAllocator) {
        super(n2, byteBufferAllocator);
        this.ioctrl = g2;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedInputBuffer(int n2, ByteBufferAllocator byteBufferAllocator) {
        super(n2, byteBufferAllocator);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedInputBuffer(int n2) {
        this(n2, HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public void reset() {
        if (this.shutdown) {
            return;
        }
        this.lock.lock();
        try {
            this.clear();
            this.endOfStream = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Deprecated
    public int consumeContent(a a2) throws IOException {
        return this.consumeContent(a2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consumeContent(a a2, g g2) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            int n2;
            if (g2 != null) {
                this.ioctrl = g2;
            }
            this.setInputMode();
            int n3 = 0;
            while ((n2 = a2.read(this.buffer)) > 0) {
                n3 += n2;
            }
            if (n2 == -1 || a2.isCompleted()) {
                this.endOfStream = true;
            }
            if (!this.buffer.hasRemaining() && this.ioctrl != null) {
                this.ioctrl.hs();
            }
            this.condition.signalAll();
            if (n3 > 0) {
                int n4 = n3;
                return n4;
            }
            if (this.endOfStream) {
                int n5 = -1;
                return n5;
            }
            int n6 = 0;
            return n6;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl = super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            int n2 = super.available();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        this.lock.lock();
        try {
            int n2 = super.capacity();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n2 = super.length();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void waitForData() throws IOException {
        this.lock.lock();
        try {
            try {
                while (!super.hasData() && !this.endOfStream) {
                    if (this.shutdown) {
                        throw new InterruptedIOException("Input operation aborted");
                    }
                    if (this.ioctrl != null) {
                        this.ioctrl.hq();
                    }
                    this.condition.await();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted while waiting for more data");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        if (this.shutdown) {
            return;
        }
        this.endOfStream = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    protected boolean isEndOfStream() {
        return this.shutdown || !this.hasData() && this.endOfStream;
    }

    @Override
    public int read() throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                int n2 = -1;
                return n2;
            }
            int n3 = this.buffer.get() & 0xFF;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (byArray == null) {
            return 0;
        }
        this.lock.lock();
        try {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                int n4 = -1;
                return n4;
            }
            this.setOutputMode();
            int n5 = n3;
            if (n5 > this.buffer.remaining()) {
                n5 = this.buffer.remaining();
            }
            this.buffer.get(byArray, n2, n5);
            int n6 = n5;
            return n6;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int read(byte[] byArray) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }
}

