/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.nio.a;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import java.io.IOException;

public class SimpleInputBuffer
extends ExpandableBuffer
implements ContentInputBuffer {
    private boolean endOfStream = false;

    public SimpleInputBuffer(int n2, ByteBufferAllocator byteBufferAllocator) {
        super(n2, byteBufferAllocator);
    }

    public SimpleInputBuffer(int n2) {
        this(n2, HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public void reset() {
        this.endOfStream = false;
        super.clear();
    }

    @Override
    public int consumeContent(a a2) throws IOException {
        int n2;
        this.setInputMode();
        int n3 = 0;
        while ((n2 = a2.read(this.buffer)) != -1) {
            if (n2 == 0) {
                if (this.buffer.hasRemaining()) break;
                this.expand();
                continue;
            }
            n3 += n2;
        }
        if (n2 == -1 || a2.isCompleted()) {
            this.endOfStream = true;
        }
        return n3;
    }

    public boolean isEndOfStream() {
        return !this.hasData() && this.endOfStream;
    }

    @Override
    public int read() throws IOException {
        if (this.isEndOfStream()) {
            return -1;
        }
        this.setOutputMode();
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.isEndOfStream()) {
            return -1;
        }
        if (byArray == null) {
            return 0;
        }
        this.setOutputMode();
        int n4 = n3;
        if (n4 > this.buffer.remaining()) {
            n4 = this.buffer.remaining();
        }
        this.buffer.get(byArray, n2, n4);
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.isEndOfStream()) {
            return -1;
        }
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    public void shutdown() {
        this.endOfStream = true;
    }
}

