/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.LangUtils;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class s
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7529410654042457626L;
    public static final String ad = "http";
    protected final String hostname;
    protected final String ae;
    protected final int port;
    protected final String af;
    protected final InetAddress address;

    public s(String string, int n2, String string2) {
        this.hostname = Args.containsNoBlanks(string, "Host name");
        this.ae = string.toLowerCase(Locale.ROOT);
        this.af = string2 != null ? string2.toLowerCase(Locale.ROOT) : ad;
        this.port = n2;
        this.address = null;
    }

    public s(String string, int n2) {
        this(string, n2, null);
    }

    public static s d(String string) {
        Args.containsNoBlanks(string, "HTTP Host");
        String string2 = string;
        String string3 = null;
        int n2 = string2.indexOf("://");
        if (n2 > 0) {
            string3 = string2.substring(0, n2);
            string2 = string2.substring(n2 + 3);
        }
        int n3 = -1;
        int n4 = string2.lastIndexOf(":");
        if (n4 > 0) {
            try {
                n3 = Integer.parseInt(string2.substring(n4 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid HTTP host: " + string2);
            }
            string2 = string2.substring(0, n4);
        }
        return new s(string2, n3, string3);
    }

    public s(String string) {
        this(string, -1, null);
    }

    public s(InetAddress inetAddress, int n2, String string) {
        this(Args.notNull(inetAddress, "Inet address"), inetAddress.getHostName(), n2, string);
    }

    public s(InetAddress inetAddress, String string, int n2, String string2) {
        this.address = Args.notNull(inetAddress, "Inet address");
        this.hostname = Args.notNull(string, "Hostname");
        this.ae = this.hostname.toLowerCase(Locale.ROOT);
        this.af = string2 != null ? string2.toLowerCase(Locale.ROOT) : ad;
        this.port = n2;
    }

    public s(InetAddress inetAddress, int n2) {
        this(inetAddress, n2, null);
    }

    public s(InetAddress inetAddress) {
        this(inetAddress, -1, null);
    }

    public s(s s2) {
        Args.notNull(s2, "HTTP host");
        this.hostname = s2.hostname;
        this.ae = s2.ae;
        this.af = s2.af;
        this.port = s2.port;
        this.address = s2.address;
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getSchemeName() {
        return this.af;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String v() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.af);
        stringBuilder.append("://");
        stringBuilder.append(this.hostname);
        if (this.port != -1) {
            stringBuilder.append(':');
            stringBuilder.append(Integer.toString(this.port));
        }
        return stringBuilder.toString();
    }

    public String w() {
        if (this.port != -1) {
            StringBuilder stringBuilder = new StringBuilder(this.hostname.length() + 6);
            stringBuilder.append(this.hostname);
            stringBuilder.append(":");
            stringBuilder.append(Integer.toString(this.port));
            return stringBuilder.toString();
        }
        return this.hostname;
    }

    public String toString() {
        return this.v();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof s) {
            s s2 = (s)object;
            return this.ae.equals(s2.ae) && this.port == s2.port && this.af.equals(s2.af) && (this.address == null ? s2.address == null : this.address.equals(s2.address));
        }
        return false;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = LangUtils.hashCode(n2, this.ae);
        n2 = LangUtils.hashCode(n2, this.port);
        n2 = LangUtils.hashCode(n2, this.af);
        if (this.address != null) {
            n2 = LangUtils.hashCode(n2, this.address);
        }
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

