/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.util;

import com.icbc.api.internal.apache.http.G;
import com.icbc.api.internal.apache.http.I;
import com.icbc.api.internal.apache.http.e.g;
import com.icbc.api.internal.apache.http.h;
import com.icbc.api.internal.apache.http.j.f;
import com.icbc.api.internal.apache.http.o;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.ByteArrayBuffer;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import com.icbc.api.internal.apache.http.y;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consumeQuietly(o o2) {
        try {
            EntityUtils.consume(o2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(o o2) throws IOException {
        InputStream inputStream;
        if (o2 == null) {
            return;
        }
        if (o2.r() && (inputStream = o2.getContent()) != null) {
            inputStream.close();
        }
    }

    public static void updateEntity(y y2, o o2) throws IOException {
        Args.notNull(y2, "Response");
        EntityUtils.consume(y2.u());
        y2.a(o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(o o2) throws IOException {
        Args.notNull(o2, "Entity");
        InputStream inputStream = o2.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n2;
            Args.check(o2.getContentLength() <= Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory");
            int n3 = (int)o2.getContentLength();
            if (n3 < 0) {
                n3 = 4096;
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n3);
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayBuffer.append(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayBuffer.toByteArray();
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    @Deprecated
    public static String getContentCharSet(o o2) throws I {
        G g2;
        h[] hArray;
        Args.notNull(o2, "Entity");
        String string = null;
        if (o2.p() != null && (hArray = o2.p().c()).length > 0 && (g2 = hArray[0].b("charset")) != null) {
            string = g2.getValue();
        }
        return string;
    }

    @Deprecated
    public static String getContentMimeType(o o2) throws I {
        h[] hArray;
        Args.notNull(o2, "Entity");
        String string = null;
        if (o2.p() != null && (hArray = o2.p().c()).length > 0) {
            string = hArray[0].getName();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(o o2, Charset charset) throws IOException, I {
        Args.notNull(o2, "Entity");
        InputStream inputStream = o2.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n2;
            Object object;
            Charset charset2;
            int n3;
            block11: {
                Args.check(o2.getContentLength() <= Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory");
                n3 = (int)o2.getContentLength();
                if (n3 < 0) {
                    n3 = 4096;
                }
                charset2 = null;
                try {
                    object = g.e(o2);
                    if (object != null) {
                        charset2 = ((g)object).getCharset();
                    }
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    if (charset != null) break block11;
                    throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
                }
            }
            if (charset2 == null) {
                charset2 = charset;
            }
            if (charset2 == null) {
                charset2 = f.yY;
            }
            object = new InputStreamReader(inputStream, charset2);
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer(n3);
            char[] cArray = new char[1024];
            while ((n2 = ((Reader)object).read(cArray)) != -1) {
                charArrayBuffer.append(cArray, 0, n2);
            }
            String string = charArrayBuffer.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static String toString(o o2, String string) throws IOException, I {
        return EntityUtils.toString(o2, string != null ? Charset.forName(string) : null);
    }

    public static String toString(o o2) throws IOException, I {
        return EntityUtils.toString(o2, (Charset)null);
    }
}

