/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.asm;

import com.icbc.api.internal.util.fastjson.asm.ByteVector;
import com.icbc.api.internal.util.fastjson.asm.FieldWriter;
import com.icbc.api.internal.util.fastjson.asm.Item;
import com.icbc.api.internal.util.fastjson.asm.MethodWriter;
import com.icbc.api.internal.util.fastjson.asm.Type;

public class ClassWriter {
    int version;
    int index = 1;
    final ByteVector pool = new ByteVector();
    Item[] items = new Item[256];
    int threshold = (int)(0.75 * (double)this.items.length);
    final Item key = new Item();
    final Item key2 = new Item();
    final Item key3 = new Item();
    Item[] typeTable;
    private int access;
    private int name;
    String thisName;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    FieldWriter firstField;
    FieldWriter lastField;
    MethodWriter firstMethod;
    MethodWriter lastMethod;

    public ClassWriter() {
        this(0);
    }

    private ClassWriter(int n2) {
    }

    public void visit(int n2, int n3, String string, String string2, String[] stringArray) {
        this.version = n2;
        this.access = n3;
        this.name = this.newClassItem((String)string).index;
        this.thisName = string;
        int n4 = this.superName = string2 == null ? 0 : this.newClassItem((String)string2).index;
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i2 = 0; i2 < this.interfaceCount; ++i2) {
                this.interfaces[i2] = this.newClassItem((String)stringArray[i2]).index;
            }
        }
    }

    public byte[] toByteArray() {
        int n2 = 24 + 2 * this.interfaceCount;
        int n3 = 0;
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            ++n3;
            n2 += fieldWriter.getSize();
            fieldWriter = fieldWriter.next;
        }
        int n4 = 0;
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            ++n4;
            n2 += methodWriter.getSize();
            methodWriter = methodWriter.next;
        }
        int n5 = 0;
        ByteVector byteVector = new ByteVector(n2 += this.pool.length);
        byteVector.putInt(-889275714).putInt(this.version);
        byteVector.putShort(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        int n6 = 393216;
        byteVector.putShort(this.access & ~n6).putShort(this.name).putShort(this.superName);
        byteVector.putShort(this.interfaceCount);
        for (int i2 = 0; i2 < this.interfaceCount; ++i2) {
            byteVector.putShort(this.interfaces[i2]);
        }
        byteVector.putShort(n3);
        fieldWriter = this.firstField;
        while (fieldWriter != null) {
            fieldWriter.put(byteVector);
            fieldWriter = fieldWriter.next;
        }
        byteVector.putShort(n4);
        methodWriter = this.firstMethod;
        while (methodWriter != null) {
            methodWriter.put(byteVector);
            methodWriter = methodWriter.next;
        }
        byteVector.putShort(n5);
        return byteVector.data;
    }

    Item newConstItem(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            this.key.set(n2);
            Item item = this.get(this.key);
            if (item == null) {
                this.pool.putByte(3).putInt(n2);
                item = new Item(this.index++, this.key);
                this.put(item);
            }
            return item;
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.newClassItem(type.sort == 10 ? type.getInternalName() : type.getDescriptor());
        }
        throw new IllegalArgumentException("value " + object);
    }

    public int newUTF8(String string) {
        this.key.set(1, string, null, null);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(1).putUTF8(string);
            item = new Item(this.index++, this.key);
            this.put(item);
        }
        return item.index;
    }

    public Item newClassItem(String string) {
        this.key2.set(7, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(7, this.newUTF8(string));
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item;
    }

    Item newFieldItem(String string, String string2, String string3) {
        this.key3.set(9, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            int n2 = this.newClassItem((String)string).index;
            int n3 = this.newNameTypeItem((String)string2, (String)string3).index;
            this.pool.put12(9, n2).putShort(n3);
            item = new Item(this.index++, this.key3);
            this.put(item);
        }
        return item;
    }

    Item newMethodItem(String string, String string2, String string3, boolean bl) {
        int n2 = bl ? 11 : 10;
        this.key3.set(n2, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            int n3 = this.newClassItem((String)string).index;
            int n4 = this.newNameTypeItem((String)string2, (String)string3).index;
            this.pool.put12(n2, n3).putShort(n4);
            item = new Item(this.index++, this.key3);
            this.put(item);
        }
        return item;
    }

    private Item newString(String string) {
        this.key2.set(8, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(8, this.newUTF8(string));
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item;
    }

    public Item newNameTypeItem(String string, String string2) {
        this.key2.set(12, string, string2, null);
        Item item = this.get(this.key2);
        if (item == null) {
            int n2 = this.newUTF8(string);
            int n3 = this.newUTF8(string2);
            this.pool.put12(12, n2).putShort(n3);
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item;
    }

    private Item get(Item item) {
        Item item2 = this.items[item.hashCode % this.items.length];
        while (!(item2 == null || item2.type == item.type && item.isEqualTo(item2))) {
            item2 = item2.next;
        }
        return item2;
    }

    private void put(Item item) {
        int n2;
        if (this.index > this.threshold) {
            n2 = this.items.length;
            int n3 = n2 * 2 + 1;
            Item[] itemArray = new Item[n3];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                Item item2 = this.items[i2];
                while (item2 != null) {
                    int n4 = item2.hashCode % itemArray.length;
                    Item item3 = item2.next;
                    item2.next = itemArray[n4];
                    itemArray[n4] = item2;
                    item2 = item3;
                }
            }
            this.items = itemArray;
            this.threshold = (int)((double)n3 * 0.75);
        }
        n2 = item.hashCode % this.items.length;
        item.next = this.items[n2];
        this.items[n2] = item;
    }
}

