/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser;

import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.JSONLexerBase;
import com.icbc.api.internal.util.fastjson.parser.JSONScanner;
import com.icbc.api.internal.util.fastjson.parser.JSONToken;
import com.icbc.api.internal.util.fastjson.parser.ParseContext;
import com.icbc.api.internal.util.fastjson.parser.ParserConfig;
import com.icbc.api.internal.util.fastjson.parser.SymbolTable;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ExtraProcessable;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ExtraProcessor;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ExtraTypeProvider;
import com.icbc.api.internal.util.fastjson.parser.deserializer.FieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.FieldTypeResolver;
import com.icbc.api.internal.util.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.MapDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.PropertyProcessable;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ResolveFieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ThrowableDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.BeanContext;
import com.icbc.api.internal.util.fastjson.serializer.IntegerCodec;
import com.icbc.api.internal.util.fastjson.serializer.LongCodec;
import com.icbc.api.internal.util.fastjson.serializer.StringCodec;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import com.icbc.api.internal.util.internal.util.fastjson.JSONPath;
import com.icbc.api.internal.util.internal.util.fastjson.JSONPathException;
import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultJSONParser
implements Closeable {
    public final Object input;
    public final SymbolTable symbolTable;
    protected ParserConfig config;
    private static final Set<Class<?>> primitiveClasses;
    private String dateFormatPattern = JSON.DEFFAULT_DATE_FORMAT;
    private DateFormat dateFormat;
    public final JSONLexer lexer;
    protected ParseContext context;
    private ParseContext[] contextArray;
    private int contextArrayIndex = 0;
    private List<ResolveTask> resolveTaskList;
    public static final int NONE = 0;
    public static final int NeedToResolve = 1;
    public static final int TypeNameRedirect = 2;
    public int resolveStatus = 0;
    private List<ExtraTypeProvider> extraTypeProviders = null;
    private List<ExtraProcessor> extraProcessors = null;
    protected FieldTypeResolver fieldTypeResolver = null;
    private int objectKeyLevel = 0;
    private boolean autoTypeEnable;
    private String[] autoTypeAccept = null;
    protected transient BeanContext lastBeanContext;

    public String getDateFomartPattern() {
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPattern, this.lexer.getLocale());
            this.dateFormat.setTimeZone(this.lexer.getTimeZone());
        }
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormatPattern = string;
        this.dateFormat = null;
    }

    public void setDateFomrat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DefaultJSONParser(String string) {
        this(string, ParserConfig.getGlobalInstance(), JSON.DEFAULT_PARSER_FEATURE);
    }

    public DefaultJSONParser(String string, ParserConfig parserConfig) {
        this((Object)string, new JSONScanner(string, JSON.DEFAULT_PARSER_FEATURE), parserConfig);
    }

    public DefaultJSONParser(String string, ParserConfig parserConfig, int n2) {
        this((Object)string, new JSONScanner(string, n2), parserConfig);
    }

    public DefaultJSONParser(char[] cArray, int n2, ParserConfig parserConfig, int n3) {
        this(cArray, new JSONScanner(cArray, n2, n3), parserConfig);
    }

    public DefaultJSONParser(JSONLexer jSONLexer) {
        this(jSONLexer, ParserConfig.getGlobalInstance());
    }

    public DefaultJSONParser(JSONLexer jSONLexer, ParserConfig parserConfig) {
        this(null, jSONLexer, parserConfig);
    }

    public DefaultJSONParser(Object object, JSONLexer jSONLexer, ParserConfig parserConfig) {
        this.lexer = jSONLexer;
        this.input = object;
        this.config = parserConfig;
        this.symbolTable = parserConfig.symbolTable;
        char c2 = jSONLexer.getCurrent();
        if (c2 == '{') {
            jSONLexer.next();
            ((JSONLexerBase)jSONLexer).token = 12;
        } else if (c2 == '[') {
            jSONLexer.next();
            ((JSONLexerBase)jSONLexer).token = 14;
        } else {
            jSONLexer.nextToken();
        }
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public String getInput() {
        if (this.input instanceof char[]) {
            return new String((char[])this.input);
        }
        return this.input.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object parseObject(Map var1_1, Object var2_2) {
        block102: {
            block103: {
                var3_3 = this.lexer;
                if (var3_3.token() == 8) {
                    var3_3.nextToken();
                    return null;
                }
                if (var3_3.token() == 13) {
                    var3_3.nextToken();
                    return var1_1;
                }
                if (var3_3.token() == 4 && var3_3.stringVal().length() == 0) {
                    var3_3.nextToken();
                    return var1_1;
                }
                if (var3_3.token() != 12 && var3_3.token() != 16) {
                    throw new JSONException("syntax error, expect {, actual " + var3_3.tokenName() + ", " + var3_3.info());
                }
                var4_4 = this.context;
                var5_5 = var1_1 instanceof JSONObject;
                var6_6 = var5_5 != false ? ((JSONObject)var1_1).getInnerMap() : var1_1;
                var7_7 = false;
lbl18:
                // 2 sources

                while (true) {
                    block105: {
                        block104: {
                            block106: {
                                var3_3.skipWhitespace();
                                var8_8 = var3_3.getCurrent();
                                if (var3_3.isEnabled(Feature.AllowArbitraryCommas)) {
                                    while (var8_8 == ',') {
                                        var3_3.next();
                                        var3_3.skipWhitespace();
                                        var8_8 = var3_3.getCurrent();
                                    }
                                }
                                var9_9 = false;
                                if (var8_8 == '\"') {
                                    var10_10 = var3_3.scanSymbol(this.symbolTable, '\"');
                                    var3_3.skipWhitespace();
                                    var8_8 = var3_3.getCurrent();
                                    if (var8_8 != ':') {
                                        throw new JSONException("expect ':' at " + var3_3.pos() + ", name " + var10_10);
                                    }
                                } else {
                                    if (var8_8 == '}') {
                                        var3_3.next();
                                        var3_3.resetStringPosition();
                                        var3_3.nextToken();
                                        if (!var7_7) {
                                            if (this.context != null && var2_2 == this.context.fieldName && var1_1 == this.context.object) {
                                                var4_4 = this.context;
                                            } else {
                                                var11_11 /* !! */  = this.setContext(var1_1, var2_2);
                                                if (var4_4 == null) {
                                                    var4_4 = var11_11 /* !! */ ;
                                                }
                                                var7_7 = true;
                                            }
                                        }
                                        var11_11 /* !! */  = var1_1;
                                        return var11_11 /* !! */ ;
                                    }
                                    if (var8_8 == '\'') {
                                        if (!var3_3.isEnabled(Feature.AllowSingleQuotes)) {
                                            throw new JSONException("syntax error");
                                        }
                                        var10_10 = var3_3.scanSymbol(this.symbolTable, '\'');
                                        var3_3.skipWhitespace();
                                        var8_8 = var3_3.getCurrent();
                                        if (var8_8 != ':') {
                                            throw new JSONException("expect ':' at " + var3_3.pos());
                                        }
                                    } else {
                                        if (var8_8 == '\u001a') {
                                            throw new JSONException("syntax error");
                                        }
                                        if (var8_8 == ',') {
                                            throw new JSONException("syntax error");
                                        }
                                        if (var8_8 >= '0' && var8_8 <= '9' || var8_8 == '-') {
                                            var3_3.resetStringPosition();
                                            var3_3.scanNumber();
                                            try {
                                                var10_10 = var3_3.token() == 2 ? var3_3.integerValue() : var3_3.decimalValue(true);
                                                if (var3_3.isEnabled(Feature.NonStringKeyAsString) || var5_5) {
                                                    var10_10 = var10_10.toString();
                                                }
                                            }
                                            catch (NumberFormatException var11_12) {
                                                throw new JSONException("parse number key error" + var3_3.info());
                                            }
                                            var8_8 = var3_3.getCurrent();
                                            if (var8_8 != ':') {
                                                throw new JSONException("parse number key error" + var3_3.info());
                                            }
                                        } else if (var8_8 == '{' || var8_8 == '[') {
                                            if (this.objectKeyLevel++ > 512) {
                                                throw new JSONException("object key level > 512");
                                            }
                                            var3_3.nextToken();
                                            var10_10 = this.parse();
                                            var9_9 = true;
                                        } else {
                                            if (!var3_3.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                                                throw new JSONException("syntax error");
                                            }
                                            var10_10 = var3_3.scanSymbolUnQuoted(this.symbolTable);
                                            var3_3.skipWhitespace();
                                            var8_8 = var3_3.getCurrent();
                                            if (var8_8 != ':') {
                                                throw new JSONException("expect ':' at " + var3_3.pos() + ", actual " + var8_8);
                                            }
                                        }
                                    }
                                }
                                if (!var9_9) {
                                    var3_3.next();
                                    var3_3.skipWhitespace();
                                }
                                var8_8 = var3_3.getCurrent();
                                var3_3.resetStringPosition();
                                if (var10_10 == JSON.DEFAULT_TYPE_KEY && !var3_3.isEnabled(Feature.DisableSpecialKeyDetect)) {
                                    var11_11 /* !! */  = var3_3.scanSymbol(this.symbolTable, '\"');
                                    if (var3_3.isEnabled(Feature.IgnoreAutoType)) continue;
                                    var12_13 = null;
                                    if (var1_1 != null && var1_1.getClass().getName().equals(var11_11 /* !! */ )) {
                                        var12_13 = var1_1.getClass();
                                        break block102;
                                    }
                                    var13_15 = true;
                                    break block103;
                                }
                                if (var10_10 != "$ref" || var4_4 == null || var1_1 != null && var1_1.size() != 0 || var3_3.isEnabled(Feature.DisableSpecialKeyDetect)) break block105;
                                var3_3.nextToken(4);
                                if (var3_3.token() != 4) throw new JSONException("illegal ref, " + JSONToken.name(var3_3.token()));
                                var11_11 /* !! */  = var3_3.stringVal();
                                var3_3.nextToken(13);
                                if (var3_3.token() == 16) {
                                    var6_6.put((String)var10_10, var11_11 /* !! */ );
                                    continue;
                                }
                                var12_13 = null;
                                if (!"@".equals(var11_11 /* !! */ )) break block106;
                                if (this.context != null) {
                                    var13_20 = this.context;
                                    var14_30 = var13_20.object;
                                    if (var14_30 instanceof Object[] || var14_30 instanceof Collection) {
                                        var12_13 = var14_30;
                                        break block104;
                                    } else if (var13_20.parent != null) {
                                        var12_13 = var13_20.parent.object;
                                    }
                                }
                                break block104;
                            }
                            if ("..".equals(var11_11 /* !! */ )) {
                                if (var4_4.object != null) {
                                    var12_13 = var4_4.object;
                                } else {
                                    this.addResolveTask(new ResolveTask((ParseContext)var4_4, (String)var11_11 /* !! */ ));
                                    this.setResolveStatus(1);
                                }
                            } else if ("$".equals(var11_11 /* !! */ )) {
                                var13_21 = var4_4;
                                while (var13_21.parent != null) {
                                    var13_21 = var13_21.parent;
                                }
                                if (var13_21.object != null) {
                                    var12_13 = var13_21.object;
                                } else {
                                    this.addResolveTask(new ResolveTask((ParseContext)var13_21, (String)var11_11 /* !! */ ));
                                    this.setResolveStatus(1);
                                }
                            } else {
                                this.addResolveTask(new ResolveTask((ParseContext)var4_4, (String)var11_11 /* !! */ ));
                                this.setResolveStatus(1);
                            }
                        }
                        if (var3_3.token() != 13) {
                            throw new JSONException("syntax error, " + var3_3.info());
                        }
                        var3_3.nextToken(16);
                        var13_22 = var12_13;
                        return var13_22;
                    }
                    if (!var7_7) {
                        if (this.context != null && var2_2 == this.context.fieldName && var1_1 == this.context.object) {
                            var4_4 = this.context;
                        } else {
                            var11_11 /* !! */  = this.setContext(var1_1, var2_2);
                            if (var4_4 == null) {
                                var4_4 = var11_11 /* !! */ ;
                            }
                            var7_7 = true;
                        }
                    }
                    if (var1_1.getClass() == JSONObject.class && var10_10 == null) {
                        var10_10 = "null";
                    }
                    if (var8_8 == '\"') {
                        var3_3.scanString();
                        var12_13 = var3_3.stringVal();
                        var11_11 /* !! */  = var12_13;
                        if (var3_3.isEnabled(Feature.AllowISO8601DateFormat)) {
                            var13_23 = new JSONScanner((String)var12_13);
                            if (var13_23.scanISO8601DateIfMatch()) {
                                var11_11 /* !! */  = var13_23.getCalendar().getTime();
                            }
                            var13_23.close();
                        }
                        var6_6.put((String)var10_10, var11_11 /* !! */ );
                    } else if (var8_8 >= '0' && var8_8 <= '9' || var8_8 == '-') {
                        var3_3.scanNumber();
                        var11_11 /* !! */  = var3_3.token() == 2 ? var3_3.integerValue() : var3_3.decimalValue(var3_3.isEnabled(Feature.UseBigDecimal));
                        var6_6.put((String)var10_10, var11_11 /* !! */ );
                    } else {
                        if (var8_8 == '[') {
                            var3_3.nextToken();
                            var12_13 = new JSONArray();
                            v0 = var13_24 = var2_2 != null && var2_2.getClass() == Integer.class;
                            if (var2_2 == null) {
                                this.setContext((ParseContext)var4_4);
                            }
                            this.parseArray((Collection)var12_13, var10_10);
                            var11_11 /* !! */  = var3_3.isEnabled(Feature.UseObjectArray) != false ? var12_13.toArray() : var12_13;
                            var6_6.put((String)var10_10, var11_11 /* !! */ );
                            if (var3_3.token() == 13) {
                                var3_3.nextToken();
                                var14_31 = var1_1;
                                return var14_31;
                            }
                            if (var3_3.token() != 16) throw new JSONException("syntax error");
                            continue;
                        }
                        if (var8_8 == '{') {
                            var3_3.nextToken();
                            v1 = var12_14 = var2_2 != null && var2_2.getClass() == Integer.class;
                            if (var3_3.isEnabled(Feature.CustomMapDeserializer)) {
                                var14_32 = (MapDeserializer)this.config.getDeserializer((Type)Map.class);
                                var13_25 /* !! */  = (var3_3.getFeatures() & Feature.OrderedField.mask) != 0 ? var14_32.createMap((Type)Map.class, var3_3.getFeatures()) : var14_32.createMap((Type)Map.class);
                            } else {
                                var13_25 /* !! */  = new JSONObject(var3_3.isEnabled(Feature.OrderedField));
                            }
                            var14_33 = null;
                            if (!var12_14) {
                                var14_33 = this.setContext((ParseContext)var4_4, var13_25 /* !! */ , var10_10);
                            }
                            var15_37 = null;
                            var16_38 = false;
                            if (this.fieldTypeResolver != null && (var18_41 = this.fieldTypeResolver.resolve(var1_1, (String)(var17_40 = var10_10 != null ? var10_10.toString() : null))) != null) {
                                var19_42 = this.config.getDeserializer(var18_41);
                                var15_37 = var19_42.deserialze(this, var18_41, var10_10);
                                var16_38 = true;
                            }
                            if (!var16_38) {
                                var15_37 = this.parseObject(var13_25 /* !! */ , var10_10);
                            }
                            if (var14_33 != null && var13_25 /* !! */  != var15_37) {
                                var14_33.object = var1_1;
                            }
                            if (var10_10 != null) {
                                this.checkMapResolve(var1_1, var10_10.toString());
                            }
                            var6_6.put((String)var10_10, var15_37);
                            if (var12_14) {
                                this.setContext(var15_37, var10_10);
                            }
                            if (var3_3.token() == 13) {
                                var3_3.nextToken();
                                this.setContext((ParseContext)var4_4);
                                var17_40 = var1_1;
                                return var17_40;
                            }
                            if (var3_3.token() != 16) throw new JSONException("syntax error, " + var3_3.tokenName());
                            if (var12_14) {
                                this.popContext();
                                continue;
                            }
                            this.setContext((ParseContext)var4_4);
                            continue;
                        }
                        var3_3.nextToken();
                        var11_11 /* !! */  = this.parse();
                        var6_6.put((String)var10_10, var11_11 /* !! */ );
                        if (var3_3.token() == 13) {
                            var3_3.nextToken();
                            var12_13 = var1_1;
                            return var12_13;
                        }
                        if (var3_3.token() != 16) throw new JSONException("syntax error, position at " + var3_3.pos() + ", name " + var10_10);
                        continue;
                    }
                    var3_3.skipWhitespace();
                    var8_8 = var3_3.getCurrent();
                    if (var8_8 == ',') {
                        var3_3.next();
                        continue;
                    }
                    if (var8_8 != '}') throw new JSONException("syntax error, position at " + var3_3.pos() + ", name " + var10_10);
                    var3_3.next();
                    var3_3.resetStringPosition();
                    var3_3.nextToken();
                    this.setContext(var11_11 /* !! */ , var10_10);
                    var12_13 = var1_1;
                    return var12_13;
                }
                finally {
                    this.setContext((ParseContext)var4_4);
                }
            }
            for (var14_26 = 0; var14_26 < var11_11 /* !! */ .length(); ++var14_26) {
                var15_34 = var11_11 /* !! */ .charAt(var14_26);
                if (var15_34 >= '0' && var15_34 <= '9') continue;
                var13_15 = false;
                break;
            }
            if (!var13_15) {
                var12_13 = this.config.checkAutoType((String)var11_11 /* !! */ , null, var3_3.getFeatures());
            }
        }
        if (var12_13 == null) {
            var6_6.put(JSON.DEFAULT_TYPE_KEY, var11_11 /* !! */ );
            ** continue;
        }
        var3_3.nextToken(16);
        if (var3_3.token() == 13) {
            var3_3.nextToken(16);
            try {
                var13_16 /* !! */  = null;
                var14_27 = this.config.getDeserializer((Type)var12_13);
                if (var14_27 instanceof JavaBeanDeserializer) {
                    var13_16 /* !! */  = (HashMap<K, V>)TypeUtils.cast(var1_1, var12_13, this.config);
                }
                if (var13_16 /* !! */  == null) {
                    var13_16 /* !! */  = var12_13 == Cloneable.class ? new HashMap<K, V>() : ("java.util.Collections$EmptyMap".equals(var11_11 /* !! */ ) != false ? Collections.emptyMap() : ("java.util.Collections$UnmodifiableMap".equals(var11_11 /* !! */ ) != false ? Collections.unmodifiableMap(new HashMap<K, V>()) : var12_13.newInstance()));
                }
                var15_35 = var13_16 /* !! */ ;
                return var15_35;
            }
            catch (Exception var13_17) {
                throw new JSONException("create instance error", var13_17);
            }
        }
        this.setResolveStatus(2);
        if (this.context != null && var2_2 != null && !(var2_2 instanceof Integer) && !(this.context.fieldName instanceof Integer)) {
            this.popContext();
        }
        if (var1_1.size() > 0) {
            var13_18 = TypeUtils.cast(var1_1, var12_13, this.config);
            this.setResolveStatus(0);
            this.parseObject(var13_18);
            var14_28 = var13_18;
            return var14_28;
        }
        var13_19 = this.config.getDeserializer((Type)var12_13);
        var14_29 = var13_19.getClass();
        if (JavaBeanDeserializer.class.isAssignableFrom(var14_29) && var14_29 != JavaBeanDeserializer.class && var14_29 != ThrowableDeserializer.class) {
            this.setResolveStatus(0);
        } else if (var13_19 instanceof MapDeserializer) {
            this.setResolveStatus(0);
        }
        var16_39 = var15_36 = var13_19.deserialze(this, (Type)var12_13, var2_2);
        return var16_39;
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public void setConfig(ParserConfig parserConfig) {
        this.config = parserConfig;
    }

    public <T> T parseObject(Class<T> clazz) {
        return this.parseObject(clazz, null);
    }

    public <T> T parseObject(Type type) {
        return this.parseObject(type, null);
    }

    public <T> T parseObject(Type type, Object object) {
        int n2 = this.lexer.token();
        if (n2 == 8) {
            this.lexer.nextToken();
            return null;
        }
        if (n2 == 4) {
            if (type == byte[].class) {
                byte[] byArray = this.lexer.bytesValue();
                this.lexer.nextToken();
                return (T)byArray;
            }
            if (type == char[].class) {
                String string = this.lexer.stringVal();
                this.lexer.nextToken();
                return (T)string.toCharArray();
            }
        }
        ObjectDeserializer objectDeserializer = this.config.getDeserializer(type);
        try {
            if (objectDeserializer.getClass() == JavaBeanDeserializer.class) {
                if (this.lexer.token() != 12 && this.lexer.token() != 14) {
                    throw new JSONException("syntax error,except start with { or [,but actually start with " + this.lexer.tokenName());
                }
                return ((JavaBeanDeserializer)objectDeserializer).deserialze(this, type, object, 0);
            }
            return objectDeserializer.deserialze(this, type, object);
        }
        catch (JSONException jSONException) {
            throw jSONException;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable.getMessage(), throwable);
        }
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        this.parseArray(clazz, arrayList);
        return arrayList;
    }

    public void parseArray(Class<?> clazz, Collection collection) {
        this.parseArray((Type)clazz, collection);
    }

    public void parseArray(Type type, Collection collection) {
        this.parseArray(type, collection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseArray(Type type, Collection collection, Object object) {
        int n2 = this.lexer.token();
        if (n2 == 21 || n2 == 22) {
            this.lexer.nextToken();
            n2 = this.lexer.token();
        }
        if (n2 != 14) {
            throw new JSONException("expect '[', but " + JSONToken.name(n2) + ", " + this.lexer.info());
        }
        ObjectDeserializer objectDeserializer = null;
        if (Integer.TYPE == type) {
            objectDeserializer = IntegerCodec.instance;
            this.lexer.nextToken(2);
        } else if (String.class == type) {
            objectDeserializer = StringCodec.instance;
            this.lexer.nextToken(4);
        } else {
            objectDeserializer = this.config.getDeserializer(type);
            this.lexer.nextToken(objectDeserializer.getFastMatchToken());
        }
        ParseContext parseContext = this.context;
        this.setContext(collection, object);
        try {
            int n3 = 0;
            while (true) {
                Object object2;
                if (this.lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (this.lexer.token() == 16) {
                        this.lexer.nextToken();
                    }
                }
                if (this.lexer.token() == 15) {
                    break;
                }
                if (Integer.TYPE == type) {
                    object2 = IntegerCodec.instance.deserialze(this, null, null);
                    collection.add(object2);
                } else if (String.class == type) {
                    if (this.lexer.token() == 4) {
                        object2 = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        Object object3 = this.parse();
                        object2 = object3 == null ? null : object3.toString();
                    }
                    collection.add(object2);
                } else {
                    if (this.lexer.token() == 8) {
                        this.lexer.nextToken();
                        object2 = null;
                    } else {
                        object2 = objectDeserializer.deserialze(this, type, n3);
                    }
                    collection.add(object2);
                    this.checkListResolve(collection);
                }
                if (this.lexer.token() == 16) {
                    this.lexer.nextToken(objectDeserializer.getFastMatchToken());
                }
                ++n3;
            }
        }
        finally {
            this.setContext(parseContext);
        }
        this.lexer.nextToken(16);
    }

    public Object[] parseArray(Type[] typeArray) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken(16);
            return null;
        }
        if (this.lexer.token() != 14) {
            throw new JSONException("syntax error : " + this.lexer.tokenName());
        }
        Object[] objectArray = new Object[typeArray.length];
        if (typeArray.length == 0) {
            this.lexer.nextToken(15);
            if (this.lexer.token() != 15) {
                throw new JSONException("syntax error");
            }
            this.lexer.nextToken(16);
            return new Object[0];
        }
        this.lexer.nextToken(2);
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            Object object;
            if (this.lexer.token() == 8) {
                object = null;
                this.lexer.nextToken(16);
            } else {
                Type type = typeArray[i2];
                if (type == Integer.TYPE || type == Integer.class) {
                    if (this.lexer.token() == 2) {
                        object = this.lexer.intValue();
                        this.lexer.nextToken(16);
                    } else {
                        object = this.parse();
                        object = TypeUtils.cast(object, type, this.config);
                    }
                } else if (type == String.class) {
                    if (this.lexer.token() == 4) {
                        object = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        object = this.parse();
                        object = TypeUtils.cast(object, type, this.config);
                    }
                } else {
                    ArrayList arrayList;
                    boolean bl = false;
                    Class<?> clazz = null;
                    if (i2 == typeArray.length - 1 && type instanceof Class && ((arrayList = (Class)type) != byte[].class && arrayList != char[].class || this.lexer.token() != 4)) {
                        bl = ((Class)((Object)arrayList)).isArray();
                        clazz = ((Class)((Object)arrayList)).getComponentType();
                    }
                    if (bl && this.lexer.token() != 14) {
                        arrayList = new ArrayList();
                        ObjectDeserializer objectDeserializer = this.config.getDeserializer(clazz);
                        int n2 = objectDeserializer.getFastMatchToken();
                        if (this.lexer.token() != 15) {
                            while (true) {
                                Object t2 = objectDeserializer.deserialze(this, type, null);
                                arrayList.add(t2);
                                if (this.lexer.token() != 16) break;
                                this.lexer.nextToken(n2);
                            }
                            if (this.lexer.token() != 15) {
                                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
                            }
                        }
                        object = TypeUtils.cast(arrayList, type, this.config);
                    } else {
                        arrayList = this.config.getDeserializer(type);
                        object = arrayList.deserialze(this, type, i2);
                    }
                }
            }
            objectArray[i2] = object;
            if (this.lexer.token() == 15) break;
            if (this.lexer.token() != 16) {
                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
            }
            if (i2 == typeArray.length - 1) {
                this.lexer.nextToken(15);
                continue;
            }
            this.lexer.nextToken(2);
        }
        if (this.lexer.token() != 15) {
            throw new JSONException("syntax error");
        }
        this.lexer.nextToken(16);
        return objectArray;
    }

    public void parseObject(Object object) {
        block14: {
            Class<?> clazz = object.getClass();
            JavaBeanDeserializer javaBeanDeserializer = null;
            ObjectDeserializer objectDeserializer = this.config.getDeserializer(clazz);
            if (objectDeserializer instanceof JavaBeanDeserializer) {
                javaBeanDeserializer = (JavaBeanDeserializer)objectDeserializer;
            }
            if (this.lexer.token() != 12 && this.lexer.token() != 16) {
                throw new JSONException("syntax error, expect {, actual " + this.lexer.tokenName());
            }
            while (true) {
                Object t2;
                String string;
                if ((string = this.lexer.scanSymbol(this.symbolTable)) == null) {
                    if (this.lexer.token() != 13) {
                        if (this.lexer.token() == 16 && this.lexer.isEnabled(Feature.AllowArbitraryCommas)) continue;
                    }
                    break block14;
                }
                FieldDeserializer fieldDeserializer = null;
                if (javaBeanDeserializer != null) {
                    fieldDeserializer = javaBeanDeserializer.getFieldDeserializer(string);
                }
                if (fieldDeserializer == null) {
                    if (!this.lexer.isEnabled(Feature.IgnoreNotMatch)) {
                        throw new JSONException("setter not found, class " + clazz.getName() + ", property " + string);
                    }
                    this.lexer.nextTokenWithColon();
                    this.parse();
                    if (this.lexer.token() != 13) continue;
                    this.lexer.nextToken();
                    return;
                }
                Class<?> clazz2 = fieldDeserializer.fieldInfo.fieldClass;
                Type type = fieldDeserializer.fieldInfo.fieldType;
                if (clazz2 == Integer.TYPE) {
                    this.lexer.nextTokenWithColon(2);
                    t2 = IntegerCodec.instance.deserialze(this, type, null);
                } else if (clazz2 == String.class) {
                    this.lexer.nextTokenWithColon(4);
                    t2 = StringCodec.deserialze(this);
                } else if (clazz2 == Long.TYPE) {
                    this.lexer.nextTokenWithColon(2);
                    t2 = LongCodec.instance.deserialze(this, type, null);
                } else {
                    ObjectDeserializer objectDeserializer2 = this.config.getDeserializer(clazz2, type);
                    this.lexer.nextTokenWithColon(objectDeserializer2.getFastMatchToken());
                    t2 = objectDeserializer2.deserialze(this, type, null);
                }
                fieldDeserializer.setValue(object, t2);
                if (this.lexer.token() != 16 && this.lexer.token() == 13) break;
            }
            this.lexer.nextToken(16);
            return;
        }
        this.lexer.nextToken(16);
    }

    public Object parseArrayWithType(Type type) {
        Object object;
        Type type2;
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        if (typeArray.length != 1) {
            throw new JSONException("not support type " + type);
        }
        Type type3 = typeArray[0];
        if (type3 instanceof Class) {
            ArrayList arrayList = new ArrayList();
            this.parseArray((Class)type3, arrayList);
            return arrayList;
        }
        if (type3 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type3;
            Type type4 = wildcardType.getUpperBounds()[0];
            if (Object.class.equals((Object)type4)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    return this.parse();
                }
                throw new JSONException("not support type : " + type);
            }
            ArrayList arrayList = new ArrayList();
            this.parseArray((Class)type4, arrayList);
            return arrayList;
        }
        if (type3 instanceof TypeVariable) {
            type2 = (TypeVariable)type3;
            object = type2.getBounds();
            if (((Type[])object).length != 1) {
                throw new JSONException("not support : " + type2);
            }
            Type type5 = object[0];
            if (type5 instanceof Class) {
                ArrayList arrayList = new ArrayList();
                this.parseArray((Class)type5, arrayList);
                return arrayList;
            }
        }
        if (type3 instanceof ParameterizedType) {
            type2 = (ParameterizedType)type3;
            object = new ArrayList();
            this.parseArray(type2, (Collection)object);
            return object;
        }
        throw new JSONException("TODO : " + type);
    }

    public void acceptType(String string) {
        JSONLexer jSONLexer = this.lexer;
        jSONLexer.nextTokenWithColon();
        if (jSONLexer.token() != 4) {
            throw new JSONException("type not match error");
        }
        if (string.equals(jSONLexer.stringVal())) {
            jSONLexer.nextToken();
            if (jSONLexer.token() == 16) {
                jSONLexer.nextToken();
            }
        } else {
            throw new JSONException("type not match error");
        }
    }

    public int getResolveStatus() {
        return this.resolveStatus;
    }

    public void setResolveStatus(int n2) {
        this.resolveStatus = n2;
    }

    public Object getObject(String string) {
        for (int i2 = 0; i2 < this.contextArrayIndex; ++i2) {
            if (!string.equals(this.contextArray[i2].toString())) continue;
            return this.contextArray[i2].object;
        }
        return null;
    }

    public void checkListResolve(Collection collection) {
        if (this.resolveStatus == 1) {
            if (collection instanceof List) {
                int n2 = collection.size() - 1;
                List list = (List)collection;
                ResolveTask resolveTask = this.getLastResolveTask();
                resolveTask.fieldDeserializer = new ResolveFieldDeserializer(this, list, n2);
                resolveTask.ownerContext = this.context;
                this.setResolveStatus(0);
            } else {
                ResolveTask resolveTask = this.getLastResolveTask();
                resolveTask.fieldDeserializer = new ResolveFieldDeserializer(collection);
                resolveTask.ownerContext = this.context;
                this.setResolveStatus(0);
            }
        }
    }

    public void checkMapResolve(Map map, Object object) {
        if (this.resolveStatus == 1) {
            ResolveFieldDeserializer resolveFieldDeserializer = new ResolveFieldDeserializer(map, object);
            ResolveTask resolveTask = this.getLastResolveTask();
            resolveTask.fieldDeserializer = resolveFieldDeserializer;
            resolveTask.ownerContext = this.context;
            this.setResolveStatus(0);
        }
    }

    public Object parseObject(Map map) {
        return this.parseObject(map, null);
    }

    public JSONObject parseObject() {
        JSONObject jSONObject = new JSONObject(this.lexer.isEnabled(Feature.OrderedField));
        Object object = this.parseObject(jSONObject);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object == null) {
            return null;
        }
        return new JSONObject((Map)object);
    }

    public final void parseArray(Collection collection) {
        this.parseArray(collection, null);
    }

    public final void parseArray(Collection collection, Object object) {
        JSONLexer jSONLexer = this.lexer;
        if (jSONLexer.token() == 21 || jSONLexer.token() == 22) {
            jSONLexer.nextToken();
        }
        if (jSONLexer.token() != 14) {
            throw new JSONException("syntax error, expect [, actual " + JSONToken.name(jSONLexer.token()) + ", pos " + jSONLexer.pos() + ", fieldName " + object);
        }
        jSONLexer.nextToken(4);
        if (this.context != null && this.context.level > 512) {
            throw new JSONException("array level > 512");
        }
        ParseContext parseContext = this.context;
        this.setContext(collection, object);
        try {
            int n2 = 0;
            while (true) {
                Object object2;
                if (jSONLexer.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (jSONLexer.token() == 16) {
                        jSONLexer.nextToken();
                    }
                }
                switch (jSONLexer.token()) {
                    case 2: {
                        object2 = jSONLexer.integerValue();
                        jSONLexer.nextToken(16);
                        break;
                    }
                    case 3: {
                        object2 = jSONLexer.isEnabled(Feature.UseBigDecimal) ? (Number)jSONLexer.decimalValue(true) : (Number)jSONLexer.decimalValue(false);
                        jSONLexer.nextToken(16);
                        break;
                    }
                    case 4: {
                        Object object3;
                        String string = jSONLexer.stringVal();
                        jSONLexer.nextToken(16);
                        if (jSONLexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                            object3 = new JSONScanner(string);
                            object2 = ((JSONScanner)object3).scanISO8601DateIfMatch() ? ((JSONLexerBase)object3).getCalendar().getTime() : string;
                            ((JSONLexerBase)object3).close();
                            break;
                        }
                        object2 = string;
                        break;
                    }
                    case 6: {
                        object2 = Boolean.TRUE;
                        jSONLexer.nextToken(16);
                        break;
                    }
                    case 7: {
                        object2 = Boolean.FALSE;
                        jSONLexer.nextToken(16);
                        break;
                    }
                    case 12: {
                        Object object3 = new JSONObject(jSONLexer.isEnabled(Feature.OrderedField));
                        object2 = this.parseObject((Map)object3, (Object)n2);
                        break;
                    }
                    case 14: {
                        JSONArray jSONArray = new JSONArray();
                        this.parseArray(jSONArray, n2);
                        if (jSONLexer.isEnabled(Feature.UseObjectArray)) {
                            object2 = jSONArray.toArray();
                            break;
                        }
                        object2 = jSONArray;
                        break;
                    }
                    case 8: {
                        object2 = null;
                        jSONLexer.nextToken(4);
                        break;
                    }
                    case 23: {
                        object2 = null;
                        jSONLexer.nextToken(4);
                        break;
                    }
                    case 15: {
                        jSONLexer.nextToken(16);
                        return;
                    }
                    case 20: {
                        throw new JSONException("unclosed jsonArray");
                    }
                    default: {
                        object2 = this.parse();
                    }
                }
                collection.add(object2);
                this.checkListResolve(collection);
                if (jSONLexer.token() == 16) {
                    jSONLexer.nextToken(4);
                }
                ++n2;
            }
        }
        finally {
            this.setContext(parseContext);
        }
    }

    public ParseContext getContext() {
        return this.context;
    }

    public List<ResolveTask> getResolveTaskList() {
        if (this.resolveTaskList == null) {
            this.resolveTaskList = new ArrayList<ResolveTask>(2);
        }
        return this.resolveTaskList;
    }

    public void addResolveTask(ResolveTask resolveTask) {
        if (this.resolveTaskList == null) {
            this.resolveTaskList = new ArrayList<ResolveTask>(2);
        }
        this.resolveTaskList.add(resolveTask);
    }

    public ResolveTask getLastResolveTask() {
        return this.resolveTaskList.get(this.resolveTaskList.size() - 1);
    }

    public List<ExtraProcessor> getExtraProcessors() {
        if (this.extraProcessors == null) {
            this.extraProcessors = new ArrayList<ExtraProcessor>(2);
        }
        return this.extraProcessors;
    }

    public List<ExtraTypeProvider> getExtraTypeProviders() {
        if (this.extraTypeProviders == null) {
            this.extraTypeProviders = new ArrayList<ExtraTypeProvider>(2);
        }
        return this.extraTypeProviders;
    }

    public FieldTypeResolver getFieldTypeResolver() {
        return this.fieldTypeResolver;
    }

    public void setFieldTypeResolver(FieldTypeResolver fieldTypeResolver) {
        this.fieldTypeResolver = fieldTypeResolver;
    }

    public void setContext(ParseContext parseContext) {
        if (this.lexer.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = parseContext;
    }

    public void popContext() {
        if (this.lexer.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = this.context.parent;
        if (this.contextArrayIndex <= 0) {
            return;
        }
        --this.contextArrayIndex;
        this.contextArray[this.contextArrayIndex] = null;
    }

    public ParseContext setContext(Object object, Object object2) {
        if (this.lexer.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return null;
        }
        return this.setContext(this.context, object, object2);
    }

    public ParseContext setContext(ParseContext parseContext, Object object, Object object2) {
        if (this.lexer.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return null;
        }
        this.context = new ParseContext(parseContext, object, object2);
        this.addContext(this.context);
        return this.context;
    }

    private void addContext(ParseContext parseContext) {
        int n2 = this.contextArrayIndex++;
        if (this.contextArray == null) {
            this.contextArray = new ParseContext[8];
        } else if (n2 >= this.contextArray.length) {
            int n3 = this.contextArray.length * 3 / 2;
            ParseContext[] parseContextArray = new ParseContext[n3];
            System.arraycopy(this.contextArray, 0, parseContextArray, 0, this.contextArray.length);
            this.contextArray = parseContextArray;
        }
        this.contextArray[n2] = parseContext;
    }

    public Object parse() {
        return this.parse(null);
    }

    public Object parseKey() {
        if (this.lexer.token() == 18) {
            String string = this.lexer.stringVal();
            this.lexer.nextToken(16);
            return string;
        }
        return this.parse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Object object) {
        JSONLexer jSONLexer = this.lexer;
        switch (jSONLexer.token()) {
            case 21: {
                jSONLexer.nextToken();
                HashSet hashSet = new HashSet();
                this.parseArray(hashSet, object);
                return hashSet;
            }
            case 22: {
                jSONLexer.nextToken();
                TreeSet treeSet = new TreeSet();
                this.parseArray(treeSet, object);
                return treeSet;
            }
            case 14: {
                JSONArray jSONArray = new JSONArray();
                this.parseArray(jSONArray, object);
                if (jSONLexer.isEnabled(Feature.UseObjectArray)) {
                    return jSONArray.toArray();
                }
                return jSONArray;
            }
            case 12: {
                JSONObject jSONObject = new JSONObject(jSONLexer.isEnabled(Feature.OrderedField));
                return this.parseObject(jSONObject, object);
            }
            case 2: {
                Number number = jSONLexer.integerValue();
                jSONLexer.nextToken();
                return number;
            }
            case 3: {
                Number number = jSONLexer.decimalValue(jSONLexer.isEnabled(Feature.UseBigDecimal));
                jSONLexer.nextToken();
                return number;
            }
            case 4: {
                String string = jSONLexer.stringVal();
                jSONLexer.nextToken(16);
                if (jSONLexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                    try (JSONScanner jSONScanner = new JSONScanner(string);){
                        if (jSONScanner.scanISO8601DateIfMatch()) {
                            Date date = jSONScanner.getCalendar().getTime();
                            return date;
                        }
                    }
                }
                return string;
            }
            case 8: {
                jSONLexer.nextToken();
                return null;
            }
            case 23: {
                jSONLexer.nextToken();
                return null;
            }
            case 6: {
                jSONLexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                jSONLexer.nextToken();
                return Boolean.FALSE;
            }
            case 9: {
                jSONLexer.nextToken(18);
                if (jSONLexer.token() != 18) {
                    throw new JSONException("syntax error");
                }
                jSONLexer.nextToken(10);
                this.accept(10);
                long l2 = jSONLexer.integerValue().longValue();
                this.accept(2);
                this.accept(11);
                return new Date(l2);
            }
            case 20: {
                if (jSONLexer.isBlankInput()) {
                    return null;
                }
                throw new JSONException("unterminated json string, " + jSONLexer.info());
            }
            case 26: {
                byte[] byArray = jSONLexer.bytesValue();
                jSONLexer.nextToken();
                return byArray;
            }
            case 18: {
                String string = jSONLexer.stringVal();
                if ("NaN".equals(string)) {
                    jSONLexer.nextToken();
                    return null;
                }
                throw new JSONException("syntax error, " + jSONLexer.info());
            }
        }
        throw new JSONException("syntax error, " + jSONLexer.info());
    }

    public void config(Feature feature, boolean bl) {
        this.lexer.config(feature, bl);
    }

    public boolean isEnabled(Feature feature) {
        return this.lexer.isEnabled(feature);
    }

    public JSONLexer getLexer() {
        return this.lexer;
    }

    public final void accept(int n2) {
        JSONLexer jSONLexer = this.lexer;
        if (jSONLexer.token() != n2) {
            throw new JSONException("syntax error, expect " + JSONToken.name(n2) + ", actual " + JSONToken.name(jSONLexer.token()));
        }
        jSONLexer.nextToken();
    }

    public final void accept(int n2, int n3) {
        JSONLexer jSONLexer = this.lexer;
        if (jSONLexer.token() == n2) {
            jSONLexer.nextToken(n3);
        } else {
            this.throwException(n2);
        }
    }

    public void throwException(int n2) {
        throw new JSONException("syntax error, expect " + JSONToken.name(n2) + ", actual " + JSONToken.name(this.lexer.token()));
    }

    @Override
    public void close() {
        try (JSONLexer jSONLexer = this.lexer;){
            if (jSONLexer.isEnabled(Feature.AutoCloseSource) && jSONLexer.token() != 20) {
                throw new JSONException("not close json text, token : " + JSONToken.name(jSONLexer.token()));
            }
        }
    }

    public Object resolveReference(String string) {
        if (this.contextArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.contextArray.length && i2 < this.contextArrayIndex; ++i2) {
            ParseContext parseContext = this.contextArray[i2];
            if (!parseContext.toString().equals(string)) continue;
            return parseContext.object;
        }
        return null;
    }

    public void handleResovleTask(Object object) {
        if (this.resolveTaskList == null) {
            return;
        }
        int n2 = this.resolveTaskList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            Object object3;
            ResolveTask resolveTask = this.resolveTaskList.get(i2);
            String string = resolveTask.referenceValue;
            Object object4 = null;
            if (resolveTask.ownerContext != null) {
                object4 = resolveTask.ownerContext.object;
            }
            if (string.startsWith("$")) {
                object3 = this.getObject(string);
                if (object3 == null) {
                    try {
                        object2 = JSONPath.compile(string);
                        if (((JSONPath)object2).isRef()) {
                            object3 = ((JSONPath)object2).eval(object);
                        }
                    }
                    catch (JSONPathException jSONPathException) {}
                }
            } else {
                object3 = resolveTask.context.object;
            }
            if ((object2 = resolveTask.fieldDeserializer) == null) continue;
            if (object3 != null && object3.getClass() == JSONObject.class && ((FieldDeserializer)object2).fieldInfo != null && !Map.class.isAssignableFrom(((FieldDeserializer)object2).fieldInfo.fieldClass)) {
                Object object5 = this.contextArray[0].object;
                JSONPath jSONPath = JSONPath.compile(string);
                if (jSONPath.isRef()) {
                    object3 = jSONPath.eval(object5);
                }
            }
            ((FieldDeserializer)object2).setValue(object4, object3);
        }
    }

    public void parseExtra(Object object, String string) {
        Iterator<ExtraProcessor> iterator;
        Object object2;
        JSONLexer jSONLexer = this.lexer;
        jSONLexer.nextTokenWithColon();
        Type type = null;
        if (this.extraTypeProviders != null) {
            object2 = this.extraTypeProviders.iterator();
            while (object2.hasNext()) {
                iterator = (ExtraTypeProvider)object2.next();
                type = iterator.getExtraType(object, string);
            }
        }
        Object object3 = object2 = type == null ? this.parse() : this.parseObject(type);
        if (object instanceof ExtraProcessable) {
            iterator = (ExtraProcessable)object;
            iterator.processExtra(string, object2);
            return;
        }
        if (this.extraProcessors != null) {
            for (ExtraProcessor extraProcessor : this.extraProcessors) {
                extraProcessor.processExtra(object, string, object2);
            }
        }
        if (this.resolveStatus == 1) {
            this.resolveStatus = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object parse(PropertyProcessable propertyProcessable, Object object) {
        if (this.lexer.token() != 12) {
            String string = "syntax error, expect {, actual " + this.lexer.tokenName();
            if (object instanceof String) {
                string = string + ", fieldName ";
                string = string + object;
            }
            string = string + ", ";
            string = string + this.lexer.info();
            JSONArray jSONArray = new JSONArray();
            this.parseArray(jSONArray, object);
            if (jSONArray.size() != 1) throw new JSONException(string);
            Object object2 = jSONArray.get(0);
            if (!(object2 instanceof JSONObject)) throw new JSONException(string);
            return (JSONObject)object2;
        }
        ParseContext parseContext = this.context;
        try {
            int n2 = 0;
            while (true) {
                block33: {
                    Class<?> clazz;
                    Object object3;
                    String string;
                    this.lexer.skipWhitespace();
                    char c2 = this.lexer.getCurrent();
                    if (this.lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                        while (c2 == ',') {
                            this.lexer.next();
                            this.lexer.skipWhitespace();
                            c2 = this.lexer.getCurrent();
                        }
                    }
                    if (c2 == '\"') {
                        string = this.lexer.scanSymbol(this.symbolTable, '\"');
                        this.lexer.skipWhitespace();
                        c2 = this.lexer.getCurrent();
                        if (c2 != ':') {
                            throw new JSONException("expect ':' at " + this.lexer.pos());
                        }
                    } else {
                        if (c2 == '}') {
                            this.lexer.next();
                            this.lexer.resetStringPosition();
                            this.lexer.nextToken(16);
                            object3 = propertyProcessable;
                            return object3;
                        }
                        if (c2 == '\'') {
                            if (!this.lexer.isEnabled(Feature.AllowSingleQuotes)) {
                                throw new JSONException("syntax error");
                            }
                            string = this.lexer.scanSymbol(this.symbolTable, '\'');
                            this.lexer.skipWhitespace();
                            c2 = this.lexer.getCurrent();
                            if (c2 != ':') {
                                throw new JSONException("expect ':' at " + this.lexer.pos());
                            }
                        } else {
                            if (!this.lexer.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                                throw new JSONException("syntax error");
                            }
                            string = this.lexer.scanSymbolUnQuoted(this.symbolTable);
                            this.lexer.skipWhitespace();
                            c2 = this.lexer.getCurrent();
                            if (c2 != ':') {
                                throw new JSONException("expect ':' at " + this.lexer.pos() + ", actual " + c2);
                            }
                        }
                    }
                    this.lexer.next();
                    this.lexer.skipWhitespace();
                    c2 = this.lexer.getCurrent();
                    this.lexer.resetStringPosition();
                    if (string == JSON.DEFAULT_TYPE_KEY && !this.lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                        object3 = this.lexer.scanSymbol(this.symbolTable, '\"');
                        clazz = this.config.checkAutoType((String)object3, null, this.lexer.getFeatures());
                        if (Map.class.isAssignableFrom(clazz)) {
                            this.lexer.nextToken(16);
                            if (this.lexer.token() == 13) {
                                this.lexer.nextToken(16);
                                PropertyProcessable propertyProcessable2 = propertyProcessable;
                                return propertyProcessable2;
                            }
                            break block33;
                        } else {
                            ObjectDeserializer objectDeserializer = this.config.getDeserializer(clazz);
                            this.lexer.nextToken(16);
                            this.setResolveStatus(2);
                            if (parseContext != null && !(object instanceof Integer)) {
                                this.popContext();
                            }
                            Map map = (Map)objectDeserializer.deserialze(this, clazz, object);
                            return map;
                        }
                    }
                    this.lexer.nextToken();
                    if (n2 != 0) {
                        this.setContext(parseContext);
                    }
                    clazz = propertyProcessable.getType(string);
                    if (this.lexer.token() == 8) {
                        object3 = null;
                        this.lexer.nextToken();
                    } else {
                        object3 = this.parseObject(clazz, (Object)string);
                    }
                    propertyProcessable.apply(string, object3);
                    this.setContext(parseContext, object3, string);
                    this.setContext(parseContext);
                    int n3 = this.lexer.token();
                    if (n3 == 20 || n3 == 15) {
                        PropertyProcessable propertyProcessable3 = propertyProcessable;
                        return propertyProcessable3;
                    }
                    if (n3 == 13) {
                        this.lexer.nextToken();
                        PropertyProcessable propertyProcessable4 = propertyProcessable;
                        return propertyProcessable4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.setContext(parseContext);
        }
    }

    static {
        Class[] classArray;
        primitiveClasses = new HashSet();
        for (Class clazz : classArray = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, String.class}) {
            primitiveClasses.add(clazz);
        }
    }

    public static class ResolveTask {
        public final ParseContext context;
        public final String referenceValue;
        public FieldDeserializer fieldDeserializer;
        public ParseContext ownerContext;

        public ResolveTask(ParseContext parseContext, String string) {
            this.context = parseContext;
            this.referenceValue = string;
        }
    }
}

