/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.ParseContext;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;

public class AwtCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final AwtCodec instance = new AwtCodec();

    public static boolean support(Class<?> clazz) {
        return clazz == Point.class || clazz == Rectangle.class || clazz == Font.class || clazz == Color.class;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
            return;
        }
        char c2 = '{';
        if (object instanceof Point) {
            Point point = (Point)object;
            c2 = this.writeClassName(serializeWriter, Point.class, c2);
            serializeWriter.writeFieldValue(c2, "x", point.x);
            serializeWriter.writeFieldValue(',', "y", point.y);
        } else if (object instanceof Font) {
            Font font = (Font)object;
            c2 = this.writeClassName(serializeWriter, Font.class, c2);
            serializeWriter.writeFieldValue(c2, "name", font.getName());
            serializeWriter.writeFieldValue(',', "style", font.getStyle());
            serializeWriter.writeFieldValue(',', "size", font.getSize());
        } else if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            c2 = this.writeClassName(serializeWriter, Rectangle.class, c2);
            serializeWriter.writeFieldValue(c2, "x", rectangle.x);
            serializeWriter.writeFieldValue(',', "y", rectangle.y);
            serializeWriter.writeFieldValue(',', "width", rectangle.width);
            serializeWriter.writeFieldValue(',', "height", rectangle.height);
        } else if (object instanceof Color) {
            Color color = (Color)object;
            c2 = this.writeClassName(serializeWriter, Color.class, c2);
            serializeWriter.writeFieldValue(c2, "r", color.getRed());
            serializeWriter.writeFieldValue(',', "g", color.getGreen());
            serializeWriter.writeFieldValue(',', "b", color.getBlue());
            if (color.getAlpha() > 0) {
                serializeWriter.writeFieldValue(',', "alpha", color.getAlpha());
            }
        } else {
            throw new JSONException("not support awt class : " + object.getClass().getName());
        }
        serializeWriter.write(125);
    }

    protected char writeClassName(SerializeWriter serializeWriter, Class<?> clazz, char c2) {
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName)) {
            serializeWriter.write(123);
            serializeWriter.writeFieldName(JSON.DEFAULT_TYPE_KEY);
            serializeWriter.writeString(clazz.getName());
            c2 = (char)44;
        }
        return c2;
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Serializable serializable;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 8) {
            jSONLexer.nextToken(16);
            return null;
        }
        if (jSONLexer.token() != 12 && jSONLexer.token() != 16) {
            throw new JSONException("syntax error");
        }
        jSONLexer.nextToken();
        if (type == Point.class) {
            serializable = this.parsePoint(defaultJSONParser, object);
        } else if (type == Rectangle.class) {
            serializable = this.parseRectangle(defaultJSONParser);
        } else if (type == Color.class) {
            serializable = this.parseColor(defaultJSONParser);
        } else if (type == Font.class) {
            serializable = this.parseFont(defaultJSONParser);
        } else {
            throw new JSONException("not support awt class : " + type);
        }
        ParseContext parseContext = defaultJSONParser.getContext();
        defaultJSONParser.setContext(serializable, object);
        defaultJSONParser.setContext(parseContext);
        return (T)serializable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Font parseFont(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        while (true) {
            if (jSONLexer.token() == 13) break;
            if (jSONLexer.token() != 4) {
                throw new JSONException("syntax error");
            }
            String string2 = jSONLexer.stringVal();
            jSONLexer.nextTokenWithColon(2);
            if (string2.equalsIgnoreCase("name")) {
                if (jSONLexer.token() != 4) throw new JSONException("syntax error");
                string = jSONLexer.stringVal();
                jSONLexer.nextToken();
            } else if (string2.equalsIgnoreCase("style")) {
                if (jSONLexer.token() != 2) throw new JSONException("syntax error");
                n3 = jSONLexer.intValue();
                jSONLexer.nextToken();
            } else {
                if (!string2.equalsIgnoreCase("size")) throw new JSONException("syntax error, " + string2);
                if (jSONLexer.token() != 2) throw new JSONException("syntax error");
                n2 = jSONLexer.intValue();
                jSONLexer.nextToken();
            }
            if (jSONLexer.token() != 16) continue;
            jSONLexer.nextToken(4);
        }
        jSONLexer.nextToken();
        return new Font(string, n3, n2);
    }

    protected Color parseColor(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (jSONLexer.token() == 13) break;
            if (jSONLexer.token() != 4) {
                throw new JSONException("syntax error");
            }
            String string = jSONLexer.stringVal();
            jSONLexer.nextTokenWithColon(2);
            if (jSONLexer.token() != 2) {
                throw new JSONException("syntax error");
            }
            int n6 = jSONLexer.intValue();
            jSONLexer.nextToken();
            if (string.equalsIgnoreCase("r")) {
                n2 = n6;
            } else if (string.equalsIgnoreCase("g")) {
                n3 = n6;
            } else if (string.equalsIgnoreCase("b")) {
                n4 = n6;
            } else if (string.equalsIgnoreCase("alpha")) {
                n5 = n6;
            } else {
                throw new JSONException("syntax error, " + string);
            }
            if (jSONLexer.token() != 16) continue;
            jSONLexer.nextToken(4);
        }
        jSONLexer.nextToken();
        return new Color(n2, n3, n4, n5);
    }

    protected Rectangle parseRectangle(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6;
            if (jSONLexer.token() == 13) break;
            if (jSONLexer.token() != 4) {
                throw new JSONException("syntax error");
            }
            String string = jSONLexer.stringVal();
            jSONLexer.nextTokenWithColon(2);
            int n7 = jSONLexer.token();
            if (n7 == 2) {
                n6 = jSONLexer.intValue();
                jSONLexer.nextToken();
            } else if (n7 == 3) {
                n6 = (int)jSONLexer.floatValue();
                jSONLexer.nextToken();
            } else {
                throw new JSONException("syntax error");
            }
            if (string.equalsIgnoreCase("x")) {
                n2 = n6;
            } else if (string.equalsIgnoreCase("y")) {
                n3 = n6;
            } else if (string.equalsIgnoreCase("width")) {
                n4 = n6;
            } else if (string.equalsIgnoreCase("height")) {
                n5 = n6;
            } else {
                throw new JSONException("syntax error, " + string);
            }
            if (jSONLexer.token() != 16) continue;
            jSONLexer.nextToken(4);
        }
        jSONLexer.nextToken();
        return new Rectangle(n2, n3, n4, n5);
    }

    protected Point parsePoint(DefaultJSONParser defaultJSONParser, Object object) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            String string;
            if (jSONLexer.token() == 13) break;
            if (jSONLexer.token() == 4) {
                string = jSONLexer.stringVal();
                if (JSON.DEFAULT_TYPE_KEY.equals(string)) {
                    defaultJSONParser.acceptType("java.awt.Point");
                    continue;
                }
                if ("$ref".equals(string)) {
                    return (Point)this.parseRef(defaultJSONParser, object);
                }
            } else {
                throw new JSONException("syntax error");
            }
            jSONLexer.nextTokenWithColon(2);
            int n5 = jSONLexer.token();
            if (n5 == 2) {
                n4 = jSONLexer.intValue();
                jSONLexer.nextToken();
            } else if (n5 == 3) {
                n4 = (int)jSONLexer.floatValue();
                jSONLexer.nextToken();
            } else {
                throw new JSONException("syntax error : " + jSONLexer.tokenName());
            }
            if (string.equalsIgnoreCase("x")) {
                n2 = n4;
            } else if (string.equalsIgnoreCase("y")) {
                n3 = n4;
            } else {
                throw new JSONException("syntax error, " + string);
            }
            if (jSONLexer.token() != 16) continue;
            jSONLexer.nextToken(4);
        }
        jSONLexer.nextToken();
        return new Point(n2, n3);
    }

    private Object parseRef(DefaultJSONParser defaultJSONParser, Object object) {
        JSONLexer jSONLexer = defaultJSONParser.getLexer();
        jSONLexer.nextTokenWithColon(4);
        String string = jSONLexer.stringVal();
        defaultJSONParser.setContext(defaultJSONParser.getContext(), object);
        defaultJSONParser.addResolveTask(new DefaultJSONParser.ResolveTask(defaultJSONParser.getContext(), string));
        defaultJSONParser.popContext();
        defaultJSONParser.setResolveStatus(1);
        jSONLexer.nextToken(13);
        defaultJSONParser.accept(13);
        return null;
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

