/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ContextObjectDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.BeanContext;
import com.icbc.api.internal.util.fastjson.serializer.ContextObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.DateCodec;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class CalendarCodec
extends ContextObjectDeserializer
implements ObjectDeserializer,
ContextObjectSerializer,
ObjectSerializer {
    public static final CalendarCodec instance = new CalendarCodec();
    private DatatypeFactory dateFactory;

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, BeanContext beanContext) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        String string = beanContext.getFormat();
        Calendar calendar = (Calendar)object;
        if (string.equals("unixtime")) {
            long l2 = calendar.getTimeInMillis() / 1000L;
            serializeWriter.writeInt((int)l2);
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(JSON.DEFFAULT_DATE_FORMAT, jSONSerializer.locale);
        }
        simpleDateFormat.setTimeZone(jSONSerializer.timeZone);
        String string2 = simpleDateFormat.format(calendar.getTime());
        serializeWriter.writeString(string2);
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
            return;
        }
        Calendar calendar = object instanceof XMLGregorianCalendar ? ((XMLGregorianCalendar)object).toGregorianCalendar() : (Calendar)object;
        if (serializeWriter.isEnabled(SerializerFeature.UseISO8601DateFormat)) {
            char[] cArray;
            char c2 = serializeWriter.isEnabled(SerializerFeature.UseSingleQuotes) ? (char)'\'' : '\"';
            serializeWriter.append(c2);
            int n3 = calendar.get(1);
            int n4 = calendar.get(2) + 1;
            int n5 = calendar.get(5);
            int n6 = calendar.get(11);
            int n7 = calendar.get(12);
            int n8 = calendar.get(13);
            int n9 = calendar.get(14);
            if (n9 != 0) {
                cArray = "0000-00-00T00:00:00.000".toCharArray();
                IOUtils.getChars(n9, 23, cArray);
                IOUtils.getChars(n8, 19, cArray);
                IOUtils.getChars(n7, 16, cArray);
                IOUtils.getChars(n6, 13, cArray);
                IOUtils.getChars(n5, 10, cArray);
                IOUtils.getChars(n4, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            } else if (n8 == 0 && n7 == 0 && n6 == 0) {
                cArray = "0000-00-00".toCharArray();
                IOUtils.getChars(n5, 10, cArray);
                IOUtils.getChars(n4, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            } else {
                cArray = "0000-00-00T00:00:00".toCharArray();
                IOUtils.getChars(n8, 19, cArray);
                IOUtils.getChars(n7, 16, cArray);
                IOUtils.getChars(n6, 13, cArray);
                IOUtils.getChars(n5, 10, cArray);
                IOUtils.getChars(n4, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            }
            serializeWriter.write(cArray);
            float f2 = (float)calendar.getTimeZone().getOffset(calendar.getTimeInMillis()) / 3600000.0f;
            int n10 = (int)f2;
            if ((double)n10 == 0.0) {
                serializeWriter.write(90);
            } else {
                if (n10 > 9) {
                    serializeWriter.write(43);
                    serializeWriter.writeInt(n10);
                } else if (n10 > 0) {
                    serializeWriter.write(43);
                    serializeWriter.write(48);
                    serializeWriter.writeInt(n10);
                } else if (n10 < -9) {
                    serializeWriter.write(45);
                    serializeWriter.writeInt(n10);
                } else if (n10 < 0) {
                    serializeWriter.write(45);
                    serializeWriter.write(48);
                    serializeWriter.writeInt(-n10);
                }
                serializeWriter.write(58);
                int n11 = (int)((f2 - (float)n10) * 60.0f);
                serializeWriter.append(String.format("%02d", n11));
            }
            serializeWriter.append(c2);
        } else {
            Date date = calendar.getTime();
            jSONSerializer.write(date);
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        return this.deserialze(defaultJSONParser, type, object, null, 0);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object, String string, int n2) {
        Object t2 = DateCodec.instance.deserialze(defaultJSONParser, type, object, string, n2);
        if (t2 instanceof Calendar) {
            return t2;
        }
        Date date = (Date)t2;
        if (date == null) {
            return null;
        }
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        Calendar calendar = Calendar.getInstance(jSONLexer.getTimeZone(), jSONLexer.getLocale());
        calendar.setTime(date);
        if (type == XMLGregorianCalendar.class) {
            return (T)this.createXMLGregorianCalendar((GregorianCalendar)calendar);
        }
        return (T)calendar;
    }

    public XMLGregorianCalendar createXMLGregorianCalendar(Calendar calendar) {
        if (this.dateFactory == null) {
            try {
                this.dateFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalStateException("Could not obtain an instance of DatatypeFactory.", datatypeConfigurationException);
            }
        }
        return this.dateFactory.newXMLGregorianCalendar((GregorianCalendar)calendar);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

