/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FloatCodec
implements ObjectDeserializer,
ObjectSerializer {
    private NumberFormat decimalFormat;
    public static FloatCodec instance = new FloatCodec();

    public FloatCodec() {
    }

    public FloatCodec(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public FloatCodec(String string) {
        this(new DecimalFormat(string));
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        float f2 = ((Float)object).floatValue();
        if (this.decimalFormat != null) {
            String string = this.decimalFormat.format(f2);
            serializeWriter.write(string);
        } else {
            serializeWriter.writeFloat(f2, true);
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        try {
            return FloatCodec.deserialze(defaultJSONParser);
        }
        catch (Exception exception) {
            throw new JSONException("parseLong error, field : " + object, exception);
        }
    }

    public static <T> T deserialze(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            String string = jSONLexer.numberString();
            jSONLexer.nextToken(16);
            return (T)Float.valueOf(Float.parseFloat(string));
        }
        if (jSONLexer.token() == 3) {
            float f2 = jSONLexer.floatValue();
            jSONLexer.nextToken(16);
            return (T)Float.valueOf(f2);
        }
        Object object = defaultJSONParser.parse();
        if (object == null) {
            return null;
        }
        return (T)TypeUtils.castToFloat(object);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

