/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.AfterFilter;
import com.icbc.api.internal.util.fastjson.serializer.BeanContext;
import com.icbc.api.internal.util.fastjson.serializer.BeforeFilter;
import com.icbc.api.internal.util.fastjson.serializer.ContextValueFilter;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.LabelFilter;
import com.icbc.api.internal.util.fastjson.serializer.NameFilter;
import com.icbc.api.internal.util.fastjson.serializer.PropertyFilter;
import com.icbc.api.internal.util.fastjson.serializer.PropertyPreFilter;
import com.icbc.api.internal.util.fastjson.serializer.SerializeFilter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.serializer.ValueFilter;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SerializeFilterable {
    protected List<BeforeFilter> beforeFilters = null;
    protected List<AfterFilter> afterFilters = null;
    protected List<PropertyFilter> propertyFilters = null;
    protected List<ValueFilter> valueFilters = null;
    protected List<NameFilter> nameFilters = null;
    protected List<PropertyPreFilter> propertyPreFilters = null;
    protected List<LabelFilter> labelFilters = null;
    protected List<ContextValueFilter> contextValueFilters = null;
    protected boolean writeDirect = true;

    public List<BeforeFilter> getBeforeFilters() {
        if (this.beforeFilters == null) {
            this.beforeFilters = new ArrayList<BeforeFilter>();
            this.writeDirect = false;
        }
        return this.beforeFilters;
    }

    public List<AfterFilter> getAfterFilters() {
        if (this.afterFilters == null) {
            this.afterFilters = new ArrayList<AfterFilter>();
            this.writeDirect = false;
        }
        return this.afterFilters;
    }

    public List<NameFilter> getNameFilters() {
        if (this.nameFilters == null) {
            this.nameFilters = new ArrayList<NameFilter>();
            this.writeDirect = false;
        }
        return this.nameFilters;
    }

    public List<PropertyPreFilter> getPropertyPreFilters() {
        if (this.propertyPreFilters == null) {
            this.propertyPreFilters = new ArrayList<PropertyPreFilter>();
            this.writeDirect = false;
        }
        return this.propertyPreFilters;
    }

    public List<LabelFilter> getLabelFilters() {
        if (this.labelFilters == null) {
            this.labelFilters = new ArrayList<LabelFilter>();
            this.writeDirect = false;
        }
        return this.labelFilters;
    }

    public List<PropertyFilter> getPropertyFilters() {
        if (this.propertyFilters == null) {
            this.propertyFilters = new ArrayList<PropertyFilter>();
            this.writeDirect = false;
        }
        return this.propertyFilters;
    }

    public List<ContextValueFilter> getContextValueFilters() {
        if (this.contextValueFilters == null) {
            this.contextValueFilters = new ArrayList<ContextValueFilter>();
            this.writeDirect = false;
        }
        return this.contextValueFilters;
    }

    public List<ValueFilter> getValueFilters() {
        if (this.valueFilters == null) {
            this.valueFilters = new ArrayList<ValueFilter>();
            this.writeDirect = false;
        }
        return this.valueFilters;
    }

    public void addFilter(SerializeFilter serializeFilter) {
        if (serializeFilter == null) {
            return;
        }
        if (serializeFilter instanceof PropertyPreFilter) {
            this.getPropertyPreFilters().add((PropertyPreFilter)serializeFilter);
        }
        if (serializeFilter instanceof NameFilter) {
            this.getNameFilters().add((NameFilter)serializeFilter);
        }
        if (serializeFilter instanceof ValueFilter) {
            this.getValueFilters().add((ValueFilter)serializeFilter);
        }
        if (serializeFilter instanceof ContextValueFilter) {
            this.getContextValueFilters().add((ContextValueFilter)serializeFilter);
        }
        if (serializeFilter instanceof PropertyFilter) {
            this.getPropertyFilters().add((PropertyFilter)serializeFilter);
        }
        if (serializeFilter instanceof BeforeFilter) {
            this.getBeforeFilters().add((BeforeFilter)serializeFilter);
        }
        if (serializeFilter instanceof AfterFilter) {
            this.getAfterFilters().add((AfterFilter)serializeFilter);
        }
        if (serializeFilter instanceof LabelFilter) {
            this.getLabelFilters().add((LabelFilter)serializeFilter);
        }
    }

    public boolean applyName(JSONSerializer jSONSerializer, Object object, String string) {
        if (jSONSerializer.propertyPreFilters != null) {
            for (PropertyPreFilter propertyPreFilter : jSONSerializer.propertyPreFilters) {
                if (propertyPreFilter.apply(jSONSerializer, object, string)) continue;
                return false;
            }
        }
        if (this.propertyPreFilters != null) {
            for (PropertyPreFilter propertyPreFilter : this.propertyPreFilters) {
                if (propertyPreFilter.apply(jSONSerializer, object, string)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean apply(JSONSerializer jSONSerializer, Object object, String string, Object object2) {
        if (jSONSerializer.propertyFilters != null) {
            for (PropertyFilter propertyFilter : jSONSerializer.propertyFilters) {
                if (propertyFilter.apply(object, string, object2)) continue;
                return false;
            }
        }
        if (this.propertyFilters != null) {
            for (PropertyFilter propertyFilter : this.propertyFilters) {
                if (propertyFilter.apply(object, string, object2)) continue;
                return false;
            }
        }
        return true;
    }

    protected String processKey(JSONSerializer jSONSerializer, Object object, String string, Object object2) {
        if (jSONSerializer.nameFilters != null) {
            for (NameFilter nameFilter : jSONSerializer.nameFilters) {
                string = nameFilter.process(object, string, object2);
            }
        }
        if (this.nameFilters != null) {
            for (NameFilter nameFilter : this.nameFilters) {
                string = nameFilter.process(object, string, object2);
            }
        }
        return string;
    }

    protected Object processValue(JSONSerializer jSONSerializer, BeanContext beanContext, Object object, String string, Object object2) {
        return this.processValue(jSONSerializer, beanContext, object, string, object2, 0);
    }

    protected Object processValue(JSONSerializer jSONSerializer, BeanContext beanContext, Object object, String string, Object object2, int n2) {
        Iterator<Object> iterator;
        Object object3;
        if (object2 != null) {
            if ((SerializerFeature.isEnabled(jSONSerializer.out.features, n2, SerializerFeature.WriteNonStringValueAsString) || beanContext != null && (beanContext.getFeatures() & SerializerFeature.WriteNonStringValueAsString.mask) != 0) && (object2 instanceof Number || object2 instanceof Boolean)) {
                object3 = null;
                if (object2 instanceof Number && beanContext != null) {
                    object3 = beanContext.getFormat();
                }
                object2 = object3 != null ? new DecimalFormat((String)object3).format(object2) : object2.toString();
            } else if (beanContext != null && beanContext.isJsonDirect()) {
                object3 = (String)object2;
                object2 = JSON.parse((String)object3);
            }
        }
        if (jSONSerializer.valueFilters != null) {
            object3 = jSONSerializer.valueFilters.iterator();
            while (object3.hasNext()) {
                iterator = (ValueFilter)object3.next();
                object2 = iterator.process(object, string, object2);
            }
        }
        if ((object3 = this.valueFilters) != null) {
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                ValueFilter serializeFilter = (ValueFilter)iterator.next();
                object2 = serializeFilter.process(object, string, object2);
            }
        }
        if (jSONSerializer.contextValueFilters != null) {
            for (ContextValueFilter contextValueFilter : jSONSerializer.contextValueFilters) {
                object2 = contextValueFilter.process(beanContext, object, string, object2);
            }
        }
        if (this.contextValueFilters != null) {
            for (ContextValueFilter contextValueFilter : this.contextValueFilters) {
                object2 = contextValueFilter.process(beanContext, object, string, object2);
            }
        }
        return object2;
    }

    protected boolean writeDirect(JSONSerializer jSONSerializer) {
        return jSONSerializer.out.writeDirect && this.writeDirect && jSONSerializer.writeDirect;
    }
}

