/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.fastjson.util.RyuDouble;
import com.icbc.api.internal.util.fastjson.util.RyuFloat;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;

public final class SerializeWriter
extends Writer {
    private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
    private static final ThreadLocal<byte[]> bytesBufLocal = new ThreadLocal();
    private static final char[] VALUE_TRUE = ":true".toCharArray();
    private static final char[] VALUE_FALSE = ":false".toCharArray();
    private static int BUFFER_THRESHOLD = 131072;
    protected char[] buf;
    protected int count;
    protected int features;
    private final Writer writer;
    protected boolean useSingleQuotes;
    protected boolean quoteFieldNames;
    protected boolean sortField;
    protected boolean disableCircularReferenceDetect;
    protected boolean beanToArray;
    protected boolean writeNonStringValueAsString;
    protected boolean notWriteDefaultValue;
    protected boolean writeEnumUsingName;
    protected boolean writeEnumUsingToString;
    protected boolean writeDirect;
    protected char keySeperator;
    protected int maxBufSize = -1;
    protected boolean browserSecure;
    protected long sepcialBits;
    static final int nonDirectFeatures;

    public SerializeWriter() {
        this((Writer)null);
    }

    public SerializeWriter(Writer writer) {
        this(writer, JSON.DEFAULT_GENERATE_FEATURE, SerializerFeature.EMPTY);
    }

    public SerializeWriter(SerializerFeature ... serializerFeatureArray) {
        this((Writer)null, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, SerializerFeature ... serializerFeatureArray) {
        this(writer, 0, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, int n2, SerializerFeature ... serializerFeatureArray) {
        this.writer = writer;
        this.buf = bufLocal.get();
        if (this.buf != null) {
            bufLocal.set(null);
        } else {
            this.buf = new char[2048];
        }
        int n3 = n2;
        for (SerializerFeature serializerFeature : serializerFeatureArray) {
            n3 |= serializerFeature.getMask();
        }
        this.features = n3;
        this.computeFeatures();
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public void setMaxBufSize(int n2) {
        if (n2 < this.buf.length) {
            throw new JSONException("must > " + this.buf.length);
        }
        this.maxBufSize = n2;
    }

    public int getBufferLength() {
        return this.buf.length;
    }

    public SerializeWriter(int n2) {
        this(null, n2);
    }

    public SerializeWriter(Writer writer, int n2) {
        this.writer = writer;
        if (n2 <= 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.buf = new char[n2];
        this.computeFeatures();
    }

    public void config(SerializerFeature serializerFeature, boolean bl) {
        if (bl) {
            this.features |= serializerFeature.getMask();
            if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                this.features &= ~SerializerFeature.WriteEnumUsingName.getMask();
            } else if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                this.features &= ~SerializerFeature.WriteEnumUsingToString.getMask();
            }
        } else {
            this.features &= ~serializerFeature.getMask();
        }
        this.computeFeatures();
    }

    protected void computeFeatures() {
        this.quoteFieldNames = (this.features & SerializerFeature.QuoteFieldNames.mask) != 0;
        this.useSingleQuotes = (this.features & SerializerFeature.UseSingleQuotes.mask) != 0;
        this.sortField = (this.features & SerializerFeature.SortField.mask) != 0;
        this.disableCircularReferenceDetect = (this.features & SerializerFeature.DisableCircularReferenceDetect.mask) != 0;
        this.beanToArray = (this.features & SerializerFeature.BeanToArray.mask) != 0;
        this.writeNonStringValueAsString = (this.features & SerializerFeature.WriteNonStringValueAsString.mask) != 0;
        this.notWriteDefaultValue = (this.features & SerializerFeature.NotWriteDefaultValue.mask) != 0;
        this.writeEnumUsingName = (this.features & SerializerFeature.WriteEnumUsingName.mask) != 0;
        this.writeEnumUsingToString = (this.features & SerializerFeature.WriteEnumUsingToString.mask) != 0;
        this.writeDirect = this.quoteFieldNames && (this.features & nonDirectFeatures) == 0 && (this.beanToArray || this.writeEnumUsingName);
        this.keySeperator = (char)(this.useSingleQuotes ? 39 : 34);
        this.browserSecure = (this.features & SerializerFeature.BrowserSecure.mask) != 0;
        long l2 = 0x4FFFFFFFFL;
        long l3 = 140758963191807L;
        long l4 = 5764610843043954687L;
        this.sepcialBits = this.browserSecure ? 5764610843043954687L : ((this.features & SerializerFeature.WriteSlashAsSpecial.mask) != 0 ? 140758963191807L : 0x4FFFFFFFFL);
    }

    public boolean isSortField() {
        return this.sortField;
    }

    public boolean isNotWriteDefaultValue() {
        return this.notWriteDefaultValue;
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return (this.features & serializerFeature.mask) != 0;
    }

    public boolean isEnabled(int n2) {
        return (this.features & n2) != 0;
    }

    @Override
    public void write(int n2) {
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                this.flush();
                n3 = 1;
            }
        }
        this.buf[this.count] = (char)n2;
        this.count = n3;
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n4);
            } else {
                int n5;
                do {
                    n5 = this.buf.length - this.count;
                    System.arraycopy(cArray, n2, this.buf, this.count, n5);
                    this.count = this.buf.length;
                    this.flush();
                    n2 += n5;
                } while ((n3 -= n5) > this.buf.length);
                n4 = n3;
            }
        }
        System.arraycopy(cArray, n2, this.buf, this.count, n3);
        this.count = n4;
    }

    public void expandCapacity(int n2) {
        char[] cArray;
        if (this.maxBufSize != -1 && n2 >= this.maxBufSize) {
            throw new JSONException("serialize exceeded MAX_OUTPUT_LENGTH=" + this.maxBufSize + ", minimumCapacity=" + n2);
        }
        int n3 = this.buf.length + (this.buf.length >> 1) + 1;
        if (n3 < n2) {
            n3 = n2;
        }
        char[] cArray2 = new char[n3];
        System.arraycopy(this.buf, 0, cArray2, 0, this.count);
        if (this.buf.length < BUFFER_THRESHOLD && ((cArray = bufLocal.get()) == null || cArray.length < this.buf.length)) {
            bufLocal.set(this.buf);
        }
        this.buf = cArray2;
    }

    @Override
    public SerializeWriter append(CharSequence charSequence) {
        String string = charSequence == null ? "null" : charSequence.toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public SerializeWriter append(CharSequence charSequence, int n2, int n3) {
        String string = (charSequence == null ? "null" : charSequence).subSequence(n2, n3).toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public SerializeWriter append(char c2) {
        this.write(c2);
        return this;
    }

    @Override
    public void write(String string, int n2, int n3) {
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n4);
            } else {
                int n5;
                do {
                    n5 = this.buf.length - this.count;
                    string.getChars(n2, n2 + n5, this.buf, this.count);
                    this.count = this.buf.length;
                    this.flush();
                    n2 += n5;
                } while ((n3 -= n5) > this.buf.length);
                n4 = n3;
            }
        }
        string.getChars(n2, n2 + n3, this.buf, this.count);
        this.count = n4;
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        writer.write(this.buf, 0, this.count);
    }

    public void writeTo(OutputStream outputStream, String string) throws IOException {
        this.writeTo(outputStream, Charset.forName(string));
    }

    public void writeTo(OutputStream outputStream, Charset charset) throws IOException {
        this.writeToEx(outputStream, charset);
    }

    public int writeToEx(OutputStream outputStream, Charset charset) throws IOException {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (charset == IOUtils.UTF8) {
            return this.encodeToUTF8(outputStream);
        }
        byte[] byArray = new String(this.buf, 0, this.count).getBytes(charset);
        outputStream.write(byArray);
        return byArray.length;
    }

    public char[] toCharArray() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] cArray = new char[this.count];
        System.arraycopy(this.buf, 0, cArray, 0, this.count);
        return cArray;
    }

    public char[] toCharArrayForSpringWebSocket() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] cArray = new char[this.count - 2];
        System.arraycopy(this.buf, 1, cArray, 0, this.count - 2);
        return cArray;
    }

    public byte[] toBytes(String string) {
        return this.toBytes(string == null || "UTF-8".equals(string) ? IOUtils.UTF8 : Charset.forName(string));
    }

    public byte[] toBytes(Charset charset) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (charset == IOUtils.UTF8) {
            return this.encodeToUTF8Bytes();
        }
        return new String(this.buf, 0, this.count).getBytes(charset);
    }

    private int encodeToUTF8(OutputStream outputStream) throws IOException {
        int n2 = (int)((double)this.count * 3.0);
        byte[] byArray = bytesBufLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            bytesBufLocal.set(byArray);
        }
        byte[] byArray2 = byArray;
        if (byArray.length < n2) {
            byArray = new byte[n2];
        }
        int n3 = IOUtils.encodeUTF8(this.buf, 0, this.count, byArray);
        outputStream.write(byArray, 0, n3);
        if (byArray != byArray2 && byArray.length <= BUFFER_THRESHOLD) {
            bytesBufLocal.set(byArray);
        }
        return n3;
    }

    private byte[] encodeToUTF8Bytes() {
        int n2 = (int)((double)this.count * 3.0);
        byte[] byArray = bytesBufLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            bytesBufLocal.set(byArray);
        }
        byte[] byArray2 = byArray;
        if (byArray.length < n2) {
            byArray = new byte[n2];
        }
        int n3 = IOUtils.encodeUTF8(this.buf, 0, this.count, byArray);
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        if (byArray != byArray2 && byArray.length <= BUFFER_THRESHOLD) {
            bytesBufLocal.set(byArray);
        }
        return byArray3;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void close() {
        if (this.writer != null && this.count > 0) {
            this.flush();
        }
        if (this.buf.length <= BUFFER_THRESHOLD) {
            bufLocal.set(this.buf);
        }
        this.buf = null;
    }

    @Override
    public void write(String string) {
        if (string == null) {
            this.writeNull();
            return;
        }
        this.write(string, 0, string.length());
    }

    public void writeInt(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int n3 = n2 < 0 ? IOUtils.stringSize(-n2) + 1 : IOUtils.stringSize(n2);
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n4);
            } else {
                char[] cArray = new char[n3];
                IOUtils.getChars(n2, n3, cArray);
                this.write(cArray, 0, cArray.length);
                return;
            }
        }
        IOUtils.getChars(n2, n4, this.buf);
        this.count = n4;
    }

    public void writeByteArray(byte[] byArray) {
        int n2;
        if (this.isEnabled(SerializerFeature.WriteClassName.mask)) {
            this.writeHex(byArray);
            return;
        }
        int n3 = byArray.length;
        int n4 = n2 = this.useSingleQuotes ? 39 : 34;
        if (n3 == 0) {
            String string = this.useSingleQuotes ? "''" : "\"\"";
            this.write(string);
            return;
        }
        char[] cArray = IOUtils.CA;
        int n5 = n3 / 3 * 3;
        int n6 = (n3 - 1) / 3 + 1 << 2;
        int n7 = this.count;
        int n8 = this.count + n6 + 2;
        if (n8 > this.buf.length) {
            if (this.writer != null) {
                int n9;
                this.write(n2);
                int n10 = 0;
                while (n10 < n5) {
                    n9 = (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF;
                    this.write(cArray[n9 >>> 18 & 0x3F]);
                    this.write(cArray[n9 >>> 12 & 0x3F]);
                    this.write(cArray[n9 >>> 6 & 0x3F]);
                    this.write(cArray[n9 & 0x3F]);
                }
                n10 = n3 - n5;
                if (n10 > 0) {
                    n9 = (byArray[n5] & 0xFF) << 10 | (n10 == 2 ? (byArray[n3 - 1] & 0xFF) << 2 : 0);
                    this.write(cArray[n9 >> 12]);
                    this.write(cArray[n9 >>> 6 & 0x3F]);
                    this.write(n10 == 2 ? cArray[n9 & 0x3F] : 61);
                    this.write(61);
                }
                this.write(n2);
                return;
            }
            this.expandCapacity(n8);
        }
        this.count = n8;
        this.buf[n7++] = n2;
        int n11 = 0;
        int n12 = n7;
        while (n11 < n5) {
            int n13 = (byArray[n11++] & 0xFF) << 16 | (byArray[n11++] & 0xFF) << 8 | byArray[n11++] & 0xFF;
            this.buf[n12++] = cArray[n13 >>> 18 & 0x3F];
            this.buf[n12++] = cArray[n13 >>> 12 & 0x3F];
            this.buf[n12++] = cArray[n13 >>> 6 & 0x3F];
            this.buf[n12++] = cArray[n13 & 0x3F];
        }
        n11 = n3 - n5;
        if (n11 > 0) {
            n12 = (byArray[n5] & 0xFF) << 10 | (n11 == 2 ? (byArray[n3 - 1] & 0xFF) << 2 : 0);
            this.buf[n8 - 5] = cArray[n12 >> 12];
            this.buf[n8 - 4] = cArray[n12 >>> 6 & 0x3F];
            this.buf[n8 - 3] = n11 == 2 ? cArray[n12 & 0x3F] : 61;
            this.buf[n8 - 2] = 61;
        }
        this.buf[n8 - 1] = n2;
    }

    public void writeHex(byte[] byArray) {
        int n2 = this.count + byArray.length * 2 + 3;
        if (n2 > this.buf.length) {
            this.expandCapacity(n2);
        }
        this.buf[this.count++] = 120;
        this.buf[this.count++] = 39;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            int n3 = by & 0xFF;
            int n4 = n3 >> 4;
            int n5 = n3 & 0xF;
            this.buf[this.count++] = (char)(n4 + (n4 < 10 ? 48 : 55));
            this.buf[this.count++] = (char)(n5 + (n5 < 10 ? 48 : 55));
        }
        this.buf[this.count++] = 39;
    }

    public void writeFloat(float f2, boolean bl) {
        if (f2 != f2 || f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
            this.writeNull();
        } else {
            int n2 = this.count + 15;
            if (n2 > this.buf.length) {
                if (this.writer == null) {
                    this.expandCapacity(n2);
                } else {
                    String string = RyuFloat.toString(f2);
                    this.write(string, 0, string.length());
                    if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                        this.write(70);
                    }
                    return;
                }
            }
            int n3 = RyuFloat.toString(f2, this.buf, this.count);
            this.count += n3;
            if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                this.write(70);
            }
        }
    }

    public void writeDouble(double d2, boolean bl) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            this.writeNull();
            return;
        }
        int n2 = this.count + 24;
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                String string = RyuDouble.toString(d2);
                this.write(string, 0, string.length());
                if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                    this.write(68);
                }
                return;
            }
        }
        int n3 = RyuDouble.toString(d2, this.buf, this.count);
        this.count += n3;
        if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
            this.write(68);
        }
    }

    public void writeEnum(Enum<?> enum_) {
        if (enum_ == null) {
            this.writeNull();
            return;
        }
        String string = null;
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            string = enum_.name();
        } else if (this.writeEnumUsingToString) {
            string = enum_.toString();
        }
        if (string != null) {
            int n2 = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            this.write(n2);
            this.write(string);
            this.write(n2);
        } else {
            this.writeInt(enum_.ordinal());
        }
    }

    public void writeLongAndChar(long l2, char c2) throws IOException {
        this.writeLong(l2);
        this.write(c2);
    }

    public void writeLong(long l2) {
        boolean bl;
        boolean bl2 = bl = this.isEnabled(SerializerFeature.BrowserCompatible) && !this.isEnabled(SerializerFeature.WriteClassName) && (l2 > 0x1FFFFFFFFFFFFFL || l2 < -9007199254740991L);
        if (l2 == Long.MIN_VALUE) {
            if (bl) {
                this.write("\"-9223372036854775808\"");
            } else {
                this.write("-9223372036854775808");
            }
            return;
        }
        int n2 = l2 < 0L ? IOUtils.stringSize(-l2) + 1 : IOUtils.stringSize(l2);
        int n3 = this.count + n2;
        if (bl) {
            n3 += 2;
        }
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                char[] cArray = new char[n2];
                IOUtils.getChars(l2, n2, cArray);
                if (bl) {
                    this.write(34);
                    this.write(cArray, 0, cArray.length);
                    this.write(34);
                } else {
                    this.write(cArray, 0, cArray.length);
                }
                return;
            }
        }
        if (bl) {
            this.buf[this.count] = 34;
            IOUtils.getChars(l2, n3 - 1, this.buf);
            this.buf[n3 - 1] = 34;
        } else {
            IOUtils.getChars(l2, n3, this.buf);
        }
        this.count = n3;
    }

    public void writeNull() {
        this.write("null");
    }

    public void writeNull(SerializerFeature serializerFeature) {
        this.writeNull(0, serializerFeature.mask);
    }

    public void writeNull(int n2, int n3) {
        if ((n2 & n3) == 0 && (this.features & n3) == 0) {
            this.writeNull();
            return;
        }
        if ((n2 & SerializerFeature.WriteMapNullValue.mask) != 0 && (n2 & ~SerializerFeature.WriteMapNullValue.mask & SerializerFeature.WRITE_MAP_NULL_FEATURES) == 0) {
            this.writeNull();
            return;
        }
        if (n3 == SerializerFeature.WriteNullListAsEmpty.mask) {
            this.write("[]");
        } else if (n3 == SerializerFeature.WriteNullStringAsEmpty.mask) {
            this.writeString("");
        } else if (n3 == SerializerFeature.WriteNullBooleanAsFalse.mask) {
            this.write("false");
        } else if (n3 == SerializerFeature.WriteNullNumberAsZero.mask) {
            this.write(48);
        } else {
            this.writeNull();
        }
    }

    public void writeStringWithDoubleQuote(String string, char c2) {
        int n2;
        int n3;
        int n4;
        if (string == null) {
            this.writeNull();
            if (c2 != '\u0000') {
                this.write(c2);
            }
            return;
        }
        int n5 = string.length();
        int n6 = this.count + n5 + 2;
        if (c2 != '\u0000') {
            ++n6;
        }
        if (n6 > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c3 = string.charAt(i2);
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (c3 == '(' || c3 == ')' || c3 == '<' || c3 == '>')) {
                        this.write(92);
                        this.write(117);
                        this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 & 0xF]);
                        continue;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t' || c3 == '\"' || c3 == '/' || c3 == '\\') {
                            this.write(92);
                            this.write(IOUtils.replaceChars[c3]);
                            continue;
                        }
                        if (c3 < ' ') {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(IOUtils.ASCII_CHARS[c3 * 2]);
                            this.write(IOUtils.ASCII_CHARS[c3 * 2 + 1]);
                            continue;
                        }
                        if (c3 >= '\u007f') {
                            this.write(92);
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                    } else if (c3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c3] != 0 || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        if (IOUtils.specicalFlags_doubleQuotes[c3] == 4) {
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(34);
                if (c2 != '\u0000') {
                    this.write(c2);
                }
                return;
            }
            this.expandCapacity(n6);
        }
        int n7 = this.count + 1;
        int n8 = n7 + n5;
        this.buf[this.count] = 34;
        string.getChars(0, n5, this.buf, n7);
        this.count = n6;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char c4;
            int n9;
            int n10 = -1;
            for (n9 = n7; n9 < n8; ++n9) {
                c4 = this.buf[n9];
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    n10 = n9;
                    ++n6;
                    continue;
                }
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    n10 = n9;
                    ++n6;
                    continue;
                }
                if (c4 < ' ') {
                    n10 = n9;
                    n6 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                n10 = n9;
                n6 += 5;
            }
            if (n6 > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            for (n9 = n10; n9 >= n7; --n9) {
                c4 = this.buf[n9];
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = IOUtils.replaceChars[c4];
                    ++n8;
                    continue;
                }
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = c4;
                    ++n8;
                    continue;
                }
                if (c4 < ' ') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 6, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = 117;
                    this.buf[n9 + 2] = 48;
                    this.buf[n9 + 3] = 48;
                    this.buf[n9 + 4] = IOUtils.ASCII_CHARS[c4 * 2];
                    this.buf[n9 + 5] = IOUtils.ASCII_CHARS[c4 * 2 + 1];
                    n8 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 6, n8 - n9 - 1);
                this.buf[n9] = 92;
                this.buf[n9 + 1] = 117;
                this.buf[n9 + 2] = IOUtils.DIGITS[c4 >>> 12 & 0xF];
                this.buf[n9 + 3] = IOUtils.DIGITS[c4 >>> 8 & 0xF];
                this.buf[n9 + 4] = IOUtils.DIGITS[c4 >>> 4 & 0xF];
                this.buf[n9 + 5] = IOUtils.DIGITS[c4 & 0xF];
                n8 += 5;
            }
            if (c2 != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = c2;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        int n11 = 0;
        int n12 = -1;
        int n13 = -1;
        int n14 = 0;
        for (n4 = n7; n4 < n8; ++n4) {
            n3 = this.buf[n4];
            if (n3 >= 93) {
                if (n3 < 127 || n3 != 8232 && n3 != 8233 && n3 >= 160) continue;
                if (n13 == -1) {
                    n13 = n4;
                }
                ++n11;
                n12 = n4;
                n14 = n3;
                n6 += 4;
                continue;
            }
            int n15 = n2 = n3 < 64 && (this.sepcialBits & 1L << n3) != 0L || n3 == 92 ? 1 : 0;
            if (n2 == 0) continue;
            ++n11;
            n12 = n4;
            n14 = n3;
            if (n3 == 40 || n3 == 41 || n3 == 60 || n3 == 62 || n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                n6 += 4;
            }
            if (n13 != -1) continue;
            n13 = n4;
        }
        if (n11 > 0) {
            if ((n6 += n11) > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            if (n11 == 1) {
                if (n14 == 8232) {
                    n4 = n12 + 1;
                    n3 = n12 + 6;
                    n2 = n8 - n12 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n12] = 92;
                    this.buf[++n12] = 117;
                    this.buf[++n12] = 50;
                    this.buf[++n12] = 48;
                    this.buf[++n12] = 50;
                    this.buf[++n12] = 56;
                } else if (n14 == 8233) {
                    n4 = n12 + 1;
                    n3 = n12 + 6;
                    n2 = n8 - n12 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n12] = 92;
                    this.buf[++n12] = 117;
                    this.buf[++n12] = 50;
                    this.buf[++n12] = 48;
                    this.buf[++n12] = 50;
                    this.buf[++n12] = 57;
                } else if (n14 == 40 || n14 == 41 || n14 == 60 || n14 == 62) {
                    n4 = n12 + 1;
                    n3 = n12 + 6;
                    n2 = n8 - n12 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n12] = 92;
                    this.buf[++n12] = 117;
                    int n16 = n14;
                    this.buf[++n12] = IOUtils.DIGITS[n16 >>> 12 & 0xF];
                    this.buf[++n12] = IOUtils.DIGITS[n16 >>> 8 & 0xF];
                    this.buf[++n12] = IOUtils.DIGITS[n16 >>> 4 & 0xF];
                    this.buf[++n12] = IOUtils.DIGITS[n16 & 0xF];
                } else {
                    n4 = n14;
                    if (n4 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n4] == 4) {
                        n3 = n12 + 1;
                        n2 = n12 + 6;
                        int n17 = n8 - n12 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n17);
                        int n18 = n12;
                        this.buf[n18++] = 92;
                        this.buf[n18++] = 117;
                        this.buf[n18++] = IOUtils.DIGITS[n4 >>> 12 & 0xF];
                        this.buf[n18++] = IOUtils.DIGITS[n4 >>> 8 & 0xF];
                        this.buf[n18++] = IOUtils.DIGITS[n4 >>> 4 & 0xF];
                        this.buf[n18++] = IOUtils.DIGITS[n4 & 0xF];
                    } else {
                        n3 = n12 + 1;
                        n2 = n12 + 2;
                        int n19 = n8 - n12 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n19);
                        this.buf[n12] = 92;
                        this.buf[++n12] = IOUtils.replaceChars[n4];
                    }
                }
            } else if (n11 > 1) {
                n4 = n13 - n7;
                n3 = n13;
                for (n2 = n4; n2 < string.length(); ++n2) {
                    char c5 = string.charAt(n2);
                    if (this.browserSecure && (c5 == '(' || c5 == ')' || c5 == '<' || c5 == '>')) {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 & 0xF];
                        n8 += 5;
                        continue;
                    }
                    if (c5 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c5] != 0 || c5 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n3++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[c5] == 4) {
                            this.buf[n3++] = 117;
                            this.buf[n3++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c5 & 0xF];
                            n8 += 5;
                            continue;
                        }
                        this.buf[n3++] = IOUtils.replaceChars[c5];
                        ++n8;
                        continue;
                    }
                    if (c5 == '\u2028' || c5 == '\u2029') {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 & 0xF];
                        n8 += 5;
                        continue;
                    }
                    this.buf[n3++] = c5;
                }
            }
        }
        if (c2 != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = c2;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    public void writeStringWithDoubleQuote(char[] cArray, char c2) {
        int n2;
        int n3;
        int n4;
        if (cArray == null) {
            this.writeNull();
            if (c2 != '\u0000') {
                this.write(c2);
            }
            return;
        }
        int n5 = cArray.length;
        int n6 = this.count + n5 + 2;
        if (c2 != '\u0000') {
            ++n6;
        }
        if (n6 > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    char c3 = cArray[i2];
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (c3 == '(' || c3 == ')' || c3 == '<' || c3 == '>')) {
                        this.write(92);
                        this.write(117);
                        this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 & 0xF]);
                        continue;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t' || c3 == '\"' || c3 == '/' || c3 == '\\') {
                            this.write(92);
                            this.write(IOUtils.replaceChars[c3]);
                            continue;
                        }
                        if (c3 < ' ') {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(IOUtils.ASCII_CHARS[c3 * 2]);
                            this.write(IOUtils.ASCII_CHARS[c3 * 2 + 1]);
                            continue;
                        }
                        if (c3 >= '\u007f') {
                            this.write(92);
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                    } else if (c3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c3] != 0 || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        if (IOUtils.specicalFlags_doubleQuotes[c3] == 4) {
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(34);
                if (c2 != '\u0000') {
                    this.write(c2);
                }
                return;
            }
            this.expandCapacity(n6);
        }
        int n7 = this.count + 1;
        int n8 = n7 + n5;
        this.buf[this.count] = 34;
        System.arraycopy(cArray, 0, this.buf, n7, cArray.length);
        this.count = n6;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char c4;
            int n9;
            int n10 = -1;
            for (n9 = n7; n9 < n8; ++n9) {
                c4 = this.buf[n9];
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    n10 = n9;
                    ++n6;
                    continue;
                }
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    n10 = n9;
                    ++n6;
                    continue;
                }
                if (c4 < ' ') {
                    n10 = n9;
                    n6 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                n10 = n9;
                n6 += 5;
            }
            if (n6 > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            for (n9 = n10; n9 >= n7; --n9) {
                c4 = this.buf[n9];
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = IOUtils.replaceChars[c4];
                    ++n8;
                    continue;
                }
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = c4;
                    ++n8;
                    continue;
                }
                if (c4 < ' ') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 6, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = 117;
                    this.buf[n9 + 2] = 48;
                    this.buf[n9 + 3] = 48;
                    this.buf[n9 + 4] = IOUtils.ASCII_CHARS[c4 * 2];
                    this.buf[n9 + 5] = IOUtils.ASCII_CHARS[c4 * 2 + 1];
                    n8 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 6, n8 - n9 - 1);
                this.buf[n9] = 92;
                this.buf[n9 + 1] = 117;
                this.buf[n9 + 2] = IOUtils.DIGITS[c4 >>> 12 & 0xF];
                this.buf[n9 + 3] = IOUtils.DIGITS[c4 >>> 8 & 0xF];
                this.buf[n9 + 4] = IOUtils.DIGITS[c4 >>> 4 & 0xF];
                this.buf[n9 + 5] = IOUtils.DIGITS[c4 & 0xF];
                n8 += 5;
            }
            if (c2 != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = c2;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        int n11 = 0;
        int n12 = -1;
        int n13 = -1;
        int n14 = 0;
        for (n4 = n7; n4 < n8; ++n4) {
            n3 = this.buf[n4];
            if (n3 >= 93) {
                if (n3 < 127 || n3 != 8232 && n3 != 8233 && n3 >= 160) continue;
                if (n13 == -1) {
                    n13 = n4;
                }
                ++n11;
                n12 = n4;
                n14 = n3;
                n6 += 4;
                continue;
            }
            int n15 = n2 = n3 < 64 && (this.sepcialBits & 1L << n3) != 0L || n3 == 92 ? 1 : 0;
            if (n2 == 0) continue;
            ++n11;
            n12 = n4;
            n14 = n3;
            if (n3 == 40 || n3 == 41 || n3 == 60 || n3 == 62 || n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                n6 += 4;
            }
            if (n13 != -1) continue;
            n13 = n4;
        }
        if (n11 > 0) {
            if ((n6 += n11) > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            if (n11 == 1) {
                if (n14 == 8232) {
                    n4 = n12 + 1;
                    n3 = n12 + 6;
                    n2 = n8 - n12 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n12] = 92;
                    this.buf[++n12] = 117;
                    this.buf[++n12] = 50;
                    this.buf[++n12] = 48;
                    this.buf[++n12] = 50;
                    this.buf[++n12] = 56;
                } else if (n14 == 8233) {
                    n4 = n12 + 1;
                    n3 = n12 + 6;
                    n2 = n8 - n12 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n12] = 92;
                    this.buf[++n12] = 117;
                    this.buf[++n12] = 50;
                    this.buf[++n12] = 48;
                    this.buf[++n12] = 50;
                    this.buf[++n12] = 57;
                } else if (n14 == 40 || n14 == 41 || n14 == 60 || n14 == 62) {
                    n4 = n12 + 1;
                    n3 = n12 + 6;
                    n2 = n8 - n12 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n12] = 92;
                    this.buf[++n12] = 117;
                    int n16 = n14;
                    this.buf[++n12] = IOUtils.DIGITS[n16 >>> 12 & 0xF];
                    this.buf[++n12] = IOUtils.DIGITS[n16 >>> 8 & 0xF];
                    this.buf[++n12] = IOUtils.DIGITS[n16 >>> 4 & 0xF];
                    this.buf[++n12] = IOUtils.DIGITS[n16 & 0xF];
                } else {
                    n4 = n14;
                    if (n4 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n4] == 4) {
                        n3 = n12 + 1;
                        n2 = n12 + 6;
                        int n17 = n8 - n12 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n17);
                        int n18 = n12;
                        this.buf[n18++] = 92;
                        this.buf[n18++] = 117;
                        this.buf[n18++] = IOUtils.DIGITS[n4 >>> 12 & 0xF];
                        this.buf[n18++] = IOUtils.DIGITS[n4 >>> 8 & 0xF];
                        this.buf[n18++] = IOUtils.DIGITS[n4 >>> 4 & 0xF];
                        this.buf[n18++] = IOUtils.DIGITS[n4 & 0xF];
                    } else {
                        n3 = n12 + 1;
                        n2 = n12 + 2;
                        int n19 = n8 - n12 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n19);
                        this.buf[n12] = 92;
                        this.buf[++n12] = IOUtils.replaceChars[n4];
                    }
                }
            } else if (n11 > 1) {
                n4 = n13 - n7;
                n3 = n13;
                for (n2 = n4; n2 < cArray.length; ++n2) {
                    char c5 = cArray[n2];
                    if (this.browserSecure && (c5 == '(' || c5 == ')' || c5 == '<' || c5 == '>')) {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 & 0xF];
                        n8 += 5;
                        continue;
                    }
                    if (c5 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c5] != 0 || c5 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n3++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[c5] == 4) {
                            this.buf[n3++] = 117;
                            this.buf[n3++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c5 & 0xF];
                            n8 += 5;
                            continue;
                        }
                        this.buf[n3++] = IOUtils.replaceChars[c5];
                        ++n8;
                        continue;
                    }
                    if (c5 == '\u2028' || c5 == '\u2029') {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c5 & 0xF];
                        n8 += 5;
                        continue;
                    }
                    this.buf[n3++] = c5;
                }
            }
        }
        if (c2 != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = c2;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    public void writeFieldNameDirect(String string) {
        int n2 = string.length();
        int n3 = this.count + n2 + 3;
        if (n3 > this.buf.length) {
            this.expandCapacity(n3);
        }
        int n4 = this.count + 1;
        this.buf[this.count] = 34;
        string.getChars(0, n2, this.buf, n4);
        this.count = n3;
        this.buf[this.count - 2] = 34;
        this.buf[this.count - 1] = 58;
    }

    public void write(List<String> list) {
        int n2;
        if (list.isEmpty()) {
            this.write("[]");
            return;
        }
        int n3 = n2 = this.count;
        int n4 = list.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            String string = list.get(i2);
            boolean bl = false;
            if (string == null) {
                bl = true;
            } else {
                char c2;
                int n6 = string.length();
                for (n5 = 0; n5 < n6 && !(bl = (c2 = string.charAt(n5)) < ' ' || c2 > '~' || c2 == '\"' || c2 == '\\'); ++n5) {
                }
            }
            if (bl) {
                this.count = n3;
                this.write(91);
                for (n5 = 0; n5 < list.size(); ++n5) {
                    string = list.get(n5);
                    if (n5 != 0) {
                        this.write(44);
                    }
                    if (string == null) {
                        this.write("null");
                        continue;
                    }
                    this.writeStringWithDoubleQuote(string, '\u0000');
                }
                this.write(93);
                return;
            }
            n5 = n2 + string.length() + 3;
            if (i2 == list.size() - 1) {
                ++n5;
            }
            if (n5 > this.buf.length) {
                this.count = n2;
                this.expandCapacity(n5);
            }
            this.buf[n2++] = i2 == 0 ? 91 : 44;
            this.buf[n2++] = 34;
            string.getChars(0, string.length(), this.buf, n2);
            n2 += string.length();
            this.buf[n2++] = 34;
        }
        this.buf[n2++] = 93;
        this.count = n2;
    }

    public void writeFieldValue(char c2, String string, char c3) {
        this.write(c2);
        this.writeFieldName(string);
        if (c3 == '\u0000') {
            this.writeString("\u0000");
        } else {
            this.writeString(Character.toString(c3));
        }
    }

    public void writeFieldValue(char c2, String string, boolean bl) {
        if (!this.quoteFieldNames) {
            this.write(c2);
            this.writeFieldName(string);
            this.write(bl);
            return;
        }
        int n2 = bl ? 4 : 5;
        int n3 = string.length();
        int n4 = this.count + n3 + 4 + n2;
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeString(string);
                this.write(58);
                this.write(bl);
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count;
        this.count = n4;
        this.buf[n5] = c2;
        int n6 = n5 + n3 + 1;
        this.buf[n5 + 1] = this.keySeperator;
        string.getChars(0, n3, this.buf, n5 + 2);
        this.buf[n6 + 1] = this.keySeperator;
        if (bl) {
            System.arraycopy(VALUE_TRUE, 0, this.buf, n6 + 2, 5);
        } else {
            System.arraycopy(VALUE_FALSE, 0, this.buf, n6 + 2, 6);
        }
    }

    public void write(boolean bl) {
        if (bl) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void writeFieldValue(char c2, String string, int n2) {
        if (n2 == Integer.MIN_VALUE || !this.quoteFieldNames) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeInt(n2);
            return;
        }
        int n3 = n2 < 0 ? IOUtils.stringSize(-n2) + 1 : IOUtils.stringSize(n2);
        int n4 = string.length();
        int n5 = this.count + n4 + 4 + n3;
        if (n5 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeFieldName(string);
                this.writeInt(n2);
                return;
            }
            this.expandCapacity(n5);
        }
        int n6 = this.count;
        this.count = n5;
        this.buf[n6] = c2;
        int n7 = n6 + n4 + 1;
        this.buf[n6 + 1] = this.keySeperator;
        string.getChars(0, n4, this.buf, n6 + 2);
        this.buf[n7 + 1] = this.keySeperator;
        this.buf[n7 + 2] = 58;
        IOUtils.getChars(n2, this.count, this.buf);
    }

    public void writeFieldValue(char c2, String string, long l2) {
        if (l2 == Long.MIN_VALUE || !this.quoteFieldNames || this.isEnabled(SerializerFeature.BrowserCompatible.mask)) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeLong(l2);
            return;
        }
        int n2 = l2 < 0L ? IOUtils.stringSize(-l2) + 1 : IOUtils.stringSize(l2);
        int n3 = string.length();
        int n4 = this.count + n3 + 4 + n2;
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeFieldName(string);
                this.writeLong(l2);
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count;
        this.count = n4;
        this.buf[n5] = c2;
        int n6 = n5 + n3 + 1;
        this.buf[n5 + 1] = this.keySeperator;
        string.getChars(0, n3, this.buf, n5 + 2);
        this.buf[n6 + 1] = this.keySeperator;
        this.buf[n6 + 2] = 58;
        IOUtils.getChars(l2, this.count, this.buf);
    }

    public void writeFieldValue(char c2, String string, float f2) {
        this.write(c2);
        this.writeFieldName(string);
        this.writeFloat(f2, false);
    }

    public void writeFieldValue(char c2, String string, double d2) {
        this.write(c2);
        this.writeFieldName(string);
        this.writeDouble(d2, false);
    }

    public void writeFieldValue(char c2, String string, String string2) {
        if (this.quoteFieldNames) {
            if (this.useSingleQuotes) {
                this.write(c2);
                this.writeFieldName(string);
                if (string2 == null) {
                    this.writeNull();
                } else {
                    this.writeString(string2);
                }
            } else if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                this.write(c2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
            } else {
                this.writeFieldValueStringWithDoubleQuoteCheck(c2, string, string2);
            }
        } else {
            this.write(c2);
            this.writeFieldName(string);
            if (string2 == null) {
                this.writeNull();
            } else {
                this.writeString(string2);
            }
        }
    }

    public void writeFieldValueStringWithDoubleQuoteCheck(char c2, String string, String string2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = string.length();
        int n7 = this.count;
        if (string2 == null) {
            n5 = 4;
            n7 += n6 + 8;
        } else {
            n5 = string2.length();
            n7 += n6 + n5 + 6;
        }
        if (n7 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.expandCapacity(n7);
        }
        this.buf[this.count] = c2;
        int n8 = this.count + 2;
        int n9 = n8 + n6;
        this.buf[this.count + 1] = 34;
        string.getChars(0, n6, this.buf, n8);
        this.count = n7;
        this.buf[n9] = 34;
        int n10 = n9 + 1;
        this.buf[n10++] = 58;
        if (string2 == null) {
            this.buf[n10++] = 110;
            this.buf[n10++] = 117;
            this.buf[n10++] = 108;
            this.buf[n10++] = 108;
            return;
        }
        this.buf[n10++] = 34;
        int n11 = n10;
        int n12 = n11 + n5;
        string2.getChars(0, n5, this.buf, n11);
        int n13 = 0;
        int n14 = -1;
        int n15 = -1;
        int n16 = 0;
        for (n4 = n11; n4 < n12; ++n4) {
            n3 = this.buf[n4];
            if (n3 >= 93) {
                if (n3 < 127 || n3 != 8232 && n3 != 8233 && n3 >= 160) continue;
                if (n15 == -1) {
                    n15 = n4;
                }
                ++n13;
                n14 = n4;
                n16 = n3;
                n7 += 4;
                continue;
            }
            int n17 = n2 = n3 < 64 && (this.sepcialBits & 1L << n3) != 0L || n3 == 92 ? 1 : 0;
            if (n2 == 0) continue;
            ++n13;
            n14 = n4;
            n16 = n3;
            if (n3 == 40 || n3 == 41 || n3 == 60 || n3 == 62 || n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                n7 += 4;
            }
            if (n15 != -1) continue;
            n15 = n4;
        }
        if (n13 > 0) {
            if ((n7 += n13) > this.buf.length) {
                this.expandCapacity(n7);
            }
            this.count = n7;
            if (n13 == 1) {
                if (n16 == 8232) {
                    n4 = n14 + 1;
                    n3 = n14 + 6;
                    n2 = n12 - n14 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n14] = 92;
                    this.buf[++n14] = 117;
                    this.buf[++n14] = 50;
                    this.buf[++n14] = 48;
                    this.buf[++n14] = 50;
                    this.buf[++n14] = 56;
                } else if (n16 == 8233) {
                    n4 = n14 + 1;
                    n3 = n14 + 6;
                    n2 = n12 - n14 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n14] = 92;
                    this.buf[++n14] = 117;
                    this.buf[++n14] = 50;
                    this.buf[++n14] = 48;
                    this.buf[++n14] = 50;
                    this.buf[++n14] = 57;
                } else if (n16 == 40 || n16 == 41 || n16 == 60 || n16 == 62) {
                    n4 = n16;
                    n3 = n14 + 1;
                    n2 = n14 + 6;
                    int n18 = n12 - n14 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n18);
                    int n19 = n14;
                    this.buf[n19++] = 92;
                    this.buf[n19++] = 117;
                    this.buf[n19++] = IOUtils.DIGITS[n4 >>> 12 & 0xF];
                    this.buf[n19++] = IOUtils.DIGITS[n4 >>> 8 & 0xF];
                    this.buf[n19++] = IOUtils.DIGITS[n4 >>> 4 & 0xF];
                    this.buf[n19++] = IOUtils.DIGITS[n4 & 0xF];
                } else {
                    n4 = n16;
                    if (n4 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n4] == 4) {
                        n3 = n14 + 1;
                        n2 = n14 + 6;
                        int n20 = n12 - n14 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n20);
                        int n21 = n14;
                        this.buf[n21++] = 92;
                        this.buf[n21++] = 117;
                        this.buf[n21++] = IOUtils.DIGITS[n4 >>> 12 & 0xF];
                        this.buf[n21++] = IOUtils.DIGITS[n4 >>> 8 & 0xF];
                        this.buf[n21++] = IOUtils.DIGITS[n4 >>> 4 & 0xF];
                        this.buf[n21++] = IOUtils.DIGITS[n4 & 0xF];
                    } else {
                        n3 = n14 + 1;
                        n2 = n14 + 2;
                        int n22 = n12 - n14 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n22);
                        this.buf[n14] = 92;
                        this.buf[++n14] = IOUtils.replaceChars[n4];
                    }
                }
            } else if (n13 > 1) {
                n4 = n15 - n11;
                n3 = n15;
                for (n2 = n4; n2 < string2.length(); ++n2) {
                    char c3 = string2.charAt(n2);
                    if (this.browserSecure && (c3 == '(' || c3 == ')' || c3 == '<' || c3 == '>')) {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[c3 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c3 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c3 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c3 & 0xF];
                        n12 += 5;
                        continue;
                    }
                    if (c3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c3] != 0 || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n3++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[c3] == 4) {
                            this.buf[n3++] = 117;
                            this.buf[n3++] = IOUtils.DIGITS[c3 >>> 12 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c3 >>> 8 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c3 >>> 4 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[c3 & 0xF];
                            n12 += 5;
                            continue;
                        }
                        this.buf[n3++] = IOUtils.replaceChars[c3];
                        ++n12;
                        continue;
                    }
                    if (c3 == '\u2028' || c3 == '\u2029') {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[c3 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c3 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c3 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[c3 & 0xF];
                        n12 += 5;
                        continue;
                    }
                    this.buf[n3++] = c3;
                }
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public void writeFieldValueStringWithDoubleQuote(char c2, String string, String string2) {
        int n2 = string.length();
        int n3 = this.count;
        int n4 = string2.length();
        if ((n3 += n2 + n4 + 6) > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.expandCapacity(n3);
        }
        this.buf[this.count] = c2;
        int n5 = this.count + 2;
        int n6 = n5 + n2;
        this.buf[this.count + 1] = 34;
        string.getChars(0, n2, this.buf, n5);
        this.count = n3;
        this.buf[n6] = 34;
        int n7 = n6 + 1;
        this.buf[n7++] = 58;
        this.buf[n7++] = 34;
        int n8 = n7;
        string2.getChars(0, n4, this.buf, n8);
        this.buf[this.count - 1] = 34;
    }

    public void writeFieldValue(char c2, String string, Enum<?> enum_) {
        if (enum_ == null) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeNull();
            return;
        }
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            this.writeEnumFieldValue(c2, string, enum_.name());
        } else if (this.writeEnumUsingToString) {
            this.writeEnumFieldValue(c2, string, enum_.toString());
        } else {
            this.writeFieldValue(c2, string, enum_.ordinal());
        }
    }

    private void writeEnumFieldValue(char c2, String string, String string2) {
        if (this.useSingleQuotes) {
            this.writeFieldValue(c2, string, string2);
        } else {
            this.writeFieldValueStringWithDoubleQuote(c2, string, string2);
        }
    }

    public void writeFieldValue(char c2, String string, BigDecimal bigDecimal) {
        this.write(c2);
        this.writeFieldName(string);
        if (bigDecimal == null) {
            this.writeNull();
        } else {
            int n2 = bigDecimal.scale();
            this.write(this.isEnabled(SerializerFeature.WriteBigDecimalAsPlain) && n2 >= -100 && n2 < 100 ? bigDecimal.toPlainString() : bigDecimal.toString());
        }
    }

    public void writeString(String string, char c2) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
            this.write(c2);
        } else {
            this.writeStringWithDoubleQuote(string, c2);
        }
    }

    public void writeString(String string) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
        } else {
            this.writeStringWithDoubleQuote(string, '\u0000');
        }
    }

    public void writeString(char[] cArray) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(cArray);
        } else {
            String string = new String(cArray);
            this.writeStringWithDoubleQuote(string, '\u0000');
        }
    }

    protected void writeStringWithSingleQuote(String string) {
        char c2;
        int n2;
        if (string == null) {
            int n3 = this.count + 4;
            if (n3 > this.buf.length) {
                this.expandCapacity(n3);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = n3;
            return;
        }
        int n4 = string.length();
        int n5 = this.count + n4 + 2;
        if (n5 > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c3 = string.charAt(i2);
                    if (c3 <= '\r' || c3 == '\\' || c3 == '\'' || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(n5);
        }
        int n6 = this.count + 1;
        int n7 = n6 + n4;
        this.buf[this.count] = 39;
        string.getChars(0, n4, this.buf, n6);
        this.count = n5;
        int n8 = 0;
        int n9 = -1;
        char c4 = '\u0000';
        for (n2 = n6; n2 < n7; ++n2) {
            c2 = this.buf[n2];
            if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n8;
            n9 = n2;
            c4 = c2;
        }
        if ((n5 += n8) > this.buf.length) {
            this.expandCapacity(n5);
        }
        this.count = n5;
        if (n8 == 1) {
            System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n7 - n9 - 1);
            this.buf[n9] = 92;
            this.buf[++n9] = IOUtils.replaceChars[c4];
        } else if (n8 > 1) {
            System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n7 - n9 - 1);
            this.buf[n9] = 92;
            this.buf[++n9] = IOUtils.replaceChars[c4];
            ++n7;
            for (n2 = n9 - 2; n2 >= n6; --n2) {
                c2 = this.buf[n2];
                if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, n2 + 1, this.buf, n2 + 2, n7 - n2 - 1);
                this.buf[n2] = 92;
                this.buf[n2 + 1] = IOUtils.replaceChars[c2];
                ++n7;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    protected void writeStringWithSingleQuote(char[] cArray) {
        char c2;
        int n2;
        if (cArray == null) {
            int n3 = this.count + 4;
            if (n3 > this.buf.length) {
                this.expandCapacity(n3);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = n3;
            return;
        }
        int n4 = cArray.length;
        int n5 = this.count + n4 + 2;
        if (n5 > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    char c3 = cArray[i2];
                    if (c3 <= '\r' || c3 == '\\' || c3 == '\'' || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(n5);
        }
        int n6 = this.count + 1;
        int n7 = n6 + n4;
        this.buf[this.count] = 39;
        System.arraycopy(cArray, 0, this.buf, n6, cArray.length);
        this.count = n5;
        int n8 = 0;
        int n9 = -1;
        char c4 = '\u0000';
        for (n2 = n6; n2 < n7; ++n2) {
            c2 = this.buf[n2];
            if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n8;
            n9 = n2;
            c4 = c2;
        }
        if ((n5 += n8) > this.buf.length) {
            this.expandCapacity(n5);
        }
        this.count = n5;
        if (n8 == 1) {
            System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n7 - n9 - 1);
            this.buf[n9] = 92;
            this.buf[++n9] = IOUtils.replaceChars[c4];
        } else if (n8 > 1) {
            System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n7 - n9 - 1);
            this.buf[n9] = 92;
            this.buf[++n9] = IOUtils.replaceChars[c4];
            ++n7;
            for (n2 = n9 - 2; n2 >= n6; --n2) {
                c2 = this.buf[n2];
                if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, n2 + 1, this.buf, n2 + 2, n7 - n2 - 1);
                this.buf[n2] = 92;
                this.buf[n2 + 1] = IOUtils.replaceChars[c2];
                ++n7;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public void writeFieldName(String string) {
        this.writeFieldName(string, false);
    }

    public void writeFieldName(String string, boolean bl) {
        if (string == null) {
            this.write("null:");
            return;
        }
        if (this.useSingleQuotes) {
            if (this.quoteFieldNames) {
                this.writeStringWithSingleQuote(string);
                this.write(58);
            } else {
                this.writeKeyWithSingleQuoteIfHasSpecial(string);
            }
        } else if (this.quoteFieldNames) {
            this.writeStringWithDoubleQuote(string, ':');
        } else {
            boolean bl2 = string.length() == 0;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                boolean bl3;
                char c2 = string.charAt(i2);
                boolean bl4 = bl3 = c2 < '@' && (this.sepcialBits & 1L << c2) != 0L || c2 == '\\';
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                this.writeStringWithDoubleQuote(string, ':');
            } else {
                this.write(string);
                this.write(58);
            }
        }
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String string) {
        byte[] byArray = IOUtils.specicalFlags_singleQuotes;
        int n2 = string.length();
        int n3 = this.count + n2 + 1;
        if (n3 > this.buf.length) {
            if (this.writer != null) {
                char c2;
                int n4;
                if (n2 == 0) {
                    this.write(39);
                    this.write(39);
                    this.write(58);
                    return;
                }
                boolean bl = false;
                for (n4 = 0; n4 < n2; ++n4) {
                    c2 = string.charAt(n4);
                    if (c2 >= byArray.length || byArray[c2] == 0) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.write(39);
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    c2 = string.charAt(n4);
                    if (c2 < byArray.length && byArray[c2] != 0) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c2]);
                        continue;
                    }
                    this.write(c2);
                }
                if (bl) {
                    this.write(39);
                }
                this.write(58);
                return;
            }
            this.expandCapacity(n3);
        }
        if (n2 == 0) {
            int n5 = this.count + 3;
            if (n5 > this.buf.length) {
                this.expandCapacity(this.count + 3);
            }
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 58;
            return;
        }
        int n6 = this.count;
        int n7 = n6 + n2;
        string.getChars(0, n2, this.buf, n6);
        this.count = n3;
        boolean bl = false;
        for (int i2 = n6; i2 < n7; ++i2) {
            char c3 = this.buf[i2];
            if (c3 >= byArray.length || byArray[c3] == 0) continue;
            if (!bl) {
                if ((n3 += 3) > this.buf.length) {
                    this.expandCapacity(n3);
                }
                this.count = n3;
                System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 3, n7 - i2 - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i2);
                this.buf[n6] = 39;
                this.buf[++i2] = 92;
                this.buf[++i2] = IOUtils.replaceChars[c3];
                n7 += 2;
                this.buf[this.count - 2] = 39;
                bl = true;
                continue;
            }
            if (++n3 > this.buf.length) {
                this.expandCapacity(n3);
            }
            this.count = n3;
            System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 2, n7 - i2);
            this.buf[i2] = 92;
            this.buf[++i2] = IOUtils.replaceChars[c3];
            ++n7;
        }
        this.buf[n3 - 1] = 58;
    }

    @Override
    public void flush() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(this.buf, 0, this.count);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        this.count = 0;
    }

    public void reset() {
        this.count = 0;
    }

    static {
        try {
            int n2;
            String string = IOUtils.getStringProperty("fastjson.serializer_buffer_threshold");
            if (string != null && string.length() > 0 && (n2 = Integer.parseInt(string)) >= 64 && n2 <= 65536) {
                BUFFER_THRESHOLD = n2 * 1024;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        nonDirectFeatures = 0 | SerializerFeature.UseSingleQuotes.mask | SerializerFeature.BrowserCompatible.mask | SerializerFeature.PrettyFormat.mask | SerializerFeature.WriteEnumUsingToString.mask | SerializerFeature.WriteNonStringValueAsString.mask | SerializerFeature.WriteSlashAsSpecial.mask | SerializerFeature.IgnoreErrorGetter.mask | SerializerFeature.WriteClassName.mask | SerializerFeature.NotWriteDefaultValue.mask;
    }
}

