/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;

public class IOUtils {
    public static final String FASTJSON_PROPERTIES = "fastjson.properties";
    public static final String FASTJSON_COMPATIBLEWITHJAVABEAN = "fastjson.compatibleWithJavaBean";
    public static final String FASTJSON_COMPATIBLEWITHFIELDNAME = "fastjson.compatibleWithFieldName";
    public static final Properties DEFAULT_PROPERTIES;
    public static final Charset UTF8;
    public static final char[] DIGITS;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;
    public static final byte[] specicalFlags_doubleQuotes;
    public static final byte[] specicalFlags_singleQuotes;
    public static final boolean[] specicalFlags_doubleQuotesFlags;
    public static final boolean[] specicalFlags_singleQuotesFlags;
    public static final char[] replaceChars;
    public static final char[] ASCII_CHARS;
    static final char[] digits;
    static final char[] DigitTens;
    static final char[] DigitOnes;
    static final int[] sizeTable;
    public static final char[] CA;
    public static final int[] IA;

    public static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2 == null ? DEFAULT_PROPERTIES.getProperty(string) : string2;
    }

    public static void loadPropertiesFromFile() {
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
                }
                return ClassLoader.getSystemResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
            }
        });
        if (null != inputStream) {
            try {
                DEFAULT_PROPERTIES.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int stringSize(long l2) {
        long l3 = 10L;
        for (int i2 = 1; i2 < 19; ++i2) {
            if (l2 < l3) {
                return i2;
            }
            l3 = 10L * l3;
        }
        return 19;
    }

    public static void getChars(long l2, int n2, char[] cArray) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = 0;
        if (l2 < 0L) {
            n6 = 45;
            l2 = -l2;
        }
        while (l2 > Integer.MAX_VALUE) {
            long l3 = l2 / 100L;
            n4 = (int)(l2 - ((l3 << 6) + (l3 << 5) + (l3 << 2)));
            l2 = l3;
            cArray[--n5] = DigitOnes[n4];
            cArray[--n5] = DigitTens[n4];
        }
        int n7 = (int)l2;
        while (n7 >= 65536) {
            n3 = n7 / 100;
            n4 = n7 - ((n3 << 6) + (n3 << 5) + (n3 << 2));
            n7 = n3;
            cArray[--n5] = DigitOnes[n4];
            cArray[--n5] = DigitTens[n4];
        }
        do {
            n3 = n7 * 52429 >>> 19;
            n4 = n7 - ((n3 << 3) + (n3 << 1));
            cArray[--n5] = digits[n4];
        } while ((n7 = n3) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    public static void getChars(int n2, int n3, char[] cArray) {
        int n4;
        int n5;
        int n6 = n3;
        int n7 = 0;
        if (n2 < 0) {
            n7 = 45;
            n2 = -n2;
        }
        while (n2 >= 65536) {
            n5 = n2 / 100;
            n4 = n2 - ((n5 << 6) + (n5 << 5) + (n5 << 2));
            n2 = n5;
            cArray[--n6] = DigitOnes[n4];
            cArray[--n6] = DigitTens[n4];
        }
        do {
            n5 = n2 * 52429 >>> 19;
            n4 = n2 - ((n5 << 3) + (n5 << 1));
            cArray[--n6] = digits[n4];
        } while ((n2 = n5) != 0);
        if (n7 != 0) {
            cArray[--n6] = n7;
        }
    }

    public static void getChars(byte n2, int n3, char[] cArray) {
        int n4;
        int n5 = n2;
        int n6 = n3;
        int n7 = 0;
        if (n5 < 0) {
            n7 = 45;
            n5 = -n5;
        }
        do {
            n4 = n5 * 52429 >>> 19;
            int n8 = n5 - ((n4 << 3) + (n4 << 1));
            cArray[--n6] = digits[n8];
        } while ((n5 = n4) != 0);
        if (n7 != 0) {
            cArray[--n6] = n7;
        }
    }

    public static int stringSize(int n2) {
        int n3 = 0;
        while (n2 > sizeTable[n3]) {
            ++n3;
        }
        return n3 + 1;
    }

    public static void decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer) {
        try {
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new JSONException("utf8 decode error, " + characterCodingException.getMessage(), characterCodingException);
        }
    }

    public static boolean firstIdentifier(char c2) {
        return c2 < firstIdentifierFlags.length && firstIdentifierFlags[c2];
    }

    public static boolean isIdent(char c2) {
        return c2 < identifierFlags.length && identifierFlags[c2];
    }

    public static byte[] decodeBase64(char[] cArray, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return new byte[0];
        }
        int n5 = n2 + n3 - 1;
        for (n4 = n2; n4 < n5 && IA[cArray[n4]] < 0; ++n4) {
        }
        while (n5 > 0 && IA[cArray[n5]] < 0) {
            --n5;
        }
        int n6 = cArray[n5] == '=' ? (cArray[n5 - 1] == '=' ? 2 : 1) : 0;
        int n7 = n5 - n4 + 1;
        int n8 = n3 > 76 ? (cArray[76] == '\r' ? n7 / 78 : 0) << 1 : 0;
        int n9 = ((n7 - n8) * 6 >> 3) - n6;
        byte[] byArray = new byte[n9];
        int n10 = 0;
        int n11 = 0;
        int n12 = n9 / 3 * 3;
        while (n10 < n12) {
            int n13 = IA[cArray[n4++]] << 18 | IA[cArray[n4++]] << 12 | IA[cArray[n4++]] << 6 | IA[cArray[n4++]];
            byArray[n10++] = (byte)(n13 >> 16);
            byArray[n10++] = (byte)(n13 >> 8);
            byArray[n10++] = (byte)n13;
            if (n8 <= 0 || ++n11 != 19) continue;
            n4 += 2;
            n11 = 0;
        }
        if (n10 < n9) {
            n11 = 0;
            n12 = 0;
            while (n4 <= n5 - n6) {
                n11 |= IA[cArray[n4++]] << 18 - n12 * 6;
                ++n12;
            }
            n12 = 16;
            while (n10 < n9) {
                byArray[n10++] = (byte)(n11 >> n12);
                n12 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] decodeBase64(String string, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return new byte[0];
        }
        int n5 = n2 + n3 - 1;
        for (n4 = n2; n4 < n5 && IA[string.charAt(n4)] < 0; ++n4) {
        }
        while (n5 > 0 && IA[string.charAt(n5)] < 0) {
            --n5;
        }
        int n6 = string.charAt(n5) == '=' ? (string.charAt(n5 - 1) == '=' ? 2 : 1) : 0;
        int n7 = n5 - n4 + 1;
        int n8 = n3 > 76 ? (string.charAt(76) == '\r' ? n7 / 78 : 0) << 1 : 0;
        int n9 = ((n7 - n8) * 6 >> 3) - n6;
        byte[] byArray = new byte[n9];
        int n10 = 0;
        int n11 = 0;
        int n12 = n9 / 3 * 3;
        while (n10 < n12) {
            int n13 = IA[string.charAt(n4++)] << 18 | IA[string.charAt(n4++)] << 12 | IA[string.charAt(n4++)] << 6 | IA[string.charAt(n4++)];
            byArray[n10++] = (byte)(n13 >> 16);
            byArray[n10++] = (byte)(n13 >> 8);
            byArray[n10++] = (byte)n13;
            if (n8 <= 0 || ++n11 != 19) continue;
            n4 += 2;
            n11 = 0;
        }
        if (n10 < n9) {
            n11 = 0;
            n12 = 0;
            while (n4 <= n5 - n6) {
                n11 |= IA[string.charAt(n4++)] << 18 - n12 * 6;
                ++n12;
            }
            n12 = 16;
            while (n10 < n9) {
                byArray[n10++] = (byte)(n11 >> n12);
                n12 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] decodeBase64(String string) {
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n4 && IA[string.charAt(n2) & 0xFF] < 0; ++n2) {
        }
        while (n4 > 0 && IA[string.charAt(n4) & 0xFF] < 0) {
            --n4;
        }
        int n5 = string.charAt(n4) == '=' ? (string.charAt(n4 - 1) == '=' ? 2 : 1) : 0;
        int n6 = n4 - n2 + 1;
        int n7 = n3 > 76 ? (string.charAt(76) == '\r' ? n6 / 78 : 0) << 1 : 0;
        int n8 = ((n6 - n7) * 6 >> 3) - n5;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = n8 / 3 * 3;
        while (n9 < n11) {
            int n12 = IA[string.charAt(n2++)] << 18 | IA[string.charAt(n2++)] << 12 | IA[string.charAt(n2++)] << 6 | IA[string.charAt(n2++)];
            byArray[n9++] = (byte)(n12 >> 16);
            byArray[n9++] = (byte)(n12 >> 8);
            byArray[n9++] = (byte)n12;
            if (n7 <= 0 || ++n10 != 19) continue;
            n2 += 2;
            n10 = 0;
        }
        if (n9 < n8) {
            n10 = 0;
            n11 = 0;
            while (n2 <= n4 - n5) {
                n10 |= IA[string.charAt(n2++)] << 18 - n11 * 6;
                ++n11;
            }
            n11 = 16;
            while (n9 < n8) {
                byArray[n9++] = (byte)(n10 >> n11);
                n11 -= 8;
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int encodeUTF8(char[] cArray, int n2, int n3, byte[] byArray) {
        int n4 = n2 + n3;
        int n5 = 0;
        int n6 = n5 + Math.min(n3, byArray.length);
        while (n5 < n6 && cArray[n2] < '\u0080') {
            byArray[n5++] = (byte)cArray[n2++];
        }
        while (true) {
            int n7;
            block12: {
                int n8;
                block11: {
                    block13: {
                        if (n2 >= n4) {
                            return n5;
                        }
                        if ((n7 = cArray[n2++]) < 128) {
                            byArray[n5++] = (byte)n7;
                            continue;
                        }
                        if (n7 < 2048) {
                            byArray[n5++] = (byte)(0xC0 | n7 >> 6);
                            byArray[n5++] = (byte)(0x80 | n7 & 0x3F);
                            continue;
                        }
                        if (n7 < 55296 || n7 >= 57344) break block12;
                        int n9 = n2 - 1;
                        if (n7 < 55296 || n7 >= 56320) break block13;
                        if (n4 - n9 < 2) {
                            n8 = -1;
                            break block11;
                        } else {
                            char c2 = cArray[n9 + 1];
                            if (c2 >= '\udc00' && c2 < '\ue000') {
                                n8 = (n7 << 10) + c2 + -56613888;
                                break block11;
                            } else {
                                byArray[n5++] = 63;
                                continue;
                            }
                        }
                    }
                    if (n7 >= 56320 && n7 < 57344) {
                        byArray[n5++] = 63;
                        continue;
                    }
                    n8 = n7;
                }
                if (n8 < 0) {
                    byArray[n5++] = 63;
                    continue;
                }
                byArray[n5++] = (byte)(0xF0 | n8 >> 18);
                byArray[n5++] = (byte)(0x80 | n8 >> 12 & 0x3F);
                byArray[n5++] = (byte)(0x80 | n8 >> 6 & 0x3F);
                byArray[n5++] = (byte)(0x80 | n8 & 0x3F);
                ++n2;
                continue;
            }
            byArray[n5++] = (byte)(0xE0 | n7 >> 12);
            byArray[n5++] = (byte)(0x80 | n7 >> 6 & 0x3F);
            byArray[n5++] = (byte)(0x80 | n7 & 0x3F);
        }
    }

    public static int decodeUTF8(byte[] byArray, int n2, int n3, char[] cArray) {
        int n4 = n2 + n3;
        int n5 = 0;
        int n6 = Math.min(n3, cArray.length);
        while (n5 < n6 && byArray[n2] >= 0) {
            cArray[n5++] = (char)byArray[n2++];
        }
        while (n2 < n4) {
            int n7;
            char c2;
            byte by;
            byte by2;
            byte by3;
            if ((by3 = byArray[n2++]) >= 0) {
                cArray[n5++] = (char)by3;
                continue;
            }
            if (by3 >> 5 == -2 && (by3 & 0x1E) != 0) {
                if (n2 < n4) {
                    if (((by2 = byArray[n2++]) & 0xC0) != 128) {
                        return -1;
                    }
                    cArray[n5++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (by3 >> 4 == -2) {
                if (n2 + 1 < n4) {
                    by2 = byArray[n2++];
                    by = byArray[n2++];
                    if (by3 == -32 && (by2 & 0xE0) == 128 || (by2 & 0xC0) != 128 || (by & 0xC0) != 128) {
                        return -1;
                    }
                    c2 = (char)(by3 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    int n8 = n7 = c2 >= '\ud800' && c2 < '\ue000' ? 1 : 0;
                    if (n7 != 0) {
                        return -1;
                    }
                    cArray[n5++] = c2;
                    continue;
                }
                return -1;
            }
            if (by3 >> 3 == -2) {
                if (n2 + 2 < n4) {
                    by2 = byArray[n2++];
                    by = byArray[n2++];
                    c2 = byArray[n2++];
                    n7 = by3 << 18 ^ by2 << 12 ^ by << 6 ^ (c2 ^ 0x381F80);
                    if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128 || (c2 & 0xC0) != 128 || n7 < 65536 || n7 >= 0x110000) {
                        return -1;
                    }
                    cArray[n5++] = (char)((n7 >>> 10) + 55232);
                    cArray[n5++] = (char)((n7 & 0x3FF) + 56320);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return n5;
    }

    public static String readAll(Reader reader) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n2;
            char[] cArray = new char[2048];
            while ((n2 = reader.read(cArray, 0, cArray.length)) >= 0) {
                stringBuilder.append(cArray, 0, n2);
            }
        }
        catch (Exception exception) {
            throw new JSONException("read string from reader error", exception);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidJsonpQueryParam(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '.' || IOUtils.isIdent(c2)) continue;
            return false;
        }
        return true;
    }

    static {
        int n2;
        int n3;
        DEFAULT_PROPERTIES = new Properties();
        UTF8 = Charset.forName("UTF-8");
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        firstIdentifierFlags = new boolean[256];
        identifierFlags = new boolean[256];
        for (n3 = 0; n3 < firstIdentifierFlags.length; n3 = (int)((char)(n3 + 1))) {
            if (n3 >= 65 && n3 <= 90) {
                IOUtils.firstIdentifierFlags[n3] = true;
                continue;
            }
            if (n3 >= 97 && n3 <= 122) {
                IOUtils.firstIdentifierFlags[n3] = true;
                continue;
            }
            if (n3 != 95 && n3 != 36) continue;
            IOUtils.firstIdentifierFlags[n3] = true;
        }
        for (n3 = 0; n3 < identifierFlags.length; n3 = (int)((char)(n3 + 1))) {
            if (n3 >= 65 && n3 <= 90) {
                IOUtils.identifierFlags[n3] = true;
                continue;
            }
            if (n3 >= 97 && n3 <= 122) {
                IOUtils.identifierFlags[n3] = true;
                continue;
            }
            if (n3 == 95) {
                IOUtils.identifierFlags[n3] = true;
                continue;
            }
            if (n3 < 48 || n3 > 57) continue;
            IOUtils.identifierFlags[n3] = true;
        }
        try {
            IOUtils.loadPropertiesFromFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        specicalFlags_doubleQuotes = new byte[161];
        specicalFlags_singleQuotes = new byte[161];
        specicalFlags_doubleQuotesFlags = new boolean[161];
        specicalFlags_singleQuotesFlags = new boolean[161];
        replaceChars = new char[93];
        IOUtils.specicalFlags_doubleQuotes[0] = 4;
        IOUtils.specicalFlags_doubleQuotes[1] = 4;
        IOUtils.specicalFlags_doubleQuotes[2] = 4;
        IOUtils.specicalFlags_doubleQuotes[3] = 4;
        IOUtils.specicalFlags_doubleQuotes[4] = 4;
        IOUtils.specicalFlags_doubleQuotes[5] = 4;
        IOUtils.specicalFlags_doubleQuotes[6] = 4;
        IOUtils.specicalFlags_doubleQuotes[7] = 4;
        IOUtils.specicalFlags_doubleQuotes[8] = 1;
        IOUtils.specicalFlags_doubleQuotes[9] = 1;
        IOUtils.specicalFlags_doubleQuotes[10] = 1;
        IOUtils.specicalFlags_doubleQuotes[11] = 4;
        IOUtils.specicalFlags_doubleQuotes[12] = 1;
        IOUtils.specicalFlags_doubleQuotes[13] = 1;
        IOUtils.specicalFlags_doubleQuotes[34] = 1;
        IOUtils.specicalFlags_doubleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[0] = 4;
        IOUtils.specicalFlags_singleQuotes[1] = 4;
        IOUtils.specicalFlags_singleQuotes[2] = 4;
        IOUtils.specicalFlags_singleQuotes[3] = 4;
        IOUtils.specicalFlags_singleQuotes[4] = 4;
        IOUtils.specicalFlags_singleQuotes[5] = 4;
        IOUtils.specicalFlags_singleQuotes[6] = 4;
        IOUtils.specicalFlags_singleQuotes[7] = 4;
        IOUtils.specicalFlags_singleQuotes[8] = 1;
        IOUtils.specicalFlags_singleQuotes[9] = 1;
        IOUtils.specicalFlags_singleQuotes[10] = 1;
        IOUtils.specicalFlags_singleQuotes[11] = 4;
        IOUtils.specicalFlags_singleQuotes[12] = 1;
        IOUtils.specicalFlags_singleQuotes[13] = 1;
        IOUtils.specicalFlags_singleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[39] = 1;
        for (n2 = 14; n2 <= 31; ++n2) {
            IOUtils.specicalFlags_doubleQuotes[n2] = 4;
            IOUtils.specicalFlags_singleQuotes[n2] = 4;
        }
        for (n2 = 127; n2 < 160; ++n2) {
            IOUtils.specicalFlags_doubleQuotes[n2] = 4;
            IOUtils.specicalFlags_singleQuotes[n2] = 4;
        }
        for (n2 = 0; n2 < 161; ++n2) {
            IOUtils.specicalFlags_doubleQuotesFlags[n2] = specicalFlags_doubleQuotes[n2] != 0;
            IOUtils.specicalFlags_singleQuotesFlags[n2] = specicalFlags_singleQuotes[n2] != 0;
        }
        IOUtils.replaceChars[0] = 48;
        IOUtils.replaceChars[1] = 49;
        IOUtils.replaceChars[2] = 50;
        IOUtils.replaceChars[3] = 51;
        IOUtils.replaceChars[4] = 52;
        IOUtils.replaceChars[5] = 53;
        IOUtils.replaceChars[6] = 54;
        IOUtils.replaceChars[7] = 55;
        IOUtils.replaceChars[8] = 98;
        IOUtils.replaceChars[9] = 116;
        IOUtils.replaceChars[10] = 110;
        IOUtils.replaceChars[11] = 118;
        IOUtils.replaceChars[12] = 102;
        IOUtils.replaceChars[13] = 114;
        IOUtils.replaceChars[34] = 34;
        IOUtils.replaceChars[39] = 39;
        IOUtils.replaceChars[47] = 47;
        IOUtils.replaceChars[92] = 92;
        ASCII_CHARS = new char[]{'0', '0', '0', '1', '0', '2', '0', '3', '0', '4', '0', '5', '0', '6', '0', '7', '0', '8', '0', '9', '0', 'A', '0', 'B', '0', 'C', '0', 'D', '0', 'E', '0', 'F', '1', '0', '1', '1', '1', '2', '1', '3', '1', '4', '1', '5', '1', '6', '1', '7', '1', '8', '1', '9', '1', 'A', '1', 'B', '1', 'C', '1', 'D', '1', 'E', '1', 'F', '2', '0', '2', '1', '2', '2', '2', '3', '2', '4', '2', '5', '2', '6', '2', '7', '2', '8', '2', '9', '2', 'A', '2', 'B', '2', 'C', '2', 'D', '2', 'E', '2', 'F'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int n4 = CA.length;
        for (n2 = 0; n2 < n4; ++n2) {
            IOUtils.IA[IOUtils.CA[n2]] = n2;
        }
        IOUtils.IA[61] = 0;
    }
}

