/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import java.util.Arrays;

public class IdentityHashMap<K, V> {
    private final Entry<K, V>[] buckets;
    private final int indexMask;
    public static final int DEFAULT_SIZE = 8192;

    public IdentityHashMap() {
        this(8192);
    }

    public IdentityHashMap(int n2) {
        this.indexMask = n2 - 1;
        this.buckets = new Entry[n2];
    }

    public final V get(K k2) {
        int n2 = System.identityHashCode(k2);
        int n3 = n2 & this.indexMask;
        Entry<K, V> entry = this.buckets[n3];
        while (entry != null) {
            if (k2 == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Class findClass(String string) {
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Entry<K, V> entry = this.buckets[i2];
            if (entry == null) continue;
            Entry<K, V> entry2 = entry;
            while (entry2 != null) {
                Class clazz;
                String string2;
                Object k2 = entry.key;
                if (k2 instanceof Class && (string2 = (clazz = (Class)k2).getName()).equals(string)) {
                    return clazz;
                }
                entry2 = entry2.next;
            }
        }
        return null;
    }

    public boolean put(K k2, V v2) {
        int n2 = System.identityHashCode(k2);
        int n3 = n2 & this.indexMask;
        Entry<K, V> entry = this.buckets[n3];
        while (entry != null) {
            if (k2 == entry.key) {
                entry.value = v2;
                return true;
            }
            entry = entry.next;
        }
        this.buckets[n3] = entry = new Entry<K, V>(k2, v2, n2, this.buckets[n3]);
        return false;
    }

    public void clear() {
        Arrays.fill(this.buckets, null);
    }

    protected static final class Entry<K, V> {
        public final int hashCode;
        public final K key;
        public V value;
        public final Entry<K, V> next;

        public Entry(K k2, V v2, int n2, Entry<K, V> entry) {
            this.key = k2;
            this.value = v2;
            this.next = entry;
            this.hashCode = n2;
        }
    }
}

