/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.internal.util.fastjson;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.JSONScanner;
import com.icbc.api.internal.util.fastjson.parser.ParserConfig;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ExtraProcessor;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ExtraTypeProvider;
import com.icbc.api.internal.util.fastjson.parser.deserializer.FieldTypeResolver;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ParseProcess;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializable;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JavaBeanSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeConfig;
import com.icbc.api.internal.util.fastjson.serializer.SerializeFilter;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import com.icbc.api.internal.util.internal.util.fastjson.JSONAware;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import com.icbc.api.internal.util.internal.util.fastjson.JSONStreamAware;
import com.icbc.api.internal.util.internal.util.fastjson.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JSON
implements JSONAware,
JSONStreamAware {
    public static TimeZone defaultTimeZone = TimeZone.getDefault();
    public static Locale defaultLocale = Locale.getDefault();
    public static String DEFAULT_TYPE_KEY = "@type";
    static final SerializeFilter[] emptyFilters = new SerializeFilter[0];
    public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static int DEFAULT_PARSER_FEATURE;
    public static int DEFAULT_GENERATE_FEATURE;
    private static final ConcurrentHashMap<Type, Type> mixInsMapper;
    private static final ThreadLocal<byte[]> bytesLocal;
    private static final ThreadLocal<char[]> charsLocal;
    public static final String VERSION = "1.2.70";

    private static void config(Properties properties) {
        String string = properties.getProperty("fastjson.serializerFeatures.MapSortField");
        int n2 = SerializerFeature.MapSortField.getMask();
        if ("true".equals(string)) {
            DEFAULT_GENERATE_FEATURE |= n2;
        } else if ("false".equals(string)) {
            DEFAULT_GENERATE_FEATURE &= ~n2;
        }
        if ("true".equals(properties.getProperty("parser.features.NonStringKeyAsString"))) {
            DEFAULT_PARSER_FEATURE |= Feature.NonStringKeyAsString.getMask();
        }
        if ("true".equals(properties.getProperty("parser.features.ErrorOnEnumNotMatch")) || "true".equals(properties.getProperty("fastjson.parser.features.ErrorOnEnumNotMatch"))) {
            DEFAULT_PARSER_FEATURE |= Feature.ErrorOnEnumNotMatch.getMask();
        }
        if ("false".equals(properties.getProperty("fastjson.asmEnable"))) {
            ParserConfig.getGlobalInstance().setAsmEnable(false);
            SerializeConfig.getGlobalInstance().setAsmEnable(false);
        }
    }

    public static void setDefaultTypeKey(String string) {
        DEFAULT_TYPE_KEY = string;
        ParserConfig.global.symbolTable.addSymbol(string, 0, string.length(), string.hashCode(), true);
    }

    public static Object parse(String string) {
        return JSON.parse(string, DEFAULT_PARSER_FEATURE);
    }

    public static Object parse(String string, ParserConfig parserConfig) {
        return JSON.parse(string, parserConfig, DEFAULT_PARSER_FEATURE);
    }

    public static Object parse(String string, ParserConfig parserConfig, Feature ... featureArray) {
        int n2 = DEFAULT_PARSER_FEATURE;
        for (Feature feature : featureArray) {
            n2 = Feature.config(n2, feature, true);
        }
        return JSON.parse(string, parserConfig, n2);
    }

    public static Object parse(String string, ParserConfig parserConfig, int n2) {
        if (string == null) {
            return null;
        }
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(string, parserConfig, n2);
        Object object = defaultJSONParser.parse();
        defaultJSONParser.handleResovleTask(object);
        defaultJSONParser.close();
        return object;
    }

    public static Object parse(String string, int n2) {
        return JSON.parse(string, ParserConfig.getGlobalInstance(), n2);
    }

    public static Object parse(byte[] byArray, Feature ... featureArray) {
        char[] cArray = JSON.allocateChars(byArray.length);
        int n2 = IOUtils.decodeUTF8(byArray, 0, byArray.length, cArray);
        if (n2 < 0) {
            return null;
        }
        return JSON.parse(new String(cArray, 0, n2), featureArray);
    }

    public static Object parse(byte[] byArray, int n2, int n3, CharsetDecoder charsetDecoder, Feature ... featureArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n4 = DEFAULT_PARSER_FEATURE;
        for (Feature feature : featureArray) {
            n4 = Feature.config(n4, feature, true);
        }
        return JSON.parse(byArray, n2, n3, charsetDecoder, n4);
    }

    public static Object parse(byte[] byArray, int n2, int n3, CharsetDecoder charsetDecoder, int n4) {
        charsetDecoder.reset();
        int n5 = (int)((double)n3 * (double)charsetDecoder.maxCharsPerByte());
        char[] cArray = JSON.allocateChars(n5);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        IOUtils.decode(charsetDecoder, byteBuffer, charBuffer);
        int n6 = charBuffer.position();
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(cArray, n6, ParserConfig.getGlobalInstance(), n4);
        Object object = defaultJSONParser.parse();
        defaultJSONParser.handleResovleTask(object);
        defaultJSONParser.close();
        return object;
    }

    public static Object parse(String string, Feature ... featureArray) {
        int n2 = DEFAULT_PARSER_FEATURE;
        for (Feature feature : featureArray) {
            n2 = Feature.config(n2, feature, true);
        }
        return JSON.parse(string, n2);
    }

    public static JSONObject parseObject(String string, Feature ... featureArray) {
        return (JSONObject)JSON.parse(string, featureArray);
    }

    public static JSONObject parseObject(String string) {
        Object object = JSON.parse(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        try {
            return (JSONObject)JSON.toJSON(object);
        }
        catch (RuntimeException runtimeException) {
            throw new JSONException("can not cast to JSONObject.", runtimeException);
        }
    }

    public static <T> T parseObject(String string, TypeReference<T> typeReference, Feature ... featureArray) {
        return JSON.parseObject(string, typeReference.type, ParserConfig.global, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(String string, Class<T> clazz, Feature ... featureArray) {
        return JSON.parseObject(string, clazz, ParserConfig.global, null, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(String string, Class<T> clazz, ParseProcess parseProcess, Feature ... featureArray) {
        return JSON.parseObject(string, clazz, ParserConfig.global, parseProcess, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(String string, Type type, Feature ... featureArray) {
        return JSON.parseObject(string, type, ParserConfig.global, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(String string, Type type, ParseProcess parseProcess, Feature ... featureArray) {
        return JSON.parseObject(string, type, ParserConfig.global, parseProcess, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(String string, Type type, int n2, Feature ... featureArray) {
        if (string == null) {
            return null;
        }
        for (Feature feature : featureArray) {
            n2 = Feature.config(n2, feature, true);
        }
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(string, ParserConfig.getGlobalInstance(), n2);
        Object t2 = defaultJSONParser.parseObject(type);
        defaultJSONParser.handleResovleTask(t2);
        defaultJSONParser.close();
        return t2;
    }

    public static <T> T parseObject(String string, Type type, ParserConfig parserConfig, Feature ... featureArray) {
        return JSON.parseObject(string, type, parserConfig, null, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(String string, Type type, ParserConfig parserConfig, int n2, Feature ... featureArray) {
        return JSON.parseObject(string, type, parserConfig, null, n2, featureArray);
    }

    public static <T> T parseObject(String string, Type type, ParserConfig parserConfig, ParseProcess parseProcess, int n2, Feature ... featureArray) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (featureArray != null) {
            for (Feature feature : featureArray) {
                n2 |= feature.mask;
            }
        }
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(string, parserConfig, n2);
        if (parseProcess != null) {
            if (parseProcess instanceof ExtraTypeProvider) {
                defaultJSONParser.getExtraTypeProviders().add((ExtraTypeProvider)parseProcess);
            }
            if (parseProcess instanceof ExtraProcessor) {
                defaultJSONParser.getExtraProcessors().add((ExtraProcessor)parseProcess);
            }
            if (parseProcess instanceof FieldTypeResolver) {
                defaultJSONParser.setFieldTypeResolver((FieldTypeResolver)parseProcess);
            }
        }
        Object t2 = defaultJSONParser.parseObject(type, null);
        defaultJSONParser.handleResovleTask(t2);
        defaultJSONParser.close();
        return t2;
    }

    public static <T> T parseObject(byte[] byArray, Type type, Feature ... featureArray) {
        return JSON.parseObject(byArray, 0, byArray.length, IOUtils.UTF8, type, featureArray);
    }

    public static <T> T parseObject(byte[] byArray, int n2, int n3, Charset charset, Type type, Feature ... featureArray) {
        return JSON.parseObject(byArray, n2, n3, charset, type, ParserConfig.global, null, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(byte[] byArray, Charset charset, Type type, ParserConfig parserConfig, ParseProcess parseProcess, int n2, Feature ... featureArray) {
        return JSON.parseObject(byArray, 0, byArray.length, charset, type, parserConfig, parseProcess, n2, featureArray);
    }

    public static <T> T parseObject(byte[] byArray, int n2, int n3, Charset charset, Type type, ParserConfig parserConfig, ParseProcess parseProcess, int n4, Feature ... featureArray) {
        String string;
        if (charset == null) {
            charset = IOUtils.UTF8;
        }
        if (charset == IOUtils.UTF8) {
            char[] cArray = JSON.allocateChars(byArray.length);
            int n5 = IOUtils.decodeUTF8(byArray, n2, n3, cArray);
            if (n5 < 0) {
                return null;
            }
            string = new String(cArray, 0, n5);
        } else {
            if (n3 < 0) {
                return null;
            }
            string = new String(byArray, n2, n3, charset);
        }
        return JSON.parseObject(string, type, parserConfig, parseProcess, n4, featureArray);
    }

    public static <T> T parseObject(byte[] byArray, int n2, int n3, CharsetDecoder charsetDecoder, Type type, Feature ... featureArray) {
        charsetDecoder.reset();
        int n4 = (int)((double)n3 * (double)charsetDecoder.maxCharsPerByte());
        char[] cArray = JSON.allocateChars(n4);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        IOUtils.decode(charsetDecoder, byteBuffer, charBuffer);
        int n5 = charBuffer.position();
        return JSON.parseObject(cArray, n5, type, featureArray);
    }

    public static <T> T parseObject(char[] cArray, int n2, Type type, Feature ... featureArray) {
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        int n3 = DEFAULT_PARSER_FEATURE;
        for (Feature feature : featureArray) {
            n3 = Feature.config(n3, feature, true);
        }
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(cArray, n2, ParserConfig.getGlobalInstance(), n3);
        Object t2 = defaultJSONParser.parseObject(type);
        defaultJSONParser.handleResovleTask(t2);
        defaultJSONParser.close();
        return t2;
    }

    public static <T> T parseObject(InputStream inputStream, Type type, Feature ... featureArray) throws IOException {
        return JSON.parseObject(inputStream, IOUtils.UTF8, type, featureArray);
    }

    public static <T> T parseObject(InputStream inputStream, Charset charset, Type type, Feature ... featureArray) throws IOException {
        return JSON.parseObject(inputStream, charset, type, ParserConfig.global, featureArray);
    }

    public static <T> T parseObject(InputStream inputStream, Charset charset, Type type, ParserConfig parserConfig, Feature ... featureArray) throws IOException {
        return JSON.parseObject(inputStream, charset, type, parserConfig, null, DEFAULT_PARSER_FEATURE, featureArray);
    }

    public static <T> T parseObject(InputStream inputStream, Charset charset, Type type, ParserConfig parserConfig, ParseProcess parseProcess, int n2, Feature ... featureArray) throws IOException {
        int n3;
        if (charset == null) {
            charset = IOUtils.UTF8;
        }
        byte[] byArray = JSON.allocateBytes(65536);
        int n4 = 0;
        while ((n3 = inputStream.read(byArray, n4, byArray.length - n4)) != -1) {
            if ((n4 += n3) != byArray.length) continue;
            byte[] byArray2 = new byte[byArray.length * 3 / 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        return JSON.parseObject(byArray, 0, n4, charset, type, parserConfig, parseProcess, n2, featureArray);
    }

    public static <T> T parseObject(String string, Class<T> clazz) {
        return JSON.parseObject(string, clazz, new Feature[0]);
    }

    public static JSONArray parseArray(String string) {
        JSONArray jSONArray;
        if (string == null) {
            return null;
        }
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(string, ParserConfig.getGlobalInstance());
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 8) {
            jSONLexer.nextToken();
            jSONArray = null;
        } else if (jSONLexer.token() == 20) {
            jSONArray = null;
        } else {
            jSONArray = new JSONArray();
            defaultJSONParser.parseArray(jSONArray);
            defaultJSONParser.handleResovleTask(jSONArray);
        }
        defaultJSONParser.close();
        return jSONArray;
    }

    public static <T> List<T> parseArray(String string, Class<T> clazz) {
        ArrayList arrayList;
        if (string == null) {
            return null;
        }
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(string, ParserConfig.getGlobalInstance());
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n2 = jSONLexer.token();
        if (n2 == 8) {
            jSONLexer.nextToken();
            arrayList = null;
        } else if (n2 == 20 && jSONLexer.isBlankInput()) {
            arrayList = null;
        } else {
            arrayList = new ArrayList();
            defaultJSONParser.parseArray(clazz, arrayList);
            defaultJSONParser.handleResovleTask(arrayList);
        }
        defaultJSONParser.close();
        return arrayList;
    }

    public static List<Object> parseArray(String string, Type[] typeArray) {
        if (string == null) {
            return null;
        }
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(string, ParserConfig.getGlobalInstance());
        Object[] objectArray = defaultJSONParser.parseArray(typeArray);
        List<Object> list = objectArray == null ? null : Arrays.asList(objectArray);
        defaultJSONParser.handleResovleTask(list);
        defaultJSONParser.close();
        return list;
    }

    public static String toJSONString(Object object) {
        return JSON.toJSONString(object, emptyFilters, new SerializerFeature[0]);
    }

    public static String toJSONString(Object object, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJSONString(Object object, int n2, SerializerFeature ... serializerFeatureArray) {
        try (SerializeWriter serializeWriter = new SerializeWriter((Writer)null, n2, serializerFeatureArray);){
            JSONSerializer jSONSerializer = new JSONSerializer(serializeWriter);
            jSONSerializer.write(object);
            String string = serializeWriter.toString();
            return string;
        }
    }

    public static String toJSONStringWithDateFormat(Object object, String string, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, null, string, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeFilter serializeFilter, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, new SerializeFilter[]{serializeFilter}, null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeFilter[] serializeFilterArray, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, serializeFilterArray, null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter serializeFilter, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, new SerializeFilter[]{serializeFilter}, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, int n2, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, n2, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeConfig serializeConfig, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, serializeConfig, (SerializeFilter)null, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeConfig serializeConfig, SerializeFilter serializeFilter, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, serializeConfig, new SerializeFilter[]{serializeFilter}, null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static String toJSONString(Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, serializeConfig, serializeFilterArray, null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJSONString(Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n2, SerializerFeature ... serializerFeatureArray) {
        try (SerializeWriter serializeWriter = new SerializeWriter(null, n2, serializerFeatureArray);){
            JSONSerializer jSONSerializer = new JSONSerializer(serializeWriter, serializeConfig);
            if (string != null && string.length() != 0) {
                jSONSerializer.setDateFormat(string);
                jSONSerializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            if (serializeFilterArray != null) {
                for (SerializeFilter serializeFilter : serializeFilterArray) {
                    jSONSerializer.addFilter(serializeFilter);
                }
            }
            jSONSerializer.write(object);
            String string2 = serializeWriter.toString();
            return string2;
        }
    }

    public static String toJSONStringZ(Object object, SerializeConfig serializeConfig, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONString(object, serializeConfig, emptyFilters, null, 0, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, serializeConfig, emptyFilters, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, int n2, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, serializeConfig, emptyFilters, n2, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter[] serializeFilterArray, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, SerializeConfig.globalInstance, serializeFilterArray, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, SerializeFilter serializeFilter, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, serializeConfig, new SerializeFilter[]{serializeFilter}, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, int n2, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(object, serializeConfig, serializeFilterArray, null, n2, serializerFeatureArray);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n2, SerializerFeature ... serializerFeatureArray) {
        return JSON.toJSONBytes(IOUtils.UTF8, object, serializeConfig, serializeFilterArray, string, n2, serializerFeatureArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toJSONBytes(Charset charset, Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n2, SerializerFeature ... serializerFeatureArray) {
        try (SerializeWriter serializeWriter = new SerializeWriter(null, n2, serializerFeatureArray);){
            JSONSerializer jSONSerializer = new JSONSerializer(serializeWriter, serializeConfig);
            if (string != null && string.length() != 0) {
                jSONSerializer.setDateFormat(string);
                jSONSerializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            if (serializeFilterArray != null) {
                for (SerializeFilter serializeFilter : serializeFilterArray) {
                    jSONSerializer.addFilter(serializeFilter);
                }
            }
            jSONSerializer.write(object);
            byte[] byArray = serializeWriter.toBytes(charset);
            return byArray;
        }
    }

    public static String toJSONString(Object object, boolean bl) {
        if (!bl) {
            return JSON.toJSONString(object);
        }
        return JSON.toJSONString(object, SerializerFeature.PrettyFormat);
    }

    public static void writeJSONStringTo(Object object, Writer writer, SerializerFeature ... serializerFeatureArray) {
        JSON.writeJSONString(writer, object, serializerFeatureArray);
    }

    public static void writeJSONString(Writer writer, Object object, SerializerFeature ... serializerFeatureArray) {
        JSON.writeJSONString(writer, object, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJSONString(Writer writer, Object object, int n2, SerializerFeature ... serializerFeatureArray) {
        try (SerializeWriter serializeWriter = new SerializeWriter(writer, n2, serializerFeatureArray);){
            JSONSerializer jSONSerializer = new JSONSerializer(serializeWriter);
            jSONSerializer.write(object);
        }
    }

    public static final int writeJSONString(OutputStream outputStream, Object object, SerializerFeature ... serializerFeatureArray) throws IOException {
        return JSON.writeJSONString(outputStream, object, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    public static final int writeJSONString(OutputStream outputStream, Object object, int n2, SerializerFeature ... serializerFeatureArray) throws IOException {
        return JSON.writeJSONString(outputStream, IOUtils.UTF8, object, SerializeConfig.globalInstance, null, null, n2, serializerFeatureArray);
    }

    public static final int writeJSONString(OutputStream outputStream, Charset charset, Object object, SerializerFeature ... serializerFeatureArray) throws IOException {
        return JSON.writeJSONString(outputStream, charset, object, SerializeConfig.globalInstance, null, null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int writeJSONString(OutputStream outputStream, Charset charset, Object object, SerializeConfig serializeConfig, SerializeFilter[] serializeFilterArray, String string, int n2, SerializerFeature ... serializerFeatureArray) throws IOException {
        try (SerializeWriter serializeWriter = new SerializeWriter(null, n2, serializerFeatureArray);){
            int n3;
            JSONSerializer jSONSerializer = new JSONSerializer(serializeWriter, serializeConfig);
            if (string != null && string.length() != 0) {
                jSONSerializer.setDateFormat(string);
                jSONSerializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            if (serializeFilterArray != null) {
                for (SerializeFilter serializeFilter : serializeFilterArray) {
                    jSONSerializer.addFilter(serializeFilter);
                }
            }
            jSONSerializer.write(object);
            int n4 = n3 = serializeWriter.writeToEx(outputStream, charset);
            return n4;
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        try (SerializeWriter serializeWriter = new SerializeWriter();){
            new JSONSerializer(serializeWriter).write(this);
            String string = serializeWriter.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(SerializerFeature ... serializerFeatureArray) {
        try (SerializeWriter serializeWriter = new SerializeWriter(null, DEFAULT_GENERATE_FEATURE, serializerFeatureArray);){
            new JSONSerializer(serializeWriter).write(this);
            String string = serializeWriter.toString();
            return string;
        }
    }

    @Override
    public void writeJSONString(Appendable appendable) {
        try (SerializeWriter serializeWriter = new SerializeWriter();){
            new JSONSerializer(serializeWriter).write(this);
            appendable.append(serializeWriter.toString());
        }
    }

    public static Object toJSON(Object object) {
        return JSON.toJSON(object, SerializeConfig.globalInstance);
    }

    public static Object toJSON(Object object, ParserConfig parserConfig) {
        return JSON.toJSON(object, SerializeConfig.globalInstance);
    }

    public static Object toJSON(Object object, SerializeConfig serializeConfig) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSON) {
            return object;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            int n2 = map.size();
            AbstractMap abstractMap = map instanceof LinkedHashMap ? new LinkedHashMap(n2) : (map instanceof TreeMap ? new TreeMap() : new HashMap(n2));
            JSONObject jSONObject = new JSONObject(abstractMap);
            for (Map.Entry entry : map.entrySet()) {
                Object k2 = entry.getKey();
                String string = TypeUtils.castToString(k2);
                Object object2 = JSON.toJSON(entry.getValue(), serializeConfig);
                jSONObject.put(string, object2);
            }
            return jSONObject;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            JSONArray jSONArray = new JSONArray(collection.size());
            for (Object e2 : collection) {
                Object object3 = JSON.toJSON(e2, serializeConfig);
                jSONArray.add(object3);
            }
            return jSONArray;
        }
        if (object instanceof JSONSerializable) {
            String string = JSON.toJSONString(object);
            return JSON.parse(string);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isEnum()) {
            return ((Enum)object).name();
        }
        if (clazz.isArray()) {
            int n3 = Array.getLength(object);
            JSONArray jSONArray = new JSONArray(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object4 = Array.get(object, i2);
                Object object5 = JSON.toJSON(object4);
                jSONArray.add(object5);
            }
            return jSONArray;
        }
        if (ParserConfig.isPrimitive2(clazz)) {
            return object;
        }
        ObjectSerializer objectSerializer = serializeConfig.getObjectWriter(clazz);
        if (objectSerializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)objectSerializer;
            JSONObject jSONObject = new JSONObject();
            try {
                Map<String, Object> map = javaBeanSerializer.getFieldValuesMap(object);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    jSONObject.put(entry.getKey(), JSON.toJSON(entry.getValue(), serializeConfig));
                }
            }
            catch (Exception exception) {
                throw new JSONException("toJSON error", exception);
            }
            return jSONObject;
        }
        String string = JSON.toJSONString(object);
        return JSON.parse(string);
    }

    public static <T> T toJavaObject(JSON jSON, Class<T> clazz) {
        return TypeUtils.cast((Object)jSON, clazz, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz == JSONArray.class || clazz == JSON.class || clazz == Collection.class || clazz == List.class) {
            return (T)this;
        }
        return TypeUtils.cast((Object)this, clazz, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(Type type) {
        return TypeUtils.cast((Object)this, type, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(TypeReference typeReference) {
        Type type = typeReference != null ? typeReference.getType() : null;
        return TypeUtils.cast((Object)this, type, ParserConfig.getGlobalInstance());
    }

    private static byte[] allocateBytes(int n2) {
        byte[] byArray = bytesLocal.get();
        if (byArray == null) {
            if (n2 <= 65536) {
                byArray = new byte[65536];
                bytesLocal.set(byArray);
            } else {
                byArray = new byte[n2];
            }
        } else if (byArray.length < n2) {
            byArray = new byte[n2];
        }
        return byArray;
    }

    private static char[] allocateChars(int n2) {
        char[] cArray = charsLocal.get();
        if (cArray == null) {
            if (n2 <= 65536) {
                cArray = new char[65536];
                charsLocal.set(cArray);
            } else {
                cArray = new char[n2];
            }
        } else if (cArray.length < n2) {
            cArray = new char[n2];
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        try (JSONScanner jSONScanner = new JSONScanner(string);){
            jSONScanner.nextToken();
            int n2 = jSONScanner.token();
            switch (n2) {
                case 12: {
                    if (jSONScanner.getCurrent() == '\u001a') {
                        boolean bl = false;
                        return bl;
                    }
                    jSONScanner.skipObject(true);
                    break;
                }
                case 14: {
                    jSONScanner.skipArray(true);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    jSONScanner.nextToken();
                    break;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = jSONScanner.token() == 20;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidObject(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        try (JSONScanner jSONScanner = new JSONScanner(string);){
            jSONScanner.nextToken();
            int n2 = jSONScanner.token();
            if (n2 == 12) {
                if (jSONScanner.getCurrent() == '\u001a') {
                    boolean bl = false;
                    return bl;
                }
                jSONScanner.skipObject(true);
                boolean bl = jSONScanner.token() == 20;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidArray(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        try (JSONScanner jSONScanner = new JSONScanner(string);){
            jSONScanner.nextToken();
            int n2 = jSONScanner.token();
            if (n2 == 14) {
                jSONScanner.skipArray(true);
                boolean bl = jSONScanner.token() == 20;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static <T> void handleResovleTask(DefaultJSONParser defaultJSONParser, T t2) {
        defaultJSONParser.handleResovleTask(t2);
    }

    public static void addMixInAnnotations(Type type, Type type2) {
        if (type != null && type2 != null) {
            mixInsMapper.put(type, type2);
        }
    }

    public static void removeMixInAnnotations(Type type) {
        if (type != null) {
            mixInsMapper.remove(type);
        }
    }

    public static void clearMixInAnnotations() {
        mixInsMapper.clear();
    }

    public static Type getMixInAnnotations(Type type) {
        if (type != null) {
            return mixInsMapper.get(type);
        }
        return null;
    }

    static {
        mixInsMapper = new ConcurrentHashMap(16);
        int n2 = 0;
        n2 |= Feature.AutoCloseSource.getMask();
        n2 |= Feature.InternFieldNames.getMask();
        n2 |= Feature.UseBigDecimal.getMask();
        n2 |= Feature.AllowUnQuotedFieldNames.getMask();
        n2 |= Feature.AllowSingleQuotes.getMask();
        n2 |= Feature.AllowArbitraryCommas.getMask();
        n2 |= Feature.SortFeidFastMatch.getMask();
        DEFAULT_PARSER_FEATURE = n2 |= Feature.IgnoreNotMatch.getMask();
        n2 = 0;
        n2 |= SerializerFeature.QuoteFieldNames.getMask();
        n2 |= SerializerFeature.SkipTransientField.getMask();
        n2 |= SerializerFeature.WriteEnumUsingName.getMask();
        DEFAULT_GENERATE_FEATURE = n2 |= SerializerFeature.SortField.getMask();
        JSON.config(IOUtils.DEFAULT_PROPERTIES);
        bytesLocal = new ThreadLocal();
        charsLocal = new ThreadLocal();
    }
}

