/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sheca.safeengine.CertIsRevoke;
import com.sheca.safeengine.FetchCRL;
import com.sheca.safeengine.ParseCertificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.Vector;
import org.bouncycastle.util.encoders.Base64;

class CertIsRevokeFromLocalLdap
extends CertIsRevoke {
    CertIsRevokeFromLocalLdap() {
    }

    @Override
    public byte[] fetchDPN(String sDPN) {
        return FetchCRL.getCRL(sDPN);
    }

    @Override
    public void showError() {
        System.err.println("crlIsRevocked getCRL error : local ldap server error!");
    }

    @Override
    public String[] getDPNs(X509Certificate oCert) {
        String[] dpns = ParseCertificate.getCRLDPN(oCert);
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < dpns.length) {
            String tmp = dpns[i].toLowerCase();
            int n = tmp.indexOf(63);
            if (tmp.startsWith("ldap://")) {
                result.add(tmp);
            }
            ++i;
        }
        String strBase = null;
        try {
            Properties prop = new Properties();
            prop.load(this.getClass().getClassLoader().getResourceAsStream("sheca.properties"));
            strBase = prop.getProperty("URL");
        }
        catch (Exception ex) {
            System.err.println("crlIsRevocked getCRL error : local ldap server is not exist;!");
            return null;
        }
        String[] arrRtn = new String[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            String strCN = (String)result.get(i2);
            if (strCN.indexOf("/didms/") > -1) {
                String[] tmpstr = strCN.split("/didms/");
                strCN = String.valueOf(tmpstr[0]) + "/ou=didms,ou=sheca crl,o=sheca.com??sub?(cn=" + tmpstr[1] + ")";
                if ((strCN = new String(Base64.encode((byte[])strCN.getBytes()))).indexOf("+") > -1) {
                    strCN = strCN.replaceAll("+", "");
                }
                if (strCN.indexOf("/") > -1) {
                    strCN = strCN.replaceAll("/", "");
                }
                if (strCN.indexOf("\r") > -1) {
                    strCN = strCN.replaceAll("\r", "");
                }
                if (strCN.indexOf("/n") > -1) {
                    strCN = strCN.replaceAll("\n", "");
                }
                arrRtn[i2] = String.valueOf(strBase) + "??SUB?(cn=" + strCN + ")";
            } else if (strCN.indexOf("ldap2.sheca.com") > -1) {
                arrRtn[i2] = strCN;
            } else {
                if ((strCN = new String(Base64.encode((byte[])strCN.getBytes()))).indexOf("+") > -1) {
                    strCN = strCN.replaceAll("+", "");
                }
                if (strCN.indexOf("/") > -1) {
                    strCN = strCN.replaceAll("/", "");
                }
                if (strCN.indexOf("\r") > -1) {
                    strCN = strCN.replaceAll("\r", "");
                }
                if (strCN.indexOf("/n") > -1) {
                    strCN = strCN.replaceAll("\n", "");
                }
                arrRtn[i2] = String.valueOf(strBase) + "??SUB?(cn=" + strCN + ")";
            }
            ++i2;
        }
        return arrRtn;
    }
}

