/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.ini;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.StringTokenizer;

public final class MACAddressUtil {
    public static final String getMacAddress() throws IOException {
        String os = System.getProperty("os.name");
        try {
            if (os.startsWith("Windows")) {
                return MACAddressUtil.windowsParseMacAddress(MACAddressUtil.windowsRunIpConfigCommand());
            }
            if (os.startsWith("Linux")) {
                return MACAddressUtil.linuxParseMacAddress(MACAddressUtil.linuxRunIfConfigCommand());
            }
            throw new IOException("unknown operating system: " + os);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    private static final String linuxParseMacAddress(String ipConfigResponse) throws ParseException {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.getMessage(), 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            boolean containsLocalHost;
            String line = tokenizer.nextToken().trim();
            boolean bl = containsLocalHost = line.indexOf(localHost) >= 0;
            if (containsLocalHost && lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf("HWaddr");
            if (macAddressPosition <= 0 || !MACAddressUtil.linuxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ParseException ex = new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    private static final boolean linuxIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static final String linuxRunIfConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ifconfig");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String windowsParseMacAddress(String ipConfigResponse) throws ParseException {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.getMessage(), 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            if (line.endsWith(localHost) && lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf(":");
            if (macAddressPosition <= 0 || !MACAddressUtil.windowsIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 1).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ParseException ex = new ParseException("cannot read MAC address from [" + ipConfigResponse + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    private static final boolean windowsIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static final String windowsRunIpConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ipconfig /all");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    public static final void main(String[] args) {
        try {
            System.out.println("Network infos");
            System.out.println("  Operating System: " + System.getProperty("os.name"));
            System.out.println("  IP/Localhost: " + InetAddress.getLocalHost().getHostAddress());
            System.out.println("  MAC Address: " + MACAddressUtil.getMacAddress());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

