/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.cms;

import com.cfca.util.pki.asn1.ASN1Encodable;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERTaggedObject;
import com.cfca.util.pki.asn1.cms.KEKRecipientInfo;
import com.cfca.util.pki.asn1.cms.KeyAgreeRecipientInfo;
import com.cfca.util.pki.asn1.cms.KeyTransRecipientInfo;
import com.cfca.util.pki.asn1.cms.OtherRecipientInfo;
import com.cfca.util.pki.asn1.cms.PasswordRecipientInfo;

public class RecipientInfo
extends ASN1Encodable {
    DEREncodable info;

    public RecipientInfo(KeyTransRecipientInfo info) {
        this.info = info;
    }

    public RecipientInfo(KeyAgreeRecipientInfo info) {
        this.info = new DERTaggedObject(false, 1, info);
    }

    public RecipientInfo(KEKRecipientInfo info) {
        this.info = new DERTaggedObject(false, 2, info);
    }

    public RecipientInfo(PasswordRecipientInfo info) {
        this.info = new DERTaggedObject(false, 3, info);
    }

    public RecipientInfo(OtherRecipientInfo info) {
        this.info = new DERTaggedObject(false, 4, info);
    }

    public RecipientInfo(DERObject info) {
        this.info = info;
    }

    public static RecipientInfo getInstance(Object o) {
        if (o == null || o instanceof RecipientInfo) {
            return (RecipientInfo)o;
        }
        if (o instanceof ASN1Sequence) {
            return new RecipientInfo((ASN1Sequence)o);
        }
        if (o instanceof ASN1TaggedObject) {
            return new RecipientInfo((ASN1TaggedObject)o);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o.getClass().getName());
    }

    public DERInteger getVersion() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject o = (ASN1TaggedObject)this.info;
            switch (o.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(o, false).getVersion();
                }
                case 2: {
                    return this.getKEKInfo(o).getVersion();
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(o, false).getVersion();
                }
                case 4: {
                    return new DERInteger(0);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info).getVersion();
    }

    public boolean isTagged() {
        return this.info instanceof ASN1TaggedObject;
    }

    public DEREncodable getInfo() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject o = (ASN1TaggedObject)this.info;
            switch (o.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(o, false);
                }
                case 2: {
                    return this.getKEKInfo(o);
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(o, false);
                }
                case 4: {
                    return OtherRecipientInfo.getInstance(o, false);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info);
    }

    private KEKRecipientInfo getKEKInfo(ASN1TaggedObject o) {
        if (o.isExplicit()) {
            return KEKRecipientInfo.getInstance(o, true);
        }
        return KEKRecipientInfo.getInstance(o, false);
    }

    public DERObject toASN1Object() {
        return this.info.getDERObject();
    }
}

