/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.pkcs.pkcs12;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.DERTaggedObject;

public class CertBag
implements DEREncodable {
    private DERObjectIdentifier certId;
    private DERObject certValue;

    public static CertBag getInstance(Object o) {
        if (o == null || o instanceof CertBag) {
            return (CertBag)o;
        }
        if (o instanceof ASN1Sequence) {
            return new CertBag((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory " + o.getClass().getName());
    }

    public CertBag(ASN1Sequence seq) {
        this.certId = (DERObjectIdentifier)seq.getObjectAt(0);
        this.certValue = ((DERTaggedObject)seq.getObjectAt(1)).getObject();
    }

    public CertBag(DERObjectIdentifier certId, DERObject certValue) {
        this.certId = certId;
        this.certValue = certValue;
    }

    public DERObjectIdentifier getCertId() {
        return this.certId;
    }

    public DERObject getCertValue() {
        return this.certValue;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certId);
        v.add(new DERTaggedObject(0, this.certValue));
        return new DERSequence(v);
    }
}

