/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.pkcs.pkcs7;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.pkcs.pkcs7.EncryptedContentInfo;

public class EncryptedData
implements DEREncodable {
    private DERInteger version;
    private EncryptedContentInfo encryptedContentInfo;

    public static EncryptedData getInstance(Object o) {
        if (o == null || o instanceof EncryptedData) {
            return (EncryptedData)o;
        }
        if (o instanceof ASN1Sequence) {
            return new EncryptedData((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory:" + o.getClass().getName());
    }

    public EncryptedData(DERInteger _version, EncryptedContentInfo _encryptedContentInfo) {
        this.version = _version;
        this.encryptedContentInfo = _encryptedContentInfo;
    }

    public EncryptedData(ASN1Sequence seq) {
        this.version = (DERInteger)seq.getObjectAt(0);
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(seq.getObjectAt(1));
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.encryptedContentInfo);
        return new DERSequence(v);
    }
}

