/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.pkcs.pkcs7;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.x509.X509Name;
import java.math.BigInteger;

public class IssuerAndSerialNumber
implements DEREncodable {
    private X509Name name;
    private DERInteger certSerialNumber;

    public static IssuerAndSerialNumber getInstance(Object obj) {
        if (obj instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new IssuerAndSerialNumber((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public IssuerAndSerialNumber(ASN1Sequence seq) {
        this.name = X509Name.getInstance(seq.getObjectAt(0));
        this.certSerialNumber = (DERInteger)seq.getObjectAt(1);
    }

    public IssuerAndSerialNumber(X509Name name, BigInteger certSerialNumber) {
        this.name = name;
        this.certSerialNumber = new DERInteger(certSerialNumber);
    }

    public IssuerAndSerialNumber(X509Name name, DERInteger certSerialNumber) {
        this.name = name;
        this.certSerialNumber = certSerialNumber;
    }

    public X509Name getName() {
        return this.name;
    }

    public DERInteger getCertificateSerialNumber() {
        return this.certSerialNumber;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.name);
        v.add(this.certSerialNumber);
        return new DERSequence(v);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IssuerAndSerialNumber)) {
            return false;
        }
        IssuerAndSerialNumber tmp = IssuerAndSerialNumber.getInstance(obj);
        if (!tmp.getCertificateSerialNumber().equals(this.getCertificateSerialNumber())) {
            return false;
        }
        return tmp.getName().equals(this.getName());
    }
}

