/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.pkcs.pkcs8;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class EncryptedPrivateKeyInfo
implements PKCSObjectIdentifiers,
DEREncodable {
    private AlgorithmIdentifier encryptionAlgId;
    private ASN1OctetString encryptedData;

    public EncryptedPrivateKeyInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.encryptionAlgId = new AlgorithmIdentifier((ASN1Sequence)e.nextElement());
        this.encryptedData = (ASN1OctetString)e.nextElement();
    }

    public EncryptedPrivateKeyInfo(AlgorithmIdentifier algId, byte[] encoding) {
        this.encryptionAlgId = algId;
        this.encryptedData = new DEROctetString(encoding);
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.encryptionAlgId;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData.getOctets();
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.encryptionAlgId);
        v.add(this.encryptedData);
        return new DERSequence(v);
    }
}

