/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.x509.CRLEntry;
import com.cfca.util.pki.asn1.x509.Time;
import com.cfca.util.pki.asn1.x509.X509Extensions;

public class CRLEntryGenerator {
    private DERInteger userCertificate = null;
    private Time revocationDate = null;
    private X509Extensions crlEntryExtensions = null;

    public void setUserCertificate(DERInteger CertSerialNumber) {
        this.userCertificate = CertSerialNumber;
    }

    public void setRevocationDate(Time revocationDate) {
        this.revocationDate = revocationDate;
    }

    public void setCrlEntryExtensions(X509Extensions crlEntryExtensions) {
        this.crlEntryExtensions = crlEntryExtensions;
    }

    public CRLEntry generateCRLEntry() throws Exception {
        if (this.userCertificate == null || this.revocationDate == null) {
            throw new Exception("userCertificate and revocationDate must be set");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.userCertificate);
        v.add(this.revocationDate);
        if (this.crlEntryExtensions != null) {
            v.add(this.crlEntryExtensions);
        }
        DERSequence seq = new DERSequence(v);
        return new CRLEntry(seq);
    }
}

