/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1Encodable;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERTaggedObject;

public class DistributionPointName
extends ASN1Encodable {
    DEREncodable name;
    int type;
    public static final int FULL_NAME = 0;
    public static final int NAME_RELATIVE_TO_CRL_ISSUER = 1;

    public static DistributionPointName getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DistributionPointName.getInstance(ASN1TaggedObject.getInstance(obj, explicit));
    }

    public static DistributionPointName getInstance(Object obj) {
        if (obj == null || obj instanceof DistributionPointName) {
            return (DistributionPointName)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return new DistributionPointName((ASN1TaggedObject)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DistributionPointName(int type, DEREncodable name) {
        this.type = type;
        this.name = name;
    }

    public DistributionPointName(ASN1TaggedObject obj) {
        this.type = obj.getTagNo();
        this.name = this.type == 0 ? ASN1Sequence.getInstance(obj, false) : ASN1Set.getInstance(obj, false);
    }

    public DERObject toASN1Object() {
        return new DERTaggedObject(false, this.type, this.name);
    }
}

