/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DERBoolean;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSequence;

public class Extension
implements DEREncodable {
    private DERObjectIdentifier extnID = null;
    private DERBoolean critical = new DERBoolean(false);
    private ASN1OctetString extnValue = null;

    public Extension(DERObjectIdentifier extnID, ASN1OctetString extnValue) {
        this.extnID = extnID;
        this.extnValue = extnValue;
    }

    public Extension(DERObjectIdentifier extnID, DERBoolean critical, ASN1OctetString extnValue) {
        this.extnID = extnID;
        this.critical = critical;
        this.extnValue = extnValue;
    }

    public Extension(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.extnID = DERObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.extnValue = ASN1OctetString.getInstance(seq.getObjectAt(1));
        } else {
            this.extnID = DERObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.critical = DERBoolean.getInstance(seq.getObjectAt(1));
            this.extnValue = ASN1OctetString.getInstance(seq.getObjectAt(2));
        }
    }

    public DERObjectIdentifier getExtnID() {
        return this.extnID;
    }

    public DERBoolean getCritical() {
        return this.critical;
    }

    public ASN1OctetString getExtnValue() {
        return this.extnValue;
    }

    public static Extension getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Extension.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Extension getInstance(Object obj) {
        if (obj instanceof Extension) {
            return (Extension)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new Extension((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: ".concat(String.valueOf(String.valueOf(obj.getClass().getName()))));
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.extnID);
        v.add(this.critical);
        v.add(this.extnValue);
        return new DERSequence(v);
    }
}

