/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cert;

import com.cfca.util.pki.PKIConstant;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.asn1.x509.TBSCertificateStructure;
import com.cfca.util.pki.asn1.x509.Time;
import com.cfca.util.pki.asn1.x509.V3TBSCertificateGenerator;
import com.cfca.util.pki.asn1.x509.X509Extension;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.JKeyPair;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.lib.JSoftLib;
import com.cfca.util.pki.extension.Extension;
import com.cfca.util.pki.extension.KeyUsageExt;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class X509CertGenerator {
    private Mechanism mechanism = null;
    private V3TBSCertificateGenerator tbsCertGen = new V3TBSCertificateGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private String subject = null;
    private String issuer = null;
    private BigInteger serialNumber = null;
    private Date notBefore = null;
    private Date notAfter = null;
    private JKey pubKey = null;
    private DERBitString signature = null;
    private TBSCertificateStructure tbsCert = null;
    private Hashtable extensionSet = new Hashtable();

    public void setSerialNumber(String strSerialNumber) throws PKIException {
        if (strSerialNumber == null) {
            throw new PKIException("850402", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.serialNumber = new BigInteger(strSerialNumber, 16);
        this.tbsCertGen.setSerialNumber(new DERInteger(this.serialNumber));
    }

    public void setSerialNumber(BigInteger serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException("850402", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.serialNumber = serialNumber;
        this.tbsCertGen.setSerialNumber(new DERInteger(serialNumber));
    }

    public void setSubject(String subject) throws PKIException {
        if (subject == null || subject.trim().length() == 0) {
            throw new PKIException("850401", "\u8bc1\u4e66\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.subject = subject;
        this.tbsCertGen.setSubject(new X509Name(subject));
    }

    public void setIssuer(String issuer) throws PKIException {
        if (issuer == null || issuer.trim().length() == 0) {
            throw new PKIException("850403", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.issuer = issuer;
        this.tbsCertGen.setIssuer(new X509Name(issuer));
    }

    public void setNotBefore(Date notBefore) throws PKIException {
        if (notBefore == null) {
            throw new PKIException("850406", "\u8bc1\u4e66\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.notBefore = notBefore;
        this.tbsCertGen.setStartDate(new Time(notBefore));
    }

    public void setNotAfter(Date notAfter) throws PKIException {
        if (notAfter == null) {
            throw new PKIException("850405", "\u8bc1\u4e66\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.notAfter = notAfter;
        this.tbsCertGen.setEndDate(new Time(notAfter));
    }

    public void setPublicKey(JKey pubKey) throws PKIException {
        if (pubKey == null) {
            throw new PKIException("850407", "\u8bc1\u4e66\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.pubKey = pubKey;
        SubjectPublicKeyInfo spki = null;
        try {
            spki = Parser.key2SPKI(pubKey);
        }
        catch (Exception ex) {
            throw new PKIException("8503850304", "\u516c\u94a5\u8f6c\u6362\u4e3a\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u5931\u8d25", ex);
        }
        this.tbsCertGen.setSubjectPublicKeyInfo(spki);
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException("850404", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (signatureAlgorithm.equals("MD2withRSAEncryption")) {
            this.mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (signatureAlgorithm.equals("MD5withRSAEncryption")) {
            this.mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA1withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (signatureAlgorithm.endsWith("SHA1withECDSA")) {
            this.mechanism = new Mechanism("SHA1withECDSA");
        } else if (signatureAlgorithm.endsWith("SHA1withDSA")) {
            this.mechanism = new Mechanism("SHA1withDSA");
        } else {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: " + signatureAlgorithm);
        }
        DERObjectIdentifier oid = (DERObjectIdentifier)PKIConstant.sigAlgName2OID.get(signatureAlgorithm);
        this.sigAlg = new AlgorithmIdentifier(oid, new DERNull());
        this.tbsCertGen.setSignature(this.sigAlg);
    }

    public void setIssuerUniqueID(byte[] issuerUniqueID) {
        if (issuerUniqueID != null) {
            this.tbsCertGen.setIssuerUniqueID(new DERBitString(issuerUniqueID));
        }
    }

    public void setSubjectUniqueID(byte[] subjectUniqueID) {
        if (subjectUniqueID != null) {
            this.tbsCertGen.setSubjectUniqueID(new DERBitString(subjectUniqueID));
        }
    }

    public void addExtension(Extension extension) throws PKIException {
        DERObjectIdentifier derOID = new DERObjectIdentifier(extension.getOID());
        byte[] extensionValue = null;
        try {
            extensionValue = extension.encode();
        }
        catch (PKIException ex) {
            throw new PKIException("850410", "\u6269\u5c55\u57df\u7f16\u7801\u9519\u8bef", ex);
        }
        DEROctetString derOctet = new DEROctetString(extensionValue);
        this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), (ASN1OctetString)derOctet));
    }

    public void addUserEncodedExtension(com.cfca.util.pki.asn1.x509.Extension extension) throws PKIException {
        DERObjectIdentifier derOID = extension.getExtnID();
        ASN1OctetString extensionValue = extension.getExtnValue();
        this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), extensionValue));
    }

    public void setExtensions(Vector extensions) throws PKIException {
        int size = extensions.size();
        int i = 0;
        while (i < size) {
            Extension extension = (Extension)extensions.get(i);
            DERObjectIdentifier derOID = new DERObjectIdentifier(extension.getOID());
            byte[] extensionValue = null;
            try {
                extensionValue = extension.encode();
            }
            catch (PKIException ex) {
                throw new PKIException("850410", "\u6269\u5c55\u57df\u7f16\u7801\u9519\u8bef", ex);
            }
            DEROctetString derOctet = new DEROctetString(extensionValue);
            this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), (ASN1OctetString)derOctet));
            ++i;
        }
    }

    public void setUserEncodedExtensions(Vector extensions) throws PKIException {
        int size = extensions.size();
        int i = 0;
        while (i < size) {
            com.cfca.util.pki.asn1.x509.Extension extension = (com.cfca.util.pki.asn1.x509.Extension)extensions.get(i);
            DERObjectIdentifier derOID = extension.getExtnID();
            ASN1OctetString extensionValue = extension.getExtnValue();
            this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), extensionValue));
            ++i;
        }
    }

    public byte[] generateX509Cert(JKey priKey, Session session) throws PKIException {
        if (this.issuer == null || this.issuer.trim().length() == 0) {
            throw new PKIException("850403", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.subject == null || this.subject.trim().length() == 0) {
            throw new PKIException("850401", "\u8bc1\u4e66\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.pubKey == null) {
            throw new PKIException("850407", "\u8bc1\u4e66\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sigAlg == null) {
            throw new PKIException("850404", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.serialNumber == null) {
            throw new PKIException("850402", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.notBefore == null) {
            throw new PKIException("850406", "\u8bc1\u4e66\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.notAfter == null) {
            throw new PKIException("850405", "\u8bc1\u4e66\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.generateSignature(priKey, session);
        return this.constructCertificate();
    }

    private void generateSignature(JKey priKey, Session session) throws PKIException {
        if (this.extensionSet.size() > 0) {
            this.tbsCertGen.setExtensions(new X509Extensions(this.extensionSet));
        }
        this.tbsCert = this.tbsCertGen.generateTBSCertificate();
        byte[] bTBSCert = null;
        try {
            bTBSCert = Parser.writeDERObj2Bytes(this.tbsCert.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("850409", "TBS\u8bc1\u4e66\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        byte[] signatureData = null;
        try {
            signatureData = session.sign(this.mechanism, priKey, bTBSCert);
        }
        catch (Exception ex) {
            throw new PKIException("05", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        this.signature = new DERBitString(signatureData);
    }

    private byte[] constructCertificate() throws PKIException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsCert);
        v.add(this.sigAlg);
        v.add(this.signature);
        DERSequence derSeq = new DERSequence(v);
        byte[] certData = null;
        try {
            certData = Parser.writeDERObj2Bytes(derSeq.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("850408", "\u8bc1\u4e66\u8f6cbyte[]\u5931\u8d25", ex);
        }
        return certData;
    }

    public static void main(String[] agrs) {
        X509CertGenerator x509CertGenerator = new X509CertGenerator();
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            JSoftLib soft = new JSoftLib();
            Mechanism mechanism = new Mechanism("RSA");
            Vector<KeyUsageExt> extensions = new Vector<KeyUsageExt>();
            x509CertGenerator.setIssuer("O=CFCA Operation CA2,C=CN");
            x509CertGenerator.setIssuerUniqueID("1234567890".getBytes());
            Date notAfter = new Date(System.currentTimeMillis() + 86400000L);
            x509CertGenerator.setNotAfter(notAfter);
            Date notBefore = new Date();
            x509CertGenerator.setNotBefore(notBefore);
            JKeyPair keyPair = soft.generateKeyPair(mechanism, 1024);
            JKey pubKey = keyPair.getPublicKey();
            x509CertGenerator.setPublicKey(pubKey);
            BigInteger sn = new BigInteger("000000000000000000000001", 16);
            x509CertGenerator.setSerialNumber(sn);
            x509CertGenerator.setSignatureAlg("SHA1withRSAEncryption");
            x509CertGenerator.setSubject("CN=041@weizao@\u4e2d\u56fd\u91d1\u878d\u8ba4\u8bc1\u4e2d\u5fc3@00000003,OU=enterprises,OU=SGCC,O=CFCA Operation CA2,C=CN");
            x509CertGenerator.setSubjectUniqueID("1234567890".getBytes());
            KeyUsageExt keyUsage = new KeyUsageExt();
            keyUsage.setCritical(false);
            keyUsage.addKeyUsage("dataEncipherment");
            keyUsage.addKeyUsage("decipherOnly");
            extensions.add(keyUsage);
            x509CertGenerator.setExtensions(extensions);
            byte[] actualReturn = x509CertGenerator.generateX509Cert(keyPair.getPrivateKey(), soft);
            FileOutputStream fos = new FileOutputStream("C:/testCert.cer");
            fos.write(actualReturn);
            fos.flush();
            fos.close();
            X509Cert cert = new X509Cert(actualReturn);
            boolean verify = cert.verify(keyPair.getPublicKey(), soft);
            if (verify) {
                System.out.println("\u8bc1\u4e66\u9a8c\u8bc1\u901a\u8fc7");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

