/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.certpair;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.x509.CertificatePair;
import com.cfca.util.pki.asn1.x509.X509CertificateStructure;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.encoders.Base64;
import java.io.InputStream;

public class CertPairGenerator {
    private X509CertificateStructure forward = null;
    private X509CertificateStructure reverse = null;

    public CertPairGenerator(X509Cert forward, X509Cert reverse) {
        if (forward != null) {
            this.forward = forward.getCertStructure();
        }
        if (reverse != null) {
            this.reverse = reverse.getCertStructure();
        }
    }

    public CertPairGenerator(byte[] forward, byte[] reverse) throws PKIException {
        X509Cert caCert;
        if (forward != null && forward.length > 0) {
            caCert = new X509Cert(forward);
            this.forward = caCert.getCertStructure();
        }
        if (reverse != null && reverse.length > 0) {
            caCert = new X509Cert(reverse);
            this.reverse = caCert.getCertStructure();
        }
    }

    public CertPairGenerator(InputStream forward, InputStream reverse) throws PKIException {
        X509Cert caCert;
        if (forward != null) {
            caCert = new X509Cert(forward);
            this.forward = caCert.getCertStructure();
        }
        if (reverse != null) {
            caCert = new X509Cert(reverse);
            this.reverse = caCert.getCertStructure();
        }
    }

    public byte[] generateCertPair() throws PKIException {
        CertificatePair certPair = new CertificatePair(this.forward, this.reverse);
        try {
            return Parser.writeDERObj2Bytes(certPair.getDERObject());
        }
        catch (PKIException ex) {
            throw new PKIException("850700", "\u8bc1\u4e66\u5bf9\u8f6c\u6362byte[]\u5931\u8d25", ex);
        }
    }

    public byte[] generateCertPair_BASE64() throws PKIException {
        CertificatePair certPair = new CertificatePair(this.forward, this.reverse);
        byte[] bCertPair = null;
        try {
            bCertPair = Parser.writeDERObj2Bytes(certPair.getDERObject());
        }
        catch (PKIException ex) {
            throw new PKIException("850700", "\u8bc1\u4e66\u5bf9\u8f6c\u6362byte[]\u5931\u8d25", ex);
        }
        return Base64.encode(bCertPair);
    }
}

