/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cipher.lib;

import com.cfca.util.pki.PKIBaseConfig;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.JKeyPair;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.param.GenKeyAttribute;
import com.cfca.util.pki.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;

public class JHARDLib
implements Session {
    private static final String CFCA_CKR_OK = "0";
    private static final String CFCA_CKR_HOST_MEMORY = "2";
    private static final String CFCA_CKR_SLOT_ID_INVALID = "3";
    private static final String CFCA_CKR_GENERAL_ERROR = "5";
    private static final String CFCA_CKR_FUNCTION_FAILED = "6";
    private static final String CFCA_CKR_ARGUMENTS_BAD = "7";
    private static final String CFCA_CKR_NO_EVENT = "8";
    private static final String CFCA_CKR_NEED_TO_CREATE_THREADS = "9";
    private static final String CFCA_CKR_CANT_LOCK = "10";
    private static final String CFCA_CKR_ATTRIBUTE_READ_ONLY = "16";
    private static final String CFCA_CKR_ATTRIBUTE_SENSITIVE = "17";
    private static final String CFCA_CKR_ATTRIBUTE_TYPE_INVALID = "18";
    private static final String CFCA_CKR_ATTRIBUTE_VALUE_INVALID = "19";
    private static final String CFCA_CKR_DATA_INVALID = "32";
    private static final String CFCA_CKR_DATA_LEN_RANGE = "33";
    private static final String CFCA_CKR_DEVICE_ERROR = "48";
    private static final String CFCA_CKR_DEVICE_MEMORY = "49";
    private static final String CFCA_CKR_DEVICE_REMOVED = "50";
    private static final String CFCA_CKR_ENCRYPTED_DATA_INVALID = "64";
    private static final String CFCA_CKR_ENCRYPTED_DATA_LEN_RANGE = "65";
    private static final String CFCA_CKR_FUNCTION_CANCELED = "80";
    private static final String CFCA_CKR_FUNCTION_NOT_PARALLEL = "81";
    private static final String CFCA_CKR_FUNCTION_NOT_SUPPORTED = "84";
    private static final String CFCA_CKR_KEY_HANDLE_INVALID = "96";
    private static final String CFCA_CKR_KEY_SIZE_RANGE = "98";
    private static final String CFCA_CKR_KEY_TYPE_INCONSISTENT = "99";
    private static final String CFCA_CKR_KEY_NOT_NEEDED = "100";
    private static final String CFCA_CKR_KEY_CHANGED = "101";
    private static final String CFCA_CKR_KEY_NEEDED = "102";
    private static final String CFCA_CKR_KEY_INDIGESTIBLE = "103";
    private static final String CFCA_CKR_KEY_FUNCTION_NOT_PERMITTED = " 104";
    private static final String CFCA_CKR_KEY_NOT_WRAPPABLE = "105";
    private static final String CFCA_CKR_KEY_UNEXTRACTABLE = "106";
    private static final String CFCA_CKR_MECHANISM_INVALID = "112";
    private static final String CFCA_CKR_MECHANISM_PARAM_INVALID = "113";
    private static final String CFCA_CKR_OBJECT_HANDLE_INVALID = "130";
    private static final String CFCA_CKR_OPERATION_ACTIVE = "144";
    private static final String CFCA_CKR_OPERATION_NOT_INITIALIZED = "145";
    private static final String CFCA_CKR_PIN_INCORRECT = "160";
    private static final String CFCA_CKR_PIN_INVALID = "161";
    private static final String CFCA_CKR_PIN_LEN_RANGE = "162";
    private static final String CFCA_CKR_PIN_EXPIRED = "163";
    private static final String CFCA_CKR_PIN_LOCKED = "164";
    private static final String CFCA_CKR_SESSION_CLOSED = "176";
    private static final String CFCA_CKR_SESSION_COUNT = "177";
    private static final String CFCA_CKR_SESSION_HANDLE_INVALID = "179";
    private static final String CFCA_CKR_SESSION_PARALLEL_NOT_SUPPORTED = "180";
    private static final String CFCA_CKR_SESSION_READ_ONLY = "181";
    private static final String CFCA_CKR_SESSION_EXISTS = "182";
    private static final String CFCA_CKR_SESSION_READ_ONLY_EXISTS = "183";
    private static final String CFCA_CKR_SESSION_READ_WRITE_SO_EXISTS = "184";
    private static final String CFCA_CKR_SIGNATURE_INVALID = "192";
    private static final String CFCA_CKR_SIGNATURE_LEN_RANGE = "193";
    private static final String CFCA_CKR_TEMPLATE_INCOMPLETE = "208";
    private static final String CFCA_CKR_TEMPLATE_INCONSISTENT = "209";
    private static final String CFCA_CKR_TOKEN_NOT_PRESENT = "224";
    private static final String CFCA_CKR_TOKEN_NOT_RECOGNIZED = "225";
    private static final String CFCA_CKR_TOKEN_WRITE_PROTECTED = "226";
    private static final String CFCA_CKR_UNWRAPPING_KEY_HANDLE_INVALID = "240";
    private static final String CFCA_CKR_UNWRAPPING_KEY_SIZE_RANGE = "241";
    private static final String CFCA_CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT = "242";
    private static final String CFCA_CKR_USER_ALREADY_LOGGED_IN = "256";
    private static final String CFCA_CKR_USER_NOT_LOGGED_IN = "257";
    private static final String CFCA_CKR_USER_PIN_NOT_INITIALIZED = "258";
    private static final String CFCA_CKR_USER_TYPE_INVALID = "259";
    private static final String CFCA_CKR_USER_ANOTHER_ALREADY_LOGGED_IN = " 260";
    private static final String CFCA_CKR_USER_TOO_MANY_TYPES = "261";
    private static final String CFCA_CKR_WRAPPED_KEY_INVALID = "272";
    private static final String CFCA_CKR_WRAPPED_KEY_LEN_RANGE = "274";
    private static final String CFCA_CKR_WRAPPING_KEY_HANDLE_INVALID = "275";
    private static final String CFCA_CKR_WRAPPING_KEY_SIZE_RANGE = "276";
    private static final String CFCA_CKR_WRAPPING_KEY_TYPE_INCONSISTENT = "277";
    private static final String CFCA_CKR_RANDOM_SEED_NOT_SUPPORTED = "288";
    private static final String CFCA_CKR_RANDOM_NO_RNG = "289";
    private static final String CFCA_CKR_DOMAIN_PARAMS_INVALID = "304";
    private static final String CFCA_CKR_BUFFER_TOO_SMALL = "336";
    private static final String CFCA_CKR_SAVED_STATE_INVALID = "352";
    private static final String CFCA_CKR_INFORMATION_SENSITIVE = "368";
    private static final String CFCA_CKR_STATE_UNSAVEABLE = "384";
    private static final String CFCA_CKR_CRYPTOKI_NOT_INITIALIZED = "400";
    private static final String CFCA_CKR_CRYPTOKI_ALREADY_INITIALIZED = "401";
    private static final String CFCA_CKR_MUTEX_BAD = "416";
    private static final String CFCA_CKR_MUTEX_NOT_LOCKED = "417";
    private static final String CFCA_PARSE_FAIL = "4096";
    private static final String CFCA_CKR_OUTOFMEMORY = "4097";
    private static final String CFCA_CKR_MEMORYNOTNULL = "4098";
    private static final String CFCA_CKR_NOTSUPPORT = "4099";
    private static final String CFCA_LOADLIBRARY_FAIL = "4353";
    private static final String CFCA_GEFUNCTIONLIST_FAIL = "4354";
    private static final String CFCA_HANDLE_NULL = "4609";
    private static final String CFCA_FUNCTIONLISTPTR_NULL = "4610";
    private static final String CFCA_ENCRYPTLENGTH_NULL = "4611";
    private static final String CFCA_DECRYPTLENGTH_NULL = "4612";
    private static final String CFCA_CUSTOM_PRIVATEKEY_ERR = "4865";
    private static final String CFCA_CUSTOM_PUBLICKEY_ERR = "4866";
    private static final String CFCA_CUSTOM_LENGTH_INVALID = "5121";
    private static final String CFCA_KEYTYPE_INVALID = "5122";
    private static final String CFCA_KEYLENGTHE_INVALID = "5123";
    private static final String CFCA_MECHANISM_INVALID = "5124";
    private static final String CFCA_GETUNEXPORTPUBLICKEY_FAIL = "5377";
    private static final String CFCA_GETUNEXPORTPRIVATEKEY_FAIL = "5378";
    private static final String CFCA_GETMASTERKEY_FAIL = "5379";
    private static final String CFCA_GETKEYLENGTH_FAIL = "5380";
    private static final String CFCA_GETKEY_FAIL = "5381";
    private static final String CFCA_GETPUBLICKEY_FAIL = "5382";
    private static final String CFCA_GETPRIVATEKEY_FAIL = "5383";
    private static final String CFCA_GETCERT_FAIL = "5384";
    private static final String CFCA_CREATEPRIVATEKEY_FAIL = "5385";
    private static final String CFCA_ENCRYPTINIT_FAIL = "5386";
    private static final String CFCA_ENCRYPTUPDATE_FAIL = "5403";
    private static final String CFCA_ENCRYPTFINAL_FAIL = "5404";
    private static final String CFCA_DECRYPTINIT_FAIL = "5405";
    private static final String CFCA_DECRYPTUPDATE_FAIL = "5406";
    private static final String CFCA_DECRYPTFINAL_FAIL = "5407";
    private static final String CKC_KEYTYPE_SYMMETRY = "145";
    private static final String CKC_KEYTYPE_RSA_PUBLICKEY = "1";
    private static final String CKC_KEYTYPE_RSA_PRIVATEKEY = "2";
    private static final String CKC_KEYTYPE_RSA_PUBLICKEYID = "16";
    private static final String CKC_KEYTYPE_RSA_PRIVATEKEYID = "32";
    private static final String CKC_KEYTYPE_MASTERKEYID = "153";
    private static final String[][] hardException = new String[][]{{"0", "\u6210\u529f"}, {"2", "\u5185\u5b58\u9519\u8bef"}, {"3", "SLOTID\u65e0\u6548"}, {"5", "\u4e00\u822c\u7684\u9519\u8bef"}, {"6", "\u51fd\u6570\u9519\u8bef"}, {"7", "\u53c2\u6570\u9519\u8bef"}, {"8", "\u6ca1\u6709\u4e8b\u4ef6"}, {"9", "\u9700\u8981\u521b\u5efa\u7ebf\u7a0b"}, {"10", "\u503e\u659c\u9501\u5b9a"}, {"16", "\u5c5e\u6027\u53ea\u8bfb"}, {"17", "\u5c5e\u6027\u654f\u611f"}, {"18", "\u5c5e\u6027\u7c7b\u578b\u975e\u6cd5"}, {"19", "\u5c5e\u6027\u503c\u65e0\u6548"}, {"32", "\u6570\u636e\u65e0\u6548"}, {"33", "\u6570\u636e\u957f\u5ea6\u9519\u8bef"}, {"48", "\u8bbe\u5907\u9519\u8bef"}, {"49", "\u8bbe\u5907\u5185\u5b58\u51fa\u9519"}, {"50", "\u8bbe\u5907\u5df2\u5220\u9664"}, {"64", "\u52a0\u5bc6\u7684\u6570\u636e\u65e0\u6548"}, {"65", "\u52a0\u5bc6\u7684\u6570\u636e\u957f\u5ea6\u9519\u8bef"}, {"80", "\u63a5\u53e3\u5df2\u53d6\u6d88"}, {"81", "\u63a5\u53e3\u4e0d\u80fd\u5e76\u884c"}, {"84", "\u4e0d\u652f\u6301\u6b64\u63a5\u53e3"}, {"96", "\u975e\u6cd5\u7684\u5bc6\u94a5\u53e5\u67c4"}, {"98", "\u5bc6\u94a5\u7684\u957f\u5ea6\u9519\u8bef"}, {"99", " \u5bc6\u94a5\u7c7b\u578b\u77db\u76fe"}, {"100", "\u4e0d\u9700\u8981\u9644\u52a0\u7684\u5bc6\u94a5"}, {"101", "\u5bc6\u94a5\u5df2\u66f4\u6539"}, {"102", "\u9700\u8981\u9644\u52a0\u5bc6\u94a5"}, {"103", "\u5bc6\u94a5\u4e0d\u80fd\u88ab\u89e3\u6790"}, {" 104", "\u63a5\u53e3\u4e0d\u5141\u8bb8"}, {"105", "\u5bc6\u94a5\u4e0d\u80fd\u6253\u5305"}, {"106", "\u6307\u5b9a\u7684\u79c1\u6709\u6216\u4fdd\u5bc6\u5bc6\u94a5\u4e0d\u80fd\u88ab\u6253\u5305"}, {"112", "\u65e0\u6548\u7684\u673a\u5236"}, {"113", "\u65e0\u6548\u7684\u673a\u5236\u53c2\u6570"}, {"130", "\u975e\u6cd5\u7684\u5bf9\u8c61\u53e5\u67c4"}, {"144", "\u64cd\u4f5c\u5df2\u6fc0\u6d3b"}, {"145", "\u64cd\u4f5c\u6ca1\u6709\u521d\u59cb\u5316"}, {"160", "\u9519\u8bef\u7684PIN\u7801"}, {"161", "\u65e0\u6548\u7684PIN"}, {"162", "\u65e0\u6548\u7684PIN\u7684\u957f\u5ea6"}, {"163", "PIN\u7801\u5df2\u7ecf\u8fc7\u671f"}, {"164", "PIN\u7801\u88ab\u9501\u5b9a"}, {"176", "\u4f1a\u8bdd\u5df2\u7ecf\u5173\u95ed"}, {"177", "\u4f1a\u8bdd\u8d85\u51fa\u603b\u6570"}, {"179", "\u65e0\u6548\u7684\u4f1a\u8bdd\u53e5\u67c4"}, {"180", "\u4e0d\u652f\u6301\u5e76\u884c"}, {"181", "\u4f1a\u8bdd\u53ea\u8bfb"}, {"182", "\u4f1a\u8bdd\u5df2\u7ecf\u5b58\u5728"}, {"183", "\u4f1a\u8bdd\u5df2\u7ecf\u53ea\u8bfb"}, {"184", "\u4f1a\u8bdd\u5df2\u7ecf\u652f\u6301\u8bfb\u5199"}, {"192", "\u7b7e\u540d\u65e0\u6548"}, {"193", "\u7b7e\u540d\u957f\u5ea6\u65e0\u6548"}, {"208", "\u6a21\u677f\u672a\u5b8c\u6210"}, {"209", "\u6a21\u677f\u4e0d\u4e00\u81f4"}, {"224", "TOKEN\u4e0d\u5b58\u5728"}, {"225", "TOKEN\u672a\u8bc6\u522b"}, {"226", "TOKEN\u5199\u4fdd\u62a4"}, {"240", "\u65e0\u6548\u7684\u89e3\u5305\u5bc6\u94a5\u53e5\u67c4"}, {"241", "\u63a5\u9a73\u963f\u5bc6\u94a5\u5c3a\u5bf8\u8fc7\u5927"}, {"242", "\u89e3\u5305\u5bc6\u94a5\u7c7b\u578b\u4e0d\u4e00\u81f4"}, {"256", "\u7528\u6237\u5df2\u767b\u9646"}, {"257", "\u7528\u6237\u672a\u767b\u9646"}, {"258", "\u7528\u6237PIN\u7801\u672a\u521d\u59cb\u5316"}, {"259", "\u7528\u6237\u7c7b\u578b\u975e\u6cd5"}, {" 260", "\u53e6\u5916\u7528\u6237\u5df2\u767b\u9646"}, {"261", "\u7528\u6237\u7c7b\u578b\u592a\u591a"}, {"272", "\u6253\u5305\u5bc6\u94a5\u65e0\u6548"}, {"274", "\u6253\u5305\u5bc6\u94a5\u8fc7\u957f"}, {"275", "\u6253\u5305\u5bc6\u94a5\u7684\u53e5\u67c4\u65e0\u6548"}, {"276", "\u6253\u5305\u5bc6\u94a5\u5c3a\u5bf8\u8fc7\u5927"}, {"277", "\u6253\u5305\u5bc6\u94a5\u7c7b\u578b\u4e0d\u4e00\u81f4"}, {"288", "\u4e0d\u652f\u6301\u968f\u673a\u79cd\u5b50"}, {"289", "\u6ca1\u6709\u968f\u673a\u6570\u5b57\u4ea7\u751f\u5668"}, {"304", "DOMAIN\u53c2\u6570\u65e0\u6548"}, {"336", "\u5206\u914d\u7684\u7a7a\u95f4\u5c0f"}, {"352", "\u4fdd\u5b58\u7684\u72b6\u6001\u65e0\u6548"}, {"368", "\u4fe1\u606f\u654f\u611f"}, {"384", "\u72b6\u6001\u4e0d\u80fd\u4fdd\u5b58"}, {"400", "\u52a0\u5bc6\u5e93\u672a\u521d\u59cb\u5316"}, {"401", "\u52a0\u5bc6\u5e93\u5df2\u7ecf\u521d\u59cb\u5316"}, {"416", "\u4e92\u65a5\u4f53\u574f"}, {"417", "\u4e92\u65a5\u4f53\u672a\u9501\u5b9a"}, {"4096", "\u89e3\u6790\u52a0\u5bc6\u673a\u8fd4\u56de\u6570\u636e\u5931\u8d25"}, {"4097", "\u5185\u5b58\u4e0d\u8db3"}, {"4098", "\u4f20\u5165\u5185\u5b58\u53c2\u6570\u4e0d\u4e3a\u7a7a"}, {"4099", "\u5f53\u524d\u7248\u672c\u6ca1\u6709\u652f\u6301"}, {"4353", "\u52a0\u8f7dP11\u5e93\u5931\u8d25"}, {"4354", "\u83b7\u53d6\u52a8\u6001\u5e93\u51fd\u6570\u5217\u8868\u5931\u8d25"}, {"4609", "\u53e5\u67c4\u53c2\u6570\u4e3a\u7a7a"}, {"4610", "P11\u51fd\u6570\u5217\u8868\u6307\u9488\u4e3a\u7a7a"}, {"4611", "\u52a0\u5bc6\u540e\u957f\u5ea6\u4e3a\u96f6"}, {"4612", "\u89e3\u5bc6\u540e\u957f\u5ea6\u4e3a\u96f6"}, {"4865", "\u83b7\u53d6\u5230\u7684\u81ea\u5b9a\u4e49\u79c1\u94a5\u4fe1\u606f\u9519\u8bef"}, {"4866", "\u83b7\u53d6\u5230\u7684\u81ea\u5b9a\u4e49\u516c\u94a5\u4fe1\u606f\u9519\u8bef"}, {"5121", "\u83b7\u53d6\u5230\u7684\u81ea\u5b9a\u4e49\u6570\u636e\u957f\u5ea6\u975e\u6cd5"}, {"5122", "\u5bc6\u94a5\u7c7b\u578b\u4e0d\u652f\u6301"}, {"5123", "\u5bc6\u94a5\u957f\u5ea6\u4e0d\u652f\u6301"}, {"5124", "\u7b97\u6cd5\u4e0d\u652f\u6301"}, {"5377", "\u6ca1\u6709\u627e\u5230\u4e0d\u53ef\u5bfc\u51fa\u5bc6\u94a5\u5bf9\u4e2d\u7684\u516c\u94a5"}, {"5378", "\u6ca1\u6709\u627e\u5230\u4e0d\u53ef\u5bfc\u51fa\u5bc6\u94a5\u5bf9\u4e2d\u7684\u79c1\u94a5"}, {"5379", "\u83b7\u53d6\u5bf9\u79f0\u5bc6\u94a5\u4fe1\u606f\u957f\u5ea6\u5931\u8d25"}, {"5380", "\u83b7\u53d6\u5bf9\u79f0\u5bc6\u94a5\u4fe1\u606f\u957f\u5ea6\u5931\u8d25"}, {"5381", "\u83b7\u53d6\u5bf9\u79f0\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25"}, {"5382", "\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5931\u8d25"}, {"5383", "\u83b7\u53d6\u79c1\u94a5\u4fe1\u606f\u5931\u8d25"}, {"5384", "\u83b7\u53d6\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25"}, {"5385", "\u5efa\u7acb\u79c1\u94a5\u5bf9\u8c61\u5931\u8d25"}, {"5386", "\u52a0\u5bc6\u64cd\u4f5c\u521d\u59cb\u5316\u5931\u8d25"}, {"5403", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25"}, {"5404", "\u52a0\u5bc6\u64cd\u4f5c\u7ed3\u675f\u5931\u8d25"}, {"5405", "\u89e3\u5bc6\u64cd\u4f5c\u521d\u59cb\u5316\u5931\u8d25"}, {"5406", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25"}, {"5407", "\u89e3\u5bc6\u64cd\u4f5c\u7ed3\u675f\u5931\u8d25"}};
    private static final long RSA = 0L;
    private static final long RSA_PKCS = 1L;
    private static final long MD2_RSA_PKCS = 4L;
    private static final long MD5_RSA_PKCS = 5L;
    private static final long SHA1_RSA_PKCS = 6L;
    private static final long DES_KEY = 288L;
    private static final long DES_ECB = 289L;
    private static final long DES_CBC = 290L;
    private static final long MD2 = 512L;
    private static final long MD2_HMAC = 513L;
    private static final long MD5 = 528L;
    private static final long MD5_HMAC = 529L;
    private static final long SHA1 = 544L;
    private static final long SHA1_HMAC = 545L;
    private static final long RC2_KEY = 256L;
    private static final long RC2_ECB = 257L;
    private static final long RC2_CBC = 258L;
    private static final long RC4_KEY = 272L;
    private static final long RC4 = 273L;
    private static final long DES3_KEY = 305L;
    private static final long DES3_ECB = 306L;
    private static final long DES3_CBC = 307L;
    private static final long SSF33_KEY_GEN = 0x80000030L;
    private static final long CKM_SSF33_ECB = 2147483697L;
    private static final long CKM_SSF33_CBC = 2147483698L;
    private static JHARDLib Instance = null;
    public static final String PROVIDER = "HARDLIB";
    private static boolean isInit = false;

    private JHARDLib() {
        System.loadLibrary("HardLib");
    }

    public static void initHardProvider() throws PKIException {
        if (!isInit) {
            if (Instance == null) {
                Instance = new JHARDLib();
            }
            JHARDLib.Initialize();
            isInit = true;
        }
    }

    public static void finalizeHardProvider() throws PKIException {
        if (Instance != null) {
            JHARDLib.Finalize();
            isInit = false;
            Instance = null;
        }
    }

    public static JHARDLib getInstance() {
        if (Instance == null) {
            Instance = new JHARDLib();
        }
        return Instance;
    }

    private static void Initialize() throws PKIException {
        byte[] libPath = new String(PKIBaseConfig.getP11File()).getBytes();
        int errnum = Instance.p11Initialize(libPath);
        if (errnum != 0) {
            PKIException ex = new PKIException(Integer.toString(errnum), JHARDLib.errorDesc(Integer.toString(errnum)));
            throw ex;
        }
    }

    private static void Finalize() throws PKIException {
        int errnum = Instance.p11Finalize();
        if (errnum != 0) {
            PKIException ex = new PKIException(Integer.toString(errnum), JHARDLib.errorDesc(Integer.toString(errnum)));
            throw ex;
        }
    }

    public JKey generateKey(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("DES") || mType.equals("SSF33") || mType.equals("DESede") || mType.equals("RC2") || mType.equals("RC4_KEY"))) {
            throw new PKIException("850100", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] keyData = this.generateKey(mechType, keyLength / 8);
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850100", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        String lType = recvData.getProperty("lType");
        String pKey = recvData.getProperty("pKey");
        if (pKey == null || !error.equals(CFCA_CKR_OK)) {
            PKIException ex = new PKIException(error, JHARDLib.errorDesc(error));
            throw new PKIException("850100", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", ex);
        }
        Hex hex = new Hex();
        JKey key = new JKey(this.JNIToJavaKeyType(lType), Hex.decode(pKey));
        return key;
    }

    public JKeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mType.equals("RSA")) {
            throw new PKIException("850101", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        boolean isExport = true;
        int keyNum = 0;
        boolean isNotExportGenKey = false;
        if (mechanism.getParam() != null) {
            Object ob = mechanism.getParam();
            GenKeyAttribute keyAtt = (GenKeyAttribute)ob;
            isExport = keyAtt.getIsExport();
            keyNum = keyAtt.getKeyNum();
            isNotExportGenKey = keyAtt.getIsNotExportGenKey();
        }
        if (keyLength == 0) {
            keyLength = 1024;
        }
        int keyType = Integer.parseInt(PKIBaseConfig.getNoExportRSAKeyType());
        byte[] pubKeyValue = (String.valueOf(PKIBaseConfig.getNoExportRSAPubKeyValue()) + String.valueOf(keyNum)).getBytes();
        byte[] priKeyValue = (String.valueOf(PKIBaseConfig.getNoExportRSAPriKeyValue()) + String.valueOf(keyNum)).getBytes();
        byte[] keyData = this.generateKeyPair(mechType, keyLength, isExport, isNotExportGenKey, keyType, pubKeyValue, priKeyValue);
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850101", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        String pubType = recvData.getProperty("pubType");
        String pubKeyID = recvData.getProperty("pubKeyID");
        String pubModulus = recvData.getProperty("Pub_Modulus");
        String pubExponent = recvData.getProperty("Pub_Exponent");
        if (pubKeyID == null && pubModulus == null && pubExponent == null || !error.equals(CFCA_CKR_OK)) {
            PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
            throw new PKIException("850101", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
        String priType = recvData.getProperty("priType");
        String priKeyID = recvData.getProperty("priKeyID");
        String modulus = recvData.getProperty("Modulus");
        String privateExponent = recvData.getProperty("PrivateExponent");
        String publicExponent = recvData.getProperty("PublicExponent");
        String prime1 = recvData.getProperty("Prime1");
        String prime2 = recvData.getProperty("Prime2");
        String exponent1 = recvData.getProperty("Exponent1");
        String exponent2 = recvData.getProperty("Exponent2");
        String coefficient = recvData.getProperty("Coefficient");
        if (priKeyID == null && modulus == null && privateExponent == null && publicExponent == null && prime1 == null && prime2 == null && exponent1 == null && exponent2 == null && coefficient == null) {
            throw new PKIException("850101", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25");
        }
        Object keyPair = null;
        JKey publicKey = null;
        JKey privateKey = null;
        if (mType.equals("RSA")) {
            Hex hex;
            if (pubKeyID == null) {
                hex = new Hex();
                publicKey = new JKey(this.JNIToJavaKeyType(pubType), Parser.customData2SoftPublicKey(this.JNIToJavaKeyType(pubType), Hex.decode(pubModulus), Hex.decode(pubExponent)));
            } else {
                publicKey = new JKey(this.JNIToJavaKeyType(pubType), Long.parseLong(pubKeyID));
            }
            if (priKeyID == null) {
                hex = new Hex();
                privateKey = new JKey(this.JNIToJavaKeyType(priType), Parser.customData2SoftPrivateKey(this.JNIToJavaKeyType(priType), Hex.decode(modulus), Hex.decode(privateExponent), Hex.decode(publicExponent), Hex.decode(prime1), Hex.decode(prime2), Hex.decode(exponent1), Hex.decode(exponent2), Hex.decode(coefficient)));
            } else {
                privateKey = new JKey(this.JNIToJavaKeyType(priType), Long.parseLong(priKeyID));
            }
        }
        return new JKeyPair(publicKey, privateKey);
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("MD2withRSAEncryption"))) {
            throw new PKIException("850105", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] signData = null;
        signData = prvKey.getKey() != null ? this.sign(mechType, this.JavaToJNIKeyType(prvKey.getKeyType()), Parser.softKey2HardCustomKey(prvKey.getKeyType(), prvKey.getKey()), sourceData) : this.sign(mechType, this.JavaToJNIKeyType(prvKey.getKeyType()), Long.toString(prvKey.getKeyID()).getBytes(), sourceData);
        ByteArrayInputStream in = new ByteArrayInputStream(signData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850105", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvSign = recvData.getProperty("SignData");
        String error = recvData.getProperty("Error");
        if (error.equals(CFCA_CKR_OK) && recvSign != null) {
            Hex hex = new Hex();
            byte[] sign = Hex.decode(recvSign);
            return sign;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("850105", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("MD2withRSAEncryption"))) {
            throw new PKIException("850106", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] keyData = this.verifySign(mechType, this.JavaToJNIKeyType(pubKey.getKeyType()), Parser.softKey2HardCustomKey(pubKey.getKeyType(), pubKey.getKey()), sourceData, signData);
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850105", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(CFCA_CKR_OK)) {
            return true;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("850106", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] encrypt(Mechanism mechanism, JKey enKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SSF33_ECB") || mType.equals("SSF33_CBC") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("RC4") || mType.equals("RC2/ECB/PKCS7Padding") || mType.equals("RC2/CBC/PKCS7Padding"))) {
            throw new PKIException("850100", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] encData = null;
        if (mechType == 1L) {
            encData = this.encrypt(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), Parser.softKey2HardCustomKey(enKey.getKeyType(), enKey.getKey()), sourceData);
        } else if (enKey.getKeyType().equalsIgnoreCase("MASTERKEY")) {
            long encmec = Long.parseLong(PKIBaseConfig.getMasterKeyEnc());
            encData = this.masterEncrypt(Long.parseLong(PKIBaseConfig.getMasterKeyEnc()), Integer.parseInt(PKIBaseConfig.getMasterKeyType()), PKIBaseConfig.getMasterKeyValue().getBytes(), sourceData);
        } else {
            encData = this.encrypt(mechType, this.JavaToJNIKeyType(enKey.getKeyType()), enKey.getKey(), sourceData);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(encData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850100", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvEnc = recvData.getProperty("EncData");
        String error = recvData.getProperty("Error");
        if (error.equals(CFCA_CKR_OK) && recvEnc != null) {
            Hex hex = new Hex();
            byte[] enc = Hex.decode(recvEnc);
            return enc;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("850100", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public byte[] decrypt(Mechanism mechanism, JKey deKey, byte[] encryptedData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("SSF33_ECB") || mType.equals("SSF33_CBC") || mType.equals("RSA/ECB/PKCS1PADDING") || mType.equals("DES/ECB/PKCS7Padding") || mType.equals("DES/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("RC4"))) {
            throw new PKIException("850101", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] decData = null;
        if (mechType == 1L && deKey.getKey() == null) {
            decData = this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Long.toString(deKey.getKeyID()).getBytes(), encryptedData);
        } else if (mechType == 1L && deKey.getKey() != null) {
            decData = this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), Parser.softKey2HardCustomKey(deKey.getKeyType(), deKey.getKey()), encryptedData);
        } else if (deKey.getKeyType().equalsIgnoreCase("MASTERKEY")) {
            long encmec = Long.parseLong(PKIBaseConfig.getMasterKeyEnc());
            decData = this.masterDecrypt(Long.parseLong(PKIBaseConfig.getMasterKeyEnc()), Integer.parseInt(PKIBaseConfig.getMasterKeyType()), PKIBaseConfig.getMasterKeyValue().getBytes(), encryptedData);
        } else {
            decData = this.decrypt(mechType, this.JavaToJNIKeyType(deKey.getKeyType()), deKey.getKey(), encryptedData);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(decData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850101", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
        String recvDec = recvData.getProperty("DecData");
        String error = recvData.getProperty("Error");
        if (error.equals(CFCA_CKR_OK) && recvDec != null) {
            Hex hex = new Hex();
            byte[] dec = Hex.decode(recvDec);
            return dec;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("850101", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
    }

    public boolean createCertObject(byte[] dn, byte[] certData, byte[] keyId) throws PKIException {
        byte[] keyData = this.importCert(dn, certData, keyId);
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850100", "\u88c5\u8f7d\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(CFCA_CKR_OK)) {
            return true;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("850101", "\u521b\u5efa\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
    }

    public boolean destroyCertObject(byte[] dn, byte[] keyId) throws PKIException {
        byte[] keyData = null;
        keyData = dn == null ? this.destroyCerts(keyId) : this.destroyCert(dn, keyId);
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850102", "\u88c5\u8f7d\u8981\u5220\u9664\u7684\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        if (error.equals(CFCA_CKR_OK)) {
            return true;
        }
        if (error.equals(CFCA_GETCERT_FAIL)) {
            return false;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("850103", "\u5220\u9664\u7684\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
    }

    public byte[] getCertObject(byte[] keyId) throws PKIException {
        byte[] keyData = this.getCert(keyId);
        ByteArrayInputStream in = new ByteArrayInputStream(keyData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            PKIException e = new PKIException(CFCA_PARSE_FAIL, JHARDLib.errorDesc(CFCA_PARSE_FAIL));
            throw new PKIException("850104", "\u5f97\u5230\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
        }
        String error = recvData.getProperty("Error");
        String certObject = recvData.getProperty("certObject");
        if (error.equals(CFCA_CKR_OK) && certObject != null) {
            Hex hex = new Hex();
            byte[] enc = Hex.decode(certObject);
            return enc;
        }
        PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
        throw new PKIException("850104", "\u5f97\u5230\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
    }

    public byte[] digest(Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2") || mType.equals("MD5") || mType.equals("SHA1"))) {
            throw new PKIException("850102", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        byte[] digestData = this.digest(mechType, sourceData);
        ByteArrayInputStream in = new ByteArrayInputStream(digestData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            throw new PKIException("850102", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
        String recvEnc = recvData.getProperty("DigestData");
        String error = recvData.getProperty("Error");
        if (!error.equals(CFCA_CKR_OK) || recvEnc == null) {
            PKIException e = new PKIException(error, JHARDLib.errorDesc(error));
            throw new PKIException("850102", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", e);
        }
        Hex hex = new Hex();
        digestData = Hex.decode(recvEnc);
        return digestData;
    }

    public byte[] mac(Mechanism mechanism, JKey key, byte[] sourceData) throws PKIException {
        throw new UnsupportedOperationException("Method mac() not yet implemented.");
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, byte[] sourceData, byte[] macData) throws PKIException {
        throw new UnsupportedOperationException("Method verifyMac() not yet implemented.");
    }

    public JKey generatePBEKey(Mechanism mechanism, char[] password) throws PKIException {
        throw new UnsupportedOperationException("Method generatePBEKey() not yet implemented.");
    }

    public byte[] generateRandom(Mechanism mechanism, int length) throws PKIException {
        if (!mechanism.getMechanismType().equals("Random")) {
            throw new PKIException("850103", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b Random");
        }
        byte[] randomData = this.generateRandom(length);
        ByteArrayInputStream in = new ByteArrayInputStream(randomData);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            throw new PKIException("850103", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25", ex);
        }
        String recvEnc = recvData.getProperty("RandomData");
        String error = recvData.getProperty("Error");
        if (!error.equals(CFCA_CKR_OK) || recvEnc == null) {
            throw new PKIException("850103", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25");
        }
        Hex hex = new Hex();
        randomData = Hex.decode(recvEnc);
        return randomData;
    }

    private static String errorDesc(String errCode) {
        String code = new String();
        int i = 0;
        while (i < hardException.length) {
            if (hardException[i][0].equals(errCode)) {
                code = hardException[i][1];
                break;
            }
            ++i;
        }
        if (code == null) {
            code = "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef!!!";
        }
        return code;
    }

    private String JNIToJavaKeyType(String keyType) throws PKIException {
        if (keyType.equalsIgnoreCase("145")) {
            return new String("SYMMETRY");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_RSA_PUBLICKEY)) {
            return new String("RSA_Public");
        }
        if (keyType.equalsIgnoreCase("2")) {
            return new String("RSA_Private");
        }
        if (keyType.equalsIgnoreCase("16")) {
            return new String("RSA_PublicID");
        }
        if (keyType.equalsIgnoreCase("32")) {
            return new String("RSA_PrivateID");
        }
        if (keyType.equalsIgnoreCase(CKC_KEYTYPE_MASTERKEYID)) {
            return new String("MASTERKEY");
        }
        throw new PKIException("850100", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private int JavaToJNIKeyType(String keyType) throws PKIException {
        if (keyType.equalsIgnoreCase("SYMMETRY")) {
            return Integer.parseInt("145");
        }
        if (keyType.equalsIgnoreCase("RSA_Public")) {
            return Integer.parseInt(CKC_KEYTYPE_RSA_PUBLICKEY);
        }
        if (keyType.equalsIgnoreCase("RSA_Private")) {
            return Integer.parseInt("2");
        }
        if (keyType.equalsIgnoreCase("RSA_PublicID")) {
            return Integer.parseInt("16");
        }
        if (keyType.equalsIgnoreCase("RSA_PrivateID")) {
            return Integer.parseInt("32");
        }
        if (keyType.equalsIgnoreCase("MASTERKEY")) {
            return Integer.parseInt(CKC_KEYTYPE_MASTERKEYID);
        }
        throw new PKIException("850100", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    private long JavaToJNIMechanismType(String mechanismType) throws PKIException {
        if (mechanismType.equals("RSA")) {
            return 0L;
        }
        if (mechanismType.equals("RSA/ECB/PKCS1PADDING")) {
            return 1L;
        }
        if (mechanismType.equals("MD2")) {
            return 512L;
        }
        if (mechanismType.equals("MD2withRSAEncryption")) {
            return 4L;
        }
        if (mechanismType.equals("MD5")) {
            return 528L;
        }
        if (mechanismType.equals("MD5withRSAEncryption")) {
            return 5L;
        }
        if (mechanismType.equals("SHA1")) {
            return 544L;
        }
        if (mechanismType.equals("SHA1withRSAEncryption")) {
            return 6L;
        }
        if (mechanismType.equals("DES")) {
            return 288L;
        }
        if (mechanismType.equals("DES/ECB/PKCS7Padding")) {
            return 289L;
        }
        if (mechanismType.equals("DES/CBC/PKCS7Padding")) {
            return 290L;
        }
        if (mechanismType.equals("DESede")) {
            return 305L;
        }
        if (mechanismType.equals("DESede/ECB/PKCS7Padding")) {
            return 306L;
        }
        if (mechanismType.equals("DESede/CBC/PKCS7Padding")) {
            return 307L;
        }
        if (mechanismType.equals("RC2")) {
            return 256L;
        }
        if (mechanismType.equals("RC2/ECB/PKCS7Padding")) {
            return 257L;
        }
        if (mechanismType.equals("RC2/CBC/PKCS7Padding")) {
            return 258L;
        }
        if (mechanismType.equals("RC4_KEY")) {
            return 272L;
        }
        if (mechanismType.equals("RC4")) {
            return 273L;
        }
        if (mechanismType.equals("SSF33")) {
            return 0x80000030L;
        }
        if (mechanismType.equals("SSF33_ECB")) {
            return 2147483697L;
        }
        if (mechanismType.equals("SSF33_CBC")) {
            return 2147483698L;
        }
        throw new PKIException("850100", "\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
    }

    public boolean destroyKeyPair(Mechanism mechanism) throws PKIException {
        byte[] priKeyValue;
        byte[] pubKeyValue;
        int keyType;
        int rv;
        String mType = mechanism.getMechanismType();
        if (!mType.equals("RSA")) {
            throw new PKIException("850101", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        long mechType = this.JavaToJNIMechanismType(mType);
        int keyNum = 0;
        if (mechanism.getParam() != null) {
            Object ob = mechanism.getParam();
            GenKeyAttribute keyAtt = (GenKeyAttribute)ob;
            keyNum = keyAtt.getKeyNum();
        }
        if ((rv = this.destroyKeyPair(mechType, keyType = Integer.parseInt(PKIBaseConfig.getNoExportRSAKeyType()), pubKeyValue = (String.valueOf(PKIBaseConfig.getNoExportRSAPubKeyValue()) + String.valueOf(keyNum)).getBytes(), priKeyValue = (String.valueOf(PKIBaseConfig.getNoExportRSAPriKeyValue()) + String.valueOf(keyNum)).getBytes())) == 0) {
            return true;
        }
        if (JHARDLib.errorDesc(String.valueOf(rv)) != null) {
            PKIException e = new PKIException(String.valueOf(rv), JHARDLib.errorDesc(String.valueOf(rv)));
            throw new PKIException("850105", "\u5220\u9664\u7684\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
        PKIException e = new PKIException(String.valueOf(rv));
        throw new PKIException("850105", "\u5220\u9664\u7684\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
    }

    public String Version() throws PKIException {
        byte[] Version2 = this.getVersion();
        ByteArrayInputStream in = new ByteArrayInputStream(Version2);
        Properties recvData = new Properties();
        try {
            recvData.load(in);
        }
        catch (Exception ex) {
            throw new PKIException("850103", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25", ex);
        }
        return recvData.getProperty("Version");
    }

    private native byte[] getVersion();

    private native int p11Initialize(byte[] var1);

    private native byte[] generateKey(long var1, int var3);

    private native byte[] generateKeyPair(long var1, int var3, boolean var4, boolean var5, int var6, byte[] var7, byte[] var8);

    private native int destroyKeyPair(long var1, int var3, byte[] var4, byte[] var5);

    private native byte[] sign(long var1, int var3, byte[] var4, byte[] var5);

    private native byte[] verifySign(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    private native byte[] encrypt(long var1, int var3, byte[] var4, byte[] var5);

    private native byte[] masterEncrypt(long var1, int var3, byte[] var4, byte[] var5);

    private native byte[] masterDecrypt(long var1, int var3, byte[] var4, byte[] var5);

    private native byte[] decrypt(long var1, int var3, byte[] var4, byte[] var5);

    private native byte[] importCert(byte[] var1, byte[] var2, byte[] var3);

    private native byte[] getCert(byte[] var1);

    private native byte[] destroyCert(byte[] var1, byte[] var2);

    private native byte[] destroyCerts(byte[] var1);

    private native int p11Finalize();

    private native byte[] digest(long var1, byte[] var3);

    private native byte[] generateRandom(int var1);

    public static void main(String[] args) {
        try {
            JHARDLib instance = null;
            instance = JHARDLib.getInstance();
            System.out.println("HardLib " + instance.Version() + "\r\n" + "CFCA-PKITool2_0_0_9-lastmodification_200510121606");
            byte[] pubcert = instance.getCertObject("DA_SJY_RSA_1".getBytes());
            X509Cert pubCert = new X509Cert(pubcert);
            String dn = pubCert.getSubject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public byte[] digest(Mechanism mechanism, InputStream sourceData, int bufferSize) throws PKIException {
        throw new PKIException("850102", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 digest() JHardLib didn't support Stream-Operation yet. ");
    }

    public byte[] mac(Mechanism mechanism, JKey key, InputStream sourceData) throws PKIException {
        throw new PKIException("850103", "MAC\u64cd\u4f5c\u5931\u8d25 mac() JHardLib didn't support Stream-Operation yet. ");
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, InputStream sourceData, byte[] macData) throws PKIException {
        throw new PKIException("850104", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25 verifyMac() JHardLib didn't support Stream-Operation yet. ");
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, InputStream sourceData) throws PKIException {
        throw new PKIException("850105", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 sign() JHardLib didn't support Stream-Operation yet. ");
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, InputStream sourceData, byte[] signData) throws PKIException {
        throw new PKIException("850106", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 verifySign() JHardLib didn't support Stream-Operation yet. ");
    }

    public void encrypt(Mechanism mechanism, JKey enKey, String sourceData, String encFile, int bufferSize) throws PKIException {
        throw new PKIException("850100", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 encrypt() JHardLib didn't support Stream-Operation yet. ");
    }

    public void decrypt(Mechanism mechanism, JKey deKey, String encryptedData, String srcFile, int bufferSize) throws PKIException {
        throw new PKIException("850101", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 decrypt() JHardLib didn't support Stream-Operation yet. ");
    }
}

