/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cipher.lib;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.JKeyPair;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.param.CBCParam;
import com.cfca.util.pki.cipher.param.PBEParam;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;

public class JSoftLib
implements Session {
    public static final String PROVIDER = "BC";

    public byte[] digest(Mechanism mechanism, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2") || mType.equals("MD5") || mType.equals("SHA1"))) {
            throw new PKIException("850202", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            MessageDigest m = MessageDigest.getInstance(mType, PROVIDER);
            m.update(sourceData);
            byte[] digest = m.digest();
            return digest;
        }
        catch (Exception ex) {
            throw new PKIException("850202", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] mac(Mechanism mechanism, JKey key, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("850203", "MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] macData = null;
        try {
            Mac mac = Mac.getInstance(mechanism.getMechanismType(), PROVIDER);
            mac.init(Parser.convertSecretKey(key));
            mac.update(sourceData);
            macData = mac.doFinal();
            return macData;
        }
        catch (Exception ex) {
            throw new PKIException("850203", "MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, byte[] sourceData, byte[] macData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("850204", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            byte[] tmp = this.mac(mechanism, key, sourceData);
            return Parser.isEqualArray(tmp, macData);
        }
        catch (Exception ex) {
            throw new PKIException("850204", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2withRSAEncryption") || mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withDSA") || mType.equals("SHA1withECDSA"))) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] signData = null;
        try {
            Signature signature = Signature.getInstance(mType, PROVIDER);
            signature.initSign(Parser.convertPrivateKey(prvKey));
            signature.update(sourceData);
            signData = signature.sign();
            return signData;
        }
        catch (Exception ex) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2withRSAEncryption") || mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withDSA") || mType.equals("SHA1withECDSA"))) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), PROVIDER);
            signature.initVerify(Parser.convertPublicKey(pubKey));
            signature.update(sourceData);
            return signature.verify(signData);
        }
        catch (Exception ex) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] encrypt(Mechanism mechanism, JKey enKey, byte[] sourceData) throws PKIException {
        try {
            return this.doCipher(mechanism, enKey, true, sourceData);
        }
        catch (Exception ex) {
            throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] decrypt(Mechanism mechanism, JKey deKey, byte[] encryptedData) throws PKIException {
        try {
            return this.doCipher(mechanism, deKey, false, encryptedData);
        }
        catch (Exception ex) {
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JKey generateKey(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("DES") || mType.equals("DESede") || mType.equals("RC2") || mType.equals("RC4") || mType.equals("CAST5") || mType.equals("IDEA") || mType.equals("AES"))) {
            throw new PKIException("850200", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(mechanism.getMechanismType(), PROVIDER);
            keyGen.init(keyLength);
            SecretKey key = keyGen.generateKey();
            return new JKey(key.getAlgorithm(), key.getEncoded());
        }
        catch (Exception ex) {
            throw new PKIException("850200", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public JKeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("RSA") || mType.equals("DSA") || mType.equals("ECIES"))) {
            throw new PKIException("850201", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        KeyPair keyPair = null;
        PublicKey pubKey = null;
        PrivateKey prvKey = null;
        JKey jPubKey = null;
        JKey jPrvKey = null;
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(mType, PROVIDER);
            keyPairGen.initialize(keyLength, new SecureRandom());
            keyPair = keyPairGen.generateKeyPair();
            pubKey = keyPair.getPublic();
            prvKey = keyPair.getPrivate();
            byte[] pubKeyEncoded = pubKey.getEncoded();
            byte[] prvKeyEncoded = prvKey.getEncoded();
            if (mechanism.getMechanismType().equals("RSA")) {
                jPubKey = new JKey("RSA_Public", pubKeyEncoded);
                jPrvKey = new JKey("RSA_Private", prvKeyEncoded);
            } else if (mechanism.getMechanismType().equals("DSA")) {
                jPubKey = new JKey("DSA_Public", pubKeyEncoded);
                jPrvKey = new JKey("DSA_Private", prvKeyEncoded);
            } else {
                jPubKey = new JKey("ECIES_Public", pubKeyEncoded);
                jPrvKey = new JKey("ECIES_Private", prvKeyEncoded);
            }
            return new JKeyPair(jPubKey, jPrvKey);
        }
        catch (Exception ex) {
            throw new PKIException("850201", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", ex);
        }
    }

    public boolean destroyKeyPair(Mechanism mechanism) throws PKIException {
        throw new UnsupportedOperationException("Method destroyKeyPair() not yet implemented in JSOFT_LIB.");
    }

    public JKey generatePBEKey(Mechanism mechanism, char[] password) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("PBEWithMD5AndDES") || mType.equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC") || mType.equals("PBEWITHSHAAND3-KEYTRIPLEDES-CBC") || mType.equals("PBEWITHSHAAND40BITRC4") || mType.equals("PBEWITHSHAAND128BITRC4") || mType.equals("PBEWithMD5AndRC2") || mType.equals("PBEWithSHA1AndRC2") || mType.equals("PBEWithSHA1AndDES"))) {
            throw new PKIException("850202", "\u4ea7\u751fPBE\u5bc6\u94a5\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            byte[] keyData = new String(password).getBytes();
            if (mType.equals("PBEWithMD5AndDES")) {
                return new JKey("PBEWithMD5AndDES", keyData);
            }
            if (mType.equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC")) {
                return new JKey("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", keyData);
            }
            if (mType.equals("PBEWITHSHAAND3-KEYTRIPLEDES-CBC")) {
                return new JKey("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", keyData);
            }
            if (mType.equals("PBEWITHSHAAND40BITRC4")) {
                return new JKey("PBEWITHSHAAND40BITRC4", keyData);
            }
            if (mType.equals("PBEWITHSHAAND128BITRC4")) {
                return new JKey("PBEWITHSHAAND128BITRC4", keyData);
            }
            if (mType.equals("PBEWithMD5AndRC2")) {
                return new JKey("PBEWithMD5AndRC2", keyData);
            }
            if (mType.equals("PBEWithSHA1AndRC2")) {
                return new JKey("PBEWithSHA1AndRC2", keyData);
            }
            return new JKey("PBEWithSHA1AndDES", keyData);
        }
        catch (Exception ex) {
            throw new PKIException("850202", "\u4ea7\u751fPBE\u5bc6\u94a5\u5931\u8d25", ex);
        }
    }

    public byte[] generateRandom(Mechanism mechanism, int length) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mechanism.getMechanismType().equals("Random")) {
            throw new PKIException("850203", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        SecureRandom sRandom = new SecureRandom();
        byte[] data = new byte[length];
        sRandom.nextBytes(data);
        return data;
    }

    private byte[] doCipher(Mechanism mechanism, JKey jkey, boolean isEncrypt, byte[] data) throws Exception {
        String mType = mechanism.getMechanismType();
        int rsaKeyLen = -1;
        if (mType.equalsIgnoreCase("RSA/ECB/PKCS1PADDING")) {
            if (jkey.getKeyType().equals("RSA_Public")) {
                RSAPublicKey pubKey = (RSAPublicKey)Parser.convertPublicKey(jkey);
                rsaKeyLen = pubKey.getModulus().bitLength();
            } else if (jkey.getKeyType().equals("RSA_Private")) {
                RSAPrivateKey prvKey = (RSAPrivateKey)Parser.convertPrivateKey(jkey);
                rsaKeyLen = prvKey.getModulus().bitLength();
            }
            if (rsaKeyLen > 2048) {
                return this.doCipher_RSA_ext(mechanism, jkey, isEncrypt, data);
            }
        }
        Cipher cipher = Cipher.getInstance(mType, PROVIDER);
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        if (mType.indexOf("PBE") != -1) {
            PBEParam pbeParam = (PBEParam)mechanism.getParam();
            if (pbeParam == null) {
                throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
            }
            PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
            cipher.init(cipherMode, Parser.convertKey(jkey), pbeSpec);
        } else if (mType.indexOf("CBC") != -1) {
            CBCParam cbcParam = (CBCParam)mechanism.getParam();
            if (cbcParam == null) {
                throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
            cipher.init(cipherMode, Parser.convertKey(jkey), iv);
        } else {
            cipher.init(cipherMode, Parser.convertKey(jkey));
        }
        byte[] res = cipher.doFinal(data);
        return res;
    }

    public static void main(String[] args) {
        System.out.println("OK");
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            byte[] iv = new byte[16];
            SecureRandom sRandom = new SecureRandom();
            sRandom.nextBytes(iv);
            CBCParam cbcParam = new CBCParam();
            cbcParam.setIv(iv);
            Session session = jcrypto.openSession("JSOFT_LIB");
            Mechanism keyGen = new Mechanism("PBEWithSHA1AndDES");
            Mechanism mechanism = new Mechanism("PBEWithSHA1AndDES", new PBEParam());
            JKey key = session.generatePBEKey(keyGen, "12345678".toCharArray());
            byte[] src = "CFCA\u6d4b\u8bd5".getBytes();
            byte[] enData = session.encrypt(mechanism, key, src);
            FileOutputStream fos = new FileOutputStream("C://test//test");
            fos.write(enData);
            fos.close();
            System.out.println(new String(enData));
            byte[] deData = session.decrypt(mechanism, key, enData);
            System.out.println(new String(deData));
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    private byte[] doCipher_RSA_ext(Mechanism mechanism, JKey jkey, boolean isEncrypt, byte[] data) throws Exception {
        RSAEngine eng = new RSAEngine();
        RSAKeyParameters keyParams = null;
        if (jkey.getKeyType().equals("RSA_Public")) {
            JCERSAPublicKey pubKey = (JCERSAPublicKey)Parser.convertPublicKey(jkey);
            keyParams = new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        } else {
            JCERSAPrivateCrtKey prvKey = (JCERSAPrivateCrtKey)Parser.convertPrivateKey(jkey);
            keyParams = new RSAPrivateCrtKeyParameters(prvKey.getModulus(), prvKey.getPublicExponent(), prvKey.getPrivateExponent(), prvKey.getPrimeP(), prvKey.getPrimeQ(), prvKey.getPrimeExponentP(), prvKey.getPrimeExponentQ(), prvKey.getCrtCoefficient());
        }
        eng.init(isEncrypt, (CipherParameters)keyParams);
        byte[] res = eng.processBlock(data, 0, data.length);
        return res;
    }

    public byte[] digest(Mechanism mechanism, InputStream sourceData, int bufferSize) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2") || mType.equals("MD5") || mType.equals("SHA1"))) {
            throw new PKIException("850202", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        if (bufferSize <= 0) {
            bufferSize = 0x100000;
        }
        try {
            MessageDigest m = MessageDigest.getInstance(mType, PROVIDER);
            byte[] buffer = new byte[bufferSize];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                m.update(buffer, 0, i);
            }
            byte[] digest = m.digest();
            sourceData.close();
            return digest;
        }
        catch (Exception ex) {
            throw new PKIException("850202", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] mac(Mechanism mechanism, JKey key, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("850203", "MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] macData = null;
        try {
            Mac mac = Mac.getInstance(mechanism.getMechanismType(), PROVIDER);
            mac.init(Parser.convertSecretKey(key));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                mac.update(buffer, 0, i);
            }
            macData = mac.doFinal();
            return macData;
        }
        catch (Exception ex) {
            throw new PKIException("850203", "MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifyMac(Mechanism mechanism, JKey key, InputStream sourceData, byte[] macData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("HMac-MD2") || mType.equals("HMac-MD5") || mType.equals("HMac-SHA1"))) {
            throw new PKIException("850204", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            byte[] tmp = this.mac(mechanism, key, sourceData);
            return Parser.isEqualArray(tmp, macData);
        }
        catch (Exception ex) {
            throw new PKIException("850204", "\u9a8c\u8bc1MAC\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] sign(Mechanism mechanism, JKey prvKey, InputStream sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2withRSAEncryption") || mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withDSA") || mType.equals("SHA1withECDSA"))) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] signData = null;
        try {
            Signature signature = Signature.getInstance(mType, PROVIDER);
            signature.initSign(Parser.convertPrivateKey(prvKey));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            signData = signature.sign();
            sourceData.close();
            return signData;
        }
        catch (Exception ex) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifySign(Mechanism mechanism, JKey pubKey, InputStream sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD2withRSAEncryption") || mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA1withDSA") || mType.equals("SHA1withECDSA"))) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), PROVIDER);
            signature.initVerify(Parser.convertPublicKey(pubKey));
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            sourceData.close();
            return signature.verify(signData);
        }
        catch (Exception ex) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public void encrypt(Mechanism mechanism, JKey enKey, String sourceData, String encFile, int bufferSize) throws PKIException {
        try {
            this.doCipher(mechanism, enKey, true, sourceData, encFile, bufferSize);
        }
        catch (Exception ex) {
            throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public void decrypt(Mechanism mechanism, JKey deKey, String encryptedData, String srcFile, int bufferSize) throws PKIException {
        try {
            this.doCipher(mechanism, deKey, false, encryptedData, srcFile, bufferSize);
        }
        catch (Exception ex) {
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    private void doCipher(Mechanism mechanism, JKey jkey, boolean isEncrypt, String data, String file, int bufferSize) throws Exception {
        FileOutputStream fos;
        String mType = mechanism.getMechanismType();
        Cipher cipher = Cipher.getInstance(mType, PROVIDER);
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        if (mType.indexOf("PBE") != -1) {
            PBEParam pbeParam = (PBEParam)mechanism.getParam();
            if (pbeParam == null) {
                throw new PKIException("PBE\u53c2\u6570\u4e3a\u7a7a");
            }
            PBEParameterSpec pbeSpec = new PBEParameterSpec(pbeParam.getSalt(), pbeParam.getIterations());
            cipher.init(cipherMode, Parser.convertKey(jkey), pbeSpec);
        } else if (mType.indexOf("CBC") != -1) {
            CBCParam cbcParam = (CBCParam)mechanism.getParam();
            if (cbcParam == null) {
                throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
            cipher.init(cipherMode, Parser.convertKey(jkey), iv);
        } else {
            cipher.init(cipherMode, Parser.convertKey(jkey));
        }
        if (bufferSize <= 0) {
            bufferSize = 0x100000;
        }
        byte[] buffer = new byte[bufferSize];
        if (isEncrypt) {
            fos = new FileOutputStream(file);
            CipherOutputStream cipherOutStream = new CipherOutputStream(fos, cipher);
            BufferedOutputStream bufferOS = new BufferedOutputStream(cipherOutStream, bufferSize);
            BufferedInputStream bufferIS = new BufferedInputStream(new FileInputStream(data), bufferSize);
            int len = 0;
            while ((len = bufferIS.read(buffer)) > 0) {
                bufferOS.write(buffer, 0, len);
            }
            bufferOS.close();
            bufferIS.close();
        } else {
            fos = new FileOutputStream(file);
            BufferedOutputStream bufferOS = new BufferedOutputStream(fos, bufferSize);
            CipherInputStream cipherInputStream = new CipherInputStream(new FileInputStream(data), cipher);
            BufferedInputStream bufferIS = new BufferedInputStream(cipherInputStream, bufferSize);
            int len = 0;
            while ((len = bufferIS.read(buffer)) > 0) {
                bufferOS.write(buffer, 0, len);
            }
            bufferOS.close();
            bufferIS.close();
        }
    }

    public boolean createCertObject(byte[] dn, byte[] certData, byte[] keyId) throws PKIException {
        throw new UnsupportedOperationException("Method createCertObject() not yet implemented in JSOFT_LIB.");
    }

    public boolean destroyCertObject(byte[] dn, byte[] keyId) throws PKIException {
        throw new UnsupportedOperationException("Method destroyCertObject() not yet implemented in JSOFT_LIB.");
    }

    public byte[] getCertObject(byte[] keyId) throws PKIException {
        throw new UnsupportedOperationException("Method getCertObject() not yet implemented in JSOFT_LIB.");
    }
}

