/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.BEROctetStringGenerator;
import com.cfca.util.pki.asn1.BERSequenceGenerator;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSequenceGenerator;
import com.cfca.util.pki.asn1.cms.CMSObjectIdentifiers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class CMSCompressedDataStreamGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";

    public OutputStream open(OutputStream out, String compressionOID) throws IOException {
        return this.open(out, CMSObjectIdentifiers.data.getId(), compressionOID);
    }

    public OutputStream open(OutputStream out, String contentOID, String compressionOID) throws IOException {
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.compressedData);
        BERSequenceGenerator cGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        cGen.addObject(new DERInteger(0));
        DERSequenceGenerator algGen = new DERSequenceGenerator(cGen.getRawOutputStream());
        algGen.addObject(new DERObjectIdentifier(ZLIB));
        algGen.close();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(cGen.getRawOutputStream());
        eiGen.addObject(new DERObjectIdentifier(contentOID));
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(eiGen.getRawOutputStream(), 0, true);
        return new CmsCompressedOutputStream(new DeflaterOutputStream(octGen.getOctetOutputStream()), sGen, cGen, eiGen);
    }

    private class CmsCompressedOutputStream
    extends OutputStream {
        private DeflaterOutputStream _out;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _eiGen;

        CmsCompressedOutputStream(DeflaterOutputStream out, BERSequenceGenerator sGen, BERSequenceGenerator cGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._sGen = sGen;
            this._cGen = cGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            this._cGen.close();
            this._sGen.close();
        }
    }
}

