/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.BERConstructedOctetString;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.cms.ContentInfo;
import com.cfca.util.pki.asn1.cms.EncryptedContentInfo;
import com.cfca.util.pki.asn1.cms.EnvelopedData;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.param.CBCParam;
import com.cfca.util.pki.cms.CMSEnvelopedData;
import com.cfca.util.pki.cms.CMSEnvelopedDataStreamGenerator;
import com.cfca.util.pki.cms.CMSEnvelopedGenerator;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSProcessable;
import com.cfca.util.pki.pkcs.PKCS7EnvelopedData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    private Session session = null;

    public CMSEnvelopedDataGenerator(Session session) {
        this.session = session;
    }

    public CMSEnvelopedData generate(CMSProcessable content, Mechanism encryptMech) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, PKIException {
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        AlgorithmIdentifier encAlgId = null;
        BERConstructedOctetString encContent = null;
        JKey sessionKey = null;
        try {
            Cipher cipher = Cipher.getInstance(encryptMech.getMechanismType(), "BC");
            try {
                sessionKey = CMSEnvelopedDataStreamGenerator.getSessionKey(encryptMech, this.session);
            }
            catch (PKIException ex1) {
                throw new PKIException("850623", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex1);
            }
            if (encryptMech.getMechanismType().indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)encryptMech.getParam();
                if (cbcParam == null) {
                    throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(1, Parser.convertKey(sessionKey), iv);
            } else {
                cipher.init(1, Parser.convertKey(sessionKey));
            }
            DERObjectIdentifier tOID = (DERObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(encryptMech.getMechanismType());
            try {
                encAlgId = CMSEnvelopedDataStreamGenerator.getAlgorithmIdentifier(encryptMech, tOID);
            }
            catch (Exception ex) {
                throw new PKIException("850623", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            CipherOutputStream cOut = new CipherOutputStream(bOut, cipher);
            content.write(cOut);
            cOut.close();
            encContent = new BERConstructedOctetString(bOut.toByteArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameters invalid.", e);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
        Iterator it = this.recipientInfs.iterator();
        while (it.hasNext()) {
            CMSEnvelopedGenerator.RecipientInf recipient = (CMSEnvelopedGenerator.RecipientInf)it.next();
            try {
                recipientInfos.add(recipient.toRecipientInfo(sessionKey, this.session));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for algorithm.", e);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("error making encrypted content.", e);
            }
        }
        EncryptedContentInfo eci = new EncryptedContentInfo(PKCSObjectIdentifiers.data, encAlgId, encContent);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(recipientInfos), eci, null));
        return new CMSEnvelopedData(contentInfo);
    }
}

