/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1OctetStringParser;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.ASN1SequenceParser;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.ASN1SetParser;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.cms.AttributeTable;
import com.cfca.util.pki.asn1.cms.EncryptedContentInfoParser;
import com.cfca.util.pki.asn1.cms.EnvelopedDataParser;
import com.cfca.util.pki.asn1.cms.KEKRecipientInfo;
import com.cfca.util.pki.asn1.cms.KeyAgreeRecipientInfo;
import com.cfca.util.pki.asn1.cms.KeyTransRecipientInfo;
import com.cfca.util.pki.asn1.cms.PasswordRecipientInfo;
import com.cfca.util.pki.asn1.cms.RecipientInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cms.CMSContentInfoParser;
import com.cfca.util.pki.cms.CMSEnvelopedHelper;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.KEKRecipientInformation;
import com.cfca.util.pki.cms.KeyAgreeRecipientInformation;
import com.cfca.util.pki.cms.KeyTransRecipientInformation;
import com.cfca.util.pki.cms.PasswordRecipientInformation;
import com.cfca.util.pki.cms.RecipientInformation;
import com.cfca.util.pki.cms.RecipientInformationStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class CMSEnvelopedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore _recipientInfoStore;
    EnvelopedDataParser _envelopedData = new EnvelopedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier _encAlg;
    private AttributeTable _unprotectedAttributes;
    private boolean _attrNotRead = true;

    public CMSEnvelopedDataParser(byte[] envelopedData) throws CMSException, IOException {
        this(new ByteArrayInputStream(envelopedData));
    }

    public CMSEnvelopedDataParser(InputStream envelopedData) throws CMSException, IOException {
        super(envelopedData);
        ASN1SetParser s = this._envelopedData.getRecipientInfos();
        ArrayList<RecipientInfo> baseInfos = new ArrayList<RecipientInfo>();
        ASN1Set set = ASN1Set.getInstance(s.getDERObject());
        Enumeration en = set.getObjects();
        while (en.hasMoreElements()) {
            baseInfos.add(RecipientInfo.getInstance(en.nextElement()));
        }
        EncryptedContentInfoParser encInfo = this._envelopedData.getEncryptedContentInfo();
        this._encAlg = encInfo.getContentEncryptionAlgorithm();
        ArrayList<RecipientInformation> infos = new ArrayList<RecipientInformation>();
        Iterator it = baseInfos.iterator();
        InputStream dataStream = ((ASN1OctetStringParser)encInfo.getEncryptedContent(4)).getOctetStream();
        while (it.hasNext()) {
            RecipientInfo info = (RecipientInfo)it.next();
            if (info.getInfo() instanceof KeyTransRecipientInfo) {
                infos.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)info.getInfo(), this._encAlg, dataStream));
                continue;
            }
            if (info.getInfo() instanceof KEKRecipientInfo) {
                infos.add(new KEKRecipientInformation((KEKRecipientInfo)info.getInfo(), this._encAlg, dataStream));
                continue;
            }
            if (info.getInfo() instanceof KeyAgreeRecipientInfo) {
                infos.add(new KeyAgreeRecipientInformation((KeyAgreeRecipientInfo)info.getInfo(), this._encAlg, dataStream));
                continue;
            }
            if (!(info.getInfo() instanceof PasswordRecipientInfo)) continue;
            infos.add(new PasswordRecipientInformation((PasswordRecipientInfo)info.getInfo(), this._encAlg, dataStream));
        }
        this._recipientInfoStore = new RecipientInformationStore(infos);
    }

    public String getEncryptionAlgOID() {
        return this._encAlg.getObjectId().toString();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this._encAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getEncryptionAlgOID(), this.getEncryptionAlgParams(), provider);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this._recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() throws IOException {
        if (this._unprotectedAttributes == null && this._attrNotRead) {
            ASN1SetParser set = this._envelopedData.getUnprotectedAttrs();
            this._attrNotRead = false;
            if (set != null) {
                DEREncodable o;
                ASN1EncodableVector v = new ASN1EncodableVector();
                while ((o = set.readObject()) != null) {
                    ASN1SequenceParser seq = (ASN1SequenceParser)o;
                    v.add(seq.getDERObject());
                }
                this._unprotectedAttributes = new AttributeTable(new DERSet(v));
            }
        }
        return this._unprotectedAttributes;
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(obj);
            return bOut.toByteArray();
        }
        return null;
    }
}

