/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.BEROctetStringGenerator;
import com.cfca.util.pki.asn1.BERSequenceGenerator;
import com.cfca.util.pki.asn1.BERSet;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.cms.CMSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.lib.JSoftLib;
import com.cfca.util.pki.cipher.param.CBCParam;
import com.cfca.util.pki.cms.CMSEnvelopedDataParser;
import com.cfca.util.pki.cms.CMSEnvelopedGenerator;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.RecipientInformation;
import com.cfca.util.pki.cms.RecipientInformationStore;
import com.cfca.util.pki.pkcs.PKCS12;
import com.cfca.util.pki.pkcs.PKCS7EnvelopedData;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;

public class CMSEnvelopedDataStreamGenerator
extends CMSEnvelopedGenerator {
    private Object _originatorInfo = null;
    private Object _unprotectedAttributes = null;
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;
    private Session session = null;

    public CMSEnvelopedDataStreamGenerator(Session session) {
        this.session = session;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean berEncodeRecipientSet) {
        this._berEncodeRecipientSet = berEncodeRecipientSet;
    }

    private DERInteger getVersion() {
        if (this._originatorInfo != null || this._unprotectedAttributes != null) {
            return new DERInteger(2);
        }
        return new DERInteger(0);
    }

    public OutputStream open(OutputStream out, Mechanism encryptionAlg) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, PKIException {
        JKey encKey = null;
        try {
            encKey = CMSEnvelopedDataStreamGenerator.getSessionKey(encryptionAlg, this.session);
        }
        catch (PKIException ex) {
            throw new PKIException("850620", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0c\u4ea7\u751f\u4f1a\u8bdd\u5bc6\u94a5\u5931\u8d25", ex);
        }
        Iterator it = this.recipientInfs.iterator();
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        while (it.hasNext()) {
            CMSEnvelopedGenerator.RecipientInf recipient = (CMSEnvelopedGenerator.RecipientInf)it.next();
            try {
                recipientInfos.add(recipient.toRecipientInfo(encKey, this.session));
            }
            catch (Exception e) {
                throw new PKIException("850651", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u63a5\u6536\u8005\u5931\u8d25", e);
            }
        }
        return this.open(out, encryptionAlg, encKey, recipientInfos);
    }

    protected OutputStream open(OutputStream out, Mechanism encryptionAlg, JKey encKey, ASN1EncodableVector recipientInfos) throws PKIException {
        try {
            BERSequenceGenerator cGen = new BERSequenceGenerator(out);
            cGen.addObject(CMSObjectIdentifiers.envelopedData);
            BERSequenceGenerator envGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
            envGen.addObject(this.getVersion());
            if (this._berEncodeRecipientSet) {
                envGen.getRawOutputStream().write(new BERSet(recipientInfos).getEncoded());
            } else {
                envGen.getRawOutputStream().write(new DERSet(recipientInfos).getEncoded());
            }
            Cipher cipher = Cipher.getInstance(encryptionAlg.getMechanismType(), "BC");
            if (encryptionAlg.getMechanismType().indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)encryptionAlg.getParam();
                if (cbcParam == null) {
                    throw new PKIException("CBC\u53c2\u6570\u4e3a\u7a7a");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(1, Parser.convertKey(encKey), iv);
            } else {
                cipher.init(1, Parser.convertKey(encKey));
            }
            BERSequenceGenerator eiGen = new BERSequenceGenerator(envGen.getRawOutputStream());
            eiGen.addObject(PKCSObjectIdentifiers.data);
            DERObjectIdentifier tOID = (DERObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(encryptionAlg.getMechanismType());
            AlgorithmIdentifier encAlgId = null;
            try {
                encAlgId = CMSEnvelopedDataStreamGenerator.getAlgorithmIdentifier(encryptionAlg, tOID);
            }
            catch (Exception ex) {
                throw new PKIException("850623", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", ex);
            }
            eiGen.getRawOutputStream().write(encAlgId.getEncoded());
            BEROctetStringGenerator octGen = new BEROctetStringGenerator(eiGen.getRawOutputStream(), 0, false);
            if (this.session instanceof JSoftLib) {
                CipherOutputStream cOut = this._bufferSize != 0 ? new CipherOutputStream(octGen.getOctetOutputStream(new byte[this._bufferSize]), cipher) : new CipherOutputStream(octGen.getOctetOutputStream(), cipher);
                return new CmsEnvelopedDataOutputStream(cOut, cGen, envGen, eiGen);
            }
            OutputStream cOut = null;
            cOut = this._bufferSize != 0 ? octGen.getOctetOutputStream(new byte[this._bufferSize]) : octGen.getOctetOutputStream();
            return new CmsHardEnvelopedDataOutputStream(cOut, cGen, envGen, eiGen);
        }
        catch (Exception e) {
            throw new PKIException("850623", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u5931\u8d25", e);
        }
    }

    public static JKey getSessionKey(Mechanism contentEncryptionAlg, Session session) throws PKIException {
        JKey sessionKey = null;
        if (contentEncryptionAlg.getMechanismType().toUpperCase().indexOf("CBC") != -1) {
            CBCParam cbcParam = (CBCParam)contentEncryptionAlg.getParam();
            if (cbcParam == null) {
                throw new PKIException("850622", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0cCBC\u53c2\u6570\u4e3a\u7a7a");
            }
            if (contentEncryptionAlg.getMechanismType().equals("DES/CBC/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("DES"), 64);
            } else if (contentEncryptionAlg.getMechanismType().equals("DESede/CBC/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("DESede"), 192);
            } else if (contentEncryptionAlg.getMechanismType().equals("RC2/CBC/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("RC2"), 128);
            } else if (contentEncryptionAlg.getMechanismType().equals("IDEA/CBC/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("IDEA"), 128);
            } else if (contentEncryptionAlg.getMechanismType().equals("AES/CBC/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("AES"), 128);
            }
        } else if (contentEncryptionAlg.getMechanismType().toUpperCase().indexOf("ECB") != -1) {
            if (contentEncryptionAlg.getMechanismType().equals("DES/ECB/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("DES"), 64);
            } else if (contentEncryptionAlg.getMechanismType().equals("DESede/ECB/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("DESede"), 192);
            } else if (contentEncryptionAlg.getMechanismType().equals("RC2/ECB/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("RC2"), 128);
            } else if (contentEncryptionAlg.getMechanismType().equals("IDEA/ECB/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("IDEA"), 128);
            } else if (contentEncryptionAlg.getMechanismType().equals("AES/ECB/PKCS7Padding")) {
                sessionKey = session.generateKey(new Mechanism("AES"), 128);
            }
        } else if (contentEncryptionAlg.getMechanismType().toUpperCase().equals("RC4")) {
            sessionKey = session.generateKey(new Mechanism("RC4"), 128);
        }
        return sessionKey;
    }

    public static AlgorithmIdentifier getAlgorithmIdentifier(Mechanism contentEncryptionAlg, DERObjectIdentifier tOID) throws PKIException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(tOID, new DERNull());
        if (contentEncryptionAlg.getMechanismType().toUpperCase().indexOf("CBC") != -1) {
            Object param = contentEncryptionAlg.getParam();
            if (param == null) {
                throw new PKIException("850622", "\u4ea7\u751f\u6570\u5b57\u4fe1\u5c01\u6570\u636e\uff0cCBC\u53c2\u6570\u4e3a\u7a7a");
            }
            CBCParam cbcParam = (CBCParam)contentEncryptionAlg.getParam();
            DEROctetString doct = new DEROctetString(cbcParam.getIv());
            algorithmIdentifier = new AlgorithmIdentifier(tOID, doct);
            return algorithmIdentifier;
        }
        return algorithmIdentifier;
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            CMSEnvelopedDataStreamGenerator edGen = new CMSEnvelopedDataStreamGenerator(session);
            PKCS12 p12Receive2 = new PKCS12();
            p12Receive2.load("d:/temp/kaifabu.pfx");
            p12Receive2.decrypt("1".toCharArray());
            JKey revPrvKey2 = p12Receive2.getPrivateKey();
            X509Cert receiveCert2 = p12Receive2.getCertificate();
            edGen.addKeyTransRecipient(receiveCert2);
            FileOutputStream fos = new FileOutputStream("D:/temp/cmsEnvelopBuf");
            OutputStream out = edGen.open(fos, new Mechanism("DES/CBC/PKCS7Padding", new CBCParam()));
            BufferedOutputStream bfOut = new BufferedOutputStream(out, 300);
            byte[] data = new byte[2000];
            int i = 0;
            while (i != 2000) {
                data[i] = 1;
                ++i;
            }
            i = 0;
            while (i != 2000) {
                bfOut.write(data[i]);
                ++i;
            }
            bfOut.close();
            FileInputStream fis = new FileInputStream("D:/temp/cmsEnvelopBuf");
            CMSEnvelopedDataParser ep = new CMSEnvelopedDataParser(fis);
            RecipientInformationStore recipients = ep.getRecipientInfos();
            Collection c = recipients.getRecipients();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                RecipientInformation recipient = (RecipientInformation)it.next();
                CMSTypedStream recData = recipient.getContentStream(Parser.convertPrivateKey(revPrvKey2), "BC");
                boolean verify = Arrays.equals(data, CMSEnvelopedDataStreamGenerator.streamToByteArray(recData.getContentStream()));
                int n = 99;
            }
            ep.close();
        }
        catch (Exception ex) {
            System.out.println("error=" + ex.toString());
        }
    }

    private static byte[] streamToByteArray(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((ch = in.read()) >= 0) {
            bOut.write(ch);
        }
        return bOut.toByteArray();
    }

    private class CmsEnvelopedDataOutputStream
    extends OutputStream {
        private CipherOutputStream _out;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _envGen;
        private BERSequenceGenerator _eiGen;

        public CmsEnvelopedDataOutputStream(CipherOutputStream out, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._cGen = cGen;
            this._envGen = envGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            this._envGen.close();
            this._cGen.close();
        }
    }

    private class CmsHardEnvelopedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _envGen;
        private BERSequenceGenerator _eiGen;

        public CmsHardEnvelopedDataOutputStream(OutputStream out, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._cGen = cGen;
            this._envGen = envGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            this._envGen.close();
            this._cGen.close();
        }
    }
}

