/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Object;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.cms.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.cms.KEKIdentifier;
import com.cfca.util.pki.asn1.cms.KeyTransRecipientInfo;
import com.cfca.util.pki.asn1.cms.OriginatorIdentifierOrKey;
import com.cfca.util.pki.asn1.cms.RecipientIdentifier;
import com.cfca.util.pki.asn1.cms.RecipientInfo;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.asn1.x509.TBSCertificateStructure;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cms.CMSEnvelopedHelper;
import com.cfca.util.pki.cms.CMSException;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;

public class CMSEnvelopedGenerator {
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des3CBCEncryption.getId();
    public static final String DES_EDE3_EBC = PKCSObjectIdentifiers.des3Encryption.getId();
    public static final String DES_ECB = PKCSObjectIdentifiers.desEncryption.getId();
    public static final String DES_CBC = PKCSObjectIdentifiers.desCBCEncryption.getId();
    public static final String RC4 = PKCSObjectIdentifiers.rc4Encryption.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_ECB = "2.16.840.1.101.3.4.1.1";
    public static final String AES128_CBC = "2.16.840.1.101.3.4.1.2";
    private static final CMSEnvelopedHelper HELPER = CMSEnvelopedHelper.INSTANCE;
    List recipientInfs = new ArrayList();
    SecureRandom rand = new SecureRandom();

    public void addKeyTransRecipient(X509Cert cert) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(cert));
    }

    public void addKeyTransRecipient(JKey key, byte[] subKeyId) throws IllegalArgumentException {
        try {
            this.recipientInfs.add(new RecipientInf(key, new DEROctetString(subKeyId)));
        }
        catch (PKIException pKIException) {
            // empty catch block
        }
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String encryptionOID, AlgorithmParameters params) throws IOException {
        DERObject asn1Params;
        if (params != null) {
            ASN1InputStream aIn = new ASN1InputStream(params.getEncoded("ASN.1"));
            asn1Params = aIn.readObject();
        } else {
            asn1Params = new DERNull();
        }
        AlgorithmIdentifier encAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(encryptionOID), asn1Params);
        return encAlgId;
    }

    protected AlgorithmParameters generateParameters(String encryptionOID, SecretKey encKey, String encProvider) throws NoSuchProviderException, CMSException {
        try {
            AlgorithmParameterGenerator pGen = AlgorithmParameterGenerator.getInstance(encryptionOID, encProvider);
            if (encryptionOID.equals(RC2_CBC)) {
                byte[] iv = new byte[8];
                this.rand.setSeed(System.currentTimeMillis());
                this.rand.nextBytes(iv);
                try {
                    pGen.init(new RC2ParameterSpec(encKey.getEncoded().length * 8, iv));
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CMSException("parameters generation error: " + e, e);
                }
            }
            return pGen.generateParameters();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    protected class RecipientInf {
        X509Cert cert;
        AlgorithmIdentifier keyEncAlg;
        JKey pubKey;
        ASN1OctetString subKeyId;
        SecretKey secKey;
        KEKIdentifier secKeyId;
        OriginatorIdentifierOrKey originator;
        ASN1OctetString ukm;
        AlgorithmIdentifier derivationAlg;

        RecipientInf(X509Cert cert) {
            this.cert = cert;
            try {
                this.pubKey = cert.getPublicKey();
            }
            catch (PKIException pKIException) {
                // empty catch block
            }
            TBSCertificateStructure tbs = null;
            try {
                tbs = TBSCertificateStructure.getInstance(ASN1Object.fromByteArray(cert.getTBSCertificate()));
            }
            catch (PKIException pKIException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SubjectPublicKeyInfo info = tbs.getSubjectPublicKeyInfo();
            this.keyEncAlg = info.getAlgorithmId();
        }

        RecipientInf(JKey pubKey, ASN1OctetString subKeyId) throws PKIException {
            this.pubKey = pubKey;
            this.subKeyId = subKeyId;
            try {
                PublicKey javaPubKey = Parser.convertPublicKey(pubKey);
                SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(javaPubKey.getEncoded()));
                this.keyEncAlg = info.getAlgorithmId();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't extract key algorithm from this key");
            }
            catch (PKIException ex) {
                throw ex;
            }
        }

        RecipientInf(SecretKey secKey, KEKIdentifier secKeyId) {
            this.secKey = secKey;
            this.secKeyId = secKeyId;
            if (secKey.getAlgorithm().startsWith("DES")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), new DERNull());
            } else if (secKey.getAlgorithm().startsWith("RC2")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), new DERInteger(58));
            } else {
                throw new IllegalArgumentException("unknown algorithm");
            }
        }

        public RecipientInf(SecretKey secretKey, String algorithm, String wrapOid, OriginatorIdentifierOrKey originator, X509Cert cert) {
            ASN1EncodableVector params = new ASN1EncodableVector();
            params.add(new DERObjectIdentifier(wrapOid));
            params.add(DERNull.INSTANCE);
            this.secKey = secretKey;
            this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier(algorithm), new DERSequence(params));
            this.originator = originator;
            this.cert = cert;
        }

        public RecipientInf(SecretKey secretKey, AlgorithmIdentifier derivationAlg) {
            this.secKey = secretKey;
            this.derivationAlg = derivationAlg;
        }

        RecipientInfo toRecipientInfo(JKey key, Session session) throws IOException, GeneralSecurityException, PKIException {
            byte[] encryptedKey = session.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), this.pubKey, key.getKey());
            DEROctetString encKey = new DEROctetString(encryptedKey);
            if (this.cert != null) {
                ASN1InputStream aIn = null;
                try {
                    aIn = new ASN1InputStream(this.cert.getTBSCertificate());
                }
                catch (PKIException pKIException) {
                    // empty catch block
                }
                TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
                IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
                return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(encSid), this.keyEncAlg, encKey));
            }
            return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(this.subKeyId), this.keyEncAlg, encKey));
        }
    }
}

