/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.crl;

import com.cfca.util.pki.PKIConstant;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.CertificateList;
import com.cfca.util.pki.asn1.x509.TBSCertList;
import com.cfca.util.pki.asn1.x509.Time;
import com.cfca.util.pki.asn1.x509.X509Extension;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.extension.AuthorityKeyIdentifierExt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;

public class X509CRL {
    private CertificateList certList = null;
    private TBSCertList.CRLEntry[] crlEntries = null;

    public X509CRL(byte[] derCRL) throws PKIException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(derCRL);
            ASN1InputStream dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certList = new CertificateList(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
        }
        catch (Exception ex) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25");
        }
    }

    public X509CRL(CertificateList certList) {
        this.certList = certList;
        this.crlEntries = certList.getTBSCertList().getRevokedCertificates();
    }

    public X509CRL(InputStream is) throws PKIException {
        try {
            ASN1InputStream dis = new ASN1InputStream(is);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certList = new CertificateList(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
            is.close();
        }
        catch (Exception ex) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25");
        }
    }

    public CertificateList getCertificateList() {
        return this.certList;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = Parser.writeDERObj2Bytes(this.certList);
        }
        catch (Exception ex) {
            throw new PKIException("850417", "\u83b7\u5f97CRL\u7f16\u7801\u5931\u8d25", ex);
        }
        return encoded;
    }

    public int getVersion() {
        return this.certList.getVersion();
    }

    public String getIssuer() {
        X509Name x509Issuer = this.certList.getIssuer();
        return x509Issuer.toString();
    }

    public String getSignatureAlgName() {
        AlgorithmIdentifier algID = this.certList.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        boolean isContain = PKIConstant.oid2SigAlgName.containsKey(oid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(oid);
        return sigAlgName;
    }

    public String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.certList.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        return oid.getId();
    }

    public Date getThisUpdate() {
        Time thisUpdate = this.certList.getThisUpdate();
        return thisUpdate.getDate();
    }

    public Date getNextUpdate() {
        Time nextUpdate = this.certList.getNextUpdate();
        if (nextUpdate == null) {
            return null;
        }
        return nextUpdate.getDate();
    }

    public byte[] getSignature() {
        DERBitString derBit = this.certList.getSignature();
        return derBit.getBytes();
    }

    public byte[] getTBSCertList() throws PKIException {
        byte[] bTBSCertList = null;
        try {
            bTBSCertList = Parser.writeDERObj2Bytes(this.certList.getTBSCertList().getDERObject());
        }
        catch (Exception e) {
            throw new PKIException("850415", "TBS CRL\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", e);
        }
        return bTBSCertList;
    }

    public AuthorityKeyIdentifierExt getAuthorityKeyIdentifierExt() throws PKIException {
        X509Extension extension;
        DERObject derObj;
        block3: {
            derObj = null;
            try {
                derObj = this.certList.getDERObject();
                TBSCertList tbsCertList = this.certList.getTBSCertList();
                extension = tbsCertList.getExtensions().getExtension(X509Extensions.AuthorityKeyIdentifier);
                if (extension != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new PKIException("850417", "\u83b7\u5f97CRL\u7f16\u7801\u5931\u8d25", e);
            }
        }
        byte[] data = extension.getValue().getOctets();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream derIns = new ASN1InputStream(bis);
        derObj = derIns.readObject();
        AuthorityKeyIdentifierExt authorityKeyIdentifier = new AuthorityKeyIdentifierExt((ASN1Sequence)derObj);
        return authorityKeyIdentifier;
    }

    public boolean isRevoke(String certSerialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        BigInteger sn = new BigInteger(certSerialNumber, 16);
        int i = 0;
        while (i < this.crlEntries.length) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (sn.equals(tmpSN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRevoke(BigInteger certSerialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        int i = 0;
        while (i < this.crlEntries.length) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (certSerialNumber.equals(tmpSN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRevoke(X509Cert cert) {
        if (this.crlEntries == null) {
            return false;
        }
        BigInteger sn = cert.getSerialNumber();
        int i = 0;
        while (i < this.crlEntries.length) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (sn.equals(tmpSN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean verify(JKey pubKey, Session session) throws PKIException {
        DERObjectIdentifier oid = this.certList.getSignatureAlgorithm().getObjectId();
        Mechanism mechanism = null;
        if (oid.equals(PKCSObjectIdentifiers.md2WithRSAEncryption)) {
            mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption)) {
            mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithECEncryption)) {
            mechanism = new Mechanism("SHA1withECDSA");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithDSA)) {
            mechanism = new Mechanism("SHA1withDSA");
        } else {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5:" + oid.getId());
        }
        byte[] tbsData = this.getTBSCertList();
        boolean verify = false;
        try {
            verify = session.verifySign(mechanism, pubKey, tbsData, this.getSignature());
        }
        catch (Exception ex) {
            throw new PKIException("06", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return verify;
    }
}

