/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.encoders;

import com.cfca.util.pki.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int i = 0;
        while (i < this.encodingTable.length) {
            this.decodingTable[this.encodingTable[i]] = (byte)i;
            ++i;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int i = off;
        while (i < off + length) {
            int v = data[i] & 0xFF;
            out.write(this.encodingTable[v >>> 4]);
            out.write(this.encodingTable[v & 0xF]);
            ++i;
        }
        return length * 2;
    }

    private boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    /*
     * Unable to fully structure code
     */
    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        outLen = 0;
        end = off + length;
        while (end > off) {
            if (!this.ignore((char)data[end - 1])) break;
            --end;
        }
        i = off;
        ** GOTO lbl19
        {
            ++i;
            do {
                if (i < end && this.ignore((char)data[i])) continue block1;
                b1 = this.decodingTable[data[i++]];
                while (i < end && this.ignore((char)data[i])) {
                    ++i;
                }
                b2 = this.decodingTable[data[i++]];
                out.write(b1 << 4 | b2);
                ++outLen;
lbl19:
                // 2 sources

            } while (i < end);
        }
        return outLen;
    }

    /*
     * Unable to fully structure code
     */
    public int decode(String data, OutputStream out) throws IOException {
        length = 0;
        end = data.length();
        while (end > 0) {
            if (!this.ignore(data.charAt(end - 1))) break;
            --end;
        }
        i = 0;
        ** GOTO lbl19
        {
            ++i;
            do {
                if (i < end && this.ignore(data.charAt(i))) continue block1;
                b1 = this.decodingTable[data.charAt(i++)];
                while (i < end && this.ignore(data.charAt(i))) {
                    ++i;
                }
                b2 = this.decodingTable[data.charAt(i++)];
                out.write(b1 << 4 | b2);
                ++length;
lbl19:
                // 2 sources

            } while (i < end);
        }
        return length;
    }
}

