/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.x509.AccessDescription;
import com.cfca.util.pki.asn1.x509.AuthorityInformationAccess;
import com.cfca.util.pki.asn1.x509.GeneralName;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.extension.AbstractStandardExtension;
import com.cfca.util.pki.extension.AccessDescriptionExt;
import java.util.Vector;

public class AuthorityInformationAccessExt
extends AbstractStandardExtension {
    public static final int URI_TYPE_NAME = 6;
    public static final int DN_TYPE_NAME = 4;
    private Vector accessDescriptionExts = null;

    public AuthorityInformationAccessExt() {
        this.OID = X509Extensions.AuthorityInfoAccess.getId();
        this.critical = false;
        this.accessDescriptionExts = new Vector();
    }

    public AuthorityInformationAccessExt(ASN1Sequence asn1Sequence) {
        this.OID = X509Extensions.AuthorityInfoAccess.getId();
        this.accessDescriptionExts = new Vector();
        int size = asn1Sequence.size();
        int i = 0;
        while (i < size) {
            ASN1Sequence seq = (ASN1Sequence)asn1Sequence.getObjectAt(i);
            DERObjectIdentifier method = (DERObjectIdentifier)seq.getObjectAt(0);
            AccessDescriptionExt accessDescription = new AccessDescriptionExt();
            accessDescription.setAccessMethod(method.getId());
            ASN1TaggedObject tagObj = (ASN1TaggedObject)seq.getObjectAt(1);
            String location = GeneralName.GeneralNameToString(tagObj);
            accessDescription.setAccessLocation(location);
            this.accessDescriptionExts.add(accessDescription);
            ++i;
        }
    }

    public void addAccessDescription(AccessDescriptionExt accessDescription) {
        this.accessDescriptionExts.add(accessDescription);
    }

    public AccessDescriptionExt[] getAccessDescription() {
        AccessDescriptionExt[] accessDescriptions = new AccessDescriptionExt[this.accessDescriptionExts.size()];
        return this.accessDescriptionExts.toArray(accessDescriptions);
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public byte[] encode() throws PKIException {
        Vector<AccessDescription> vAccessDesExt = new Vector<AccessDescription>();
        int i = 0;
        while (i < this.accessDescriptionExts.size()) {
            AccessDescriptionExt accessDesExt = (AccessDescriptionExt)this.accessDescriptionExts.get(i);
            DERObjectIdentifier idAccessMethod = new DERObjectIdentifier(accessDesExt.getAccessMethod());
            GeneralName nameAccessLocation = null;
            if (accessDesExt.getAccessLocationType() == 6) {
                DERIA5String ia5DPName = new DERIA5String(accessDesExt.getAccessLocation().getBytes());
                nameAccessLocation = new GeneralName(ia5DPName, 6);
            } else if (accessDesExt.getAccessLocationType() == 4) {
                nameAccessLocation = new GeneralName(new X509Name(accessDesExt.getAccessLocation()));
            }
            AccessDescription accessDes = new AccessDescription();
            accessDes.setAccessMethod(idAccessMethod);
            accessDes.setAccessLocation(nameAccessLocation);
            vAccessDesExt.add(accessDes);
            ++i;
        }
        AuthorityInformationAccess authInfoAccess = new AuthorityInformationAccess(vAccessDesExt);
        DEROctetString octetValue = new DEROctetString(authInfoAccess.getDERObject());
        return octetValue.getOctets();
    }
}

