/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1SequenceExt;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.x509.CertificatePolicies;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;
import com.cfca.util.pki.extension.PolicyInformationExt;
import java.util.Vector;

public class CertificatePoliciesExt
extends AbstractStandardExtension {
    public static final int CONTENT_TYPE_IA5STRING = 0;
    public static final int CONTENT_TYPE_BMPSTRING = 1;
    public static final int CONTENT_TYPE_UTF8STRING = 2;
    public static final int CONTENT_TYPE_VISIBLESTRING = 3;
    Vector seq_Policyinformation = new Vector();

    public CertificatePoliciesExt() {
        this.OID = X509Extensions.CertificatePolicies.getId();
        this.critical = false;
    }

    public CertificatePoliciesExt(String value) {
        this.OID = X509Extensions.CertificatePolicies.getId();
        this.critical = false;
        this.addPolicy(value);
    }

    public CertificatePoliciesExt(ASN1Sequence asn1Sequence) {
        this.OID = X509Extensions.CertificatePolicies.getId();
        int i = 0;
        while (i < asn1Sequence.size()) {
            this.seq_Policyinformation.add(new PolicyInformationExt((ASN1Sequence)asn1Sequence.getObjectAt(i)));
            ++i;
        }
    }

    public int GetPolicyCount() {
        return this.seq_Policyinformation.size();
    }

    public PolicyInformationExt getPolicy(int index) {
        return (PolicyInformationExt)this.seq_Policyinformation.get(index);
    }

    public void addPolicy(String value) {
        this.seq_Policyinformation.add(new PolicyInformationExt(value));
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public byte[] encode() throws PKIException {
        ASN1SequenceExt tempASN1Seq = new ASN1SequenceExt();
        int i = 0;
        while (i < this.seq_Policyinformation.size()) {
            tempASN1Seq.addObject(((PolicyInformationExt)this.seq_Policyinformation.get(i)).getSeqPolicyInformation());
            ++i;
        }
        return new DEROctetString(new CertificatePolicies(tempASN1Seq).getDERObject()).getOctets();
    }
}

