/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.x509.InsuranceNumber;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;

public class InsuranceNumberExt
extends AbstractStandardExtension {
    private String insurancenumber = null;

    public InsuranceNumberExt() {
        this.OID = X509Extensions.InsuranceNumber.getId();
        this.critical = false;
    }

    public InsuranceNumberExt(DERPrintableString obj) {
        this.OID = X509Extensions.InsuranceNumber.getId();
        this.insurancenumber = obj.getString();
    }

    public InsuranceNumberExt(String value) {
        this.OID = X509Extensions.InsuranceNumber.getId();
        this.critical = false;
        this.insurancenumber = value;
    }

    public void SetInsuranceNumber(String value) {
        this.insurancenumber = value;
    }

    public String GetInsuranceNumber() {
        return this.insurancenumber;
    }

    public byte[] encode() throws PKIException {
        if (this.insurancenumber == null) {
            throw new PKIException("850503", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new InsuranceNumber(this.insurancenumber).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

