/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.x509.OrganizationCode;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;

public class OrganizationCodeExt
extends AbstractStandardExtension {
    private String organizationcode = null;

    public OrganizationCodeExt() {
        this.OID = X509Extensions.OrganizationCode.getId();
        this.critical = false;
    }

    public OrganizationCodeExt(DERPrintableString obj) {
        this.OID = X509Extensions.OrganizationCode.getId();
        this.organizationcode = obj.getString();
    }

    public OrganizationCodeExt(String value) {
        this.OID = X509Extensions.OrganizationCode.getId();
        this.critical = false;
        this.organizationcode = value;
    }

    public void SetOrganizationCode(String value) {
        this.organizationcode = value;
    }

    public String GetOrganizationCode() {
        return this.organizationcode;
    }

    public byte[] encode() throws PKIException {
        if (this.organizationcode == null) {
            throw new PKIException("850503", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new OrganizationCode(this.organizationcode).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

